<?php declare(strict_types=1);

namespace App\Form;

use Symfony\Component\Form\AbstractType;
//use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\Extension\Core\Type\EmailType;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\Form\Extension\Core\Type\PasswordType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Validator\Constraints\Email;
use Symfony\Component\Validator\Constraints\NotBlank;

class LoginFormType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            ->add('email', EmailType::class, [
                'label' => 'label_email',
                'required' => true,
                'constraints' => [
                    new NotBlank(['message' => 'msg_empty_field']),
                    new Email(['message' => 'msg_invalid_email']),
                ],
            ])
            ->add('password', PasswordType::class, [
                'label' => 'label_password',
                'required' => true,
                'constraints' => [
                    new NotBlank(['message' => 'msg_empty_field']),
                ],
            ])
            ->add('target', HiddenType::class, [
                'required' => true,
            ])
            /*
            ->add('rememberMe', CheckboxType::class, [
                'label' => 'label_remember_me',
                'required' => false,
            ])
             */
            ->add('submit', SubmitType::class, [
                'label' => 'label_login',
            ]);
    }

    public function getBlockPrefix(): string
    {
        return '';
    }
}
