<?php declare(strict_types=1);

namespace App\LinkGenerator;

use App\Model\DataObject\NamedObjectInterface;
use App\Service\LanguageService;
use App\Tool\Utils;
use Pimcore\Bundle\StaticRoutesBundle\Model\Staticroute;
use Pimcore\Model\DataObject\ClassDefinition\LinkGeneratorInterface;
use Pimcore\Model\DataObject\Concrete;
use Symfony\Component\Routing\Generator\UrlGeneratorInterface;

class NamedObjectLinkGenerator implements LinkGeneratorInterface
{
    public function __construct(
        private UrlGeneratorInterface $router,
        private LanguageService $languageService,
    ) {
    }

    /**
     * @param array<string, mixed> $params
     *
     * @throws \InvalidArgumentException
     * @throws \RuntimeException
     */
    public function generate(object $object, array $params = []): string
    {
        $url = '';

        if (empty($params['locale'])) {
            $language = $this->languageService->getDefaultLanguage();
        } else {
            $language = $params['locale'];
        }

        if (!$object instanceof Concrete) {
            return $url;
        }
        if (!$object instanceof NamedObjectInterface) {
            return $url;
        }

        $className = $object->getClassName();
        $staticRouteKeyBase = $className . '-' . $language;
        $staticRouteKey = ltrim(strtolower(preg_replace('/[A-Z]/', '-$0', $staticRouteKeyBase)), '-');
        if (!Staticroute::getByName($staticRouteKey)) {
            return $url;
        }

        $name = $object->getName($language) ?? '';
        $slug = Utils::webalize(trim($name));
        if (!$slug) {
            return $url;
        }

        $routeParams = [
            'id' => $object->getId(),
            'slug' => $slug,
        ];

        return $this->router->generate($staticRouteKey, $routeParams);
    }
}
