<?php declare(strict_types=1);

namespace App\LinkGenerator;

use App\Model\DataObject\PageObjectInterface;
use App\Service\LanguageService;
use Pimcore\Model\DataObject\ClassDefinition\LinkGeneratorInterface;
use Pimcore\Model\Document\Page;

class PageObjectLinkGenerator implements LinkGeneratorInterface
{
    public function __construct(
        private LanguageService $languageService,
    ) {
    }

    /**
     * @param array<string, mixed> $params
     *
     * @throws \InvalidArgumentException
     * @throws \RuntimeException
     */
    public function generate(object $object, array $params = []): string
    {
        $url = '';
        $language = $params['locale'] ?? null;

        if (empty($params['locale'])) {
            $language = $this->languageService->getDefaultLanguage();
        } else {
            $language = $params['locale'];
        }

        if (!$object instanceof PageObjectInterface) {
            return $url;
        }

        $page = $object->getPage($language);
        if (!$page instanceof Page) {
            return $url;
        }

        return $page->getFullPath();
    }
}
