<?php declare(strict_types=1);

namespace App\Model\Document;

use App\Elasticsearch\Contract\ElasticsearchFulltextInterface;
use App\Elasticsearch\Trait\ElasticsearchTrait;
use App\Tool\Utils;
use Pimcore\Model\Document;

class Page extends Document\Page implements ElasticsearchFulltextInterface
{
    use ElasticsearchTrait;

    /**
     * @throws \Exception
     */
    public function elasticsearchGetFulltextMapping(string $language): array
    {
        return array_merge($this->getElasticsearchBaseData(), [
            'path' => Utils::docUrl($this->getRealFullPath(), $language),
            'title' => $this->getTitle(),
            'description' => $this->getDescription(),
        ]);
    }

    public function elasticsearchGetFulltextContentTemplateName(): string
    {
        return (string)$this->getTemplate();
    }
}
