<?php declare(strict_types=1);

namespace App\Service;

use Symfony\Component\Messenger\Envelope;
use Symfony\Component\Messenger\MessageBusInterface;

class MessageBufferService
{
    /** @var array<object> */
    private array $messages = [];

    public function __construct(
        private readonly MessageBusInterface $messageBus
    ) {
    }

    public function push(object $message): void
    {
        $this->messages[] = $message;
    }

    public function drop(string $messageClass): void
    {
        $this->messages = array_filter($this->messages, fn ($message) => !($message instanceof $messageClass));
    }

    /**
     * @return array<Envelope>
     */
    public function flush(string $messageClass = ''): array
    {
        $dispatched = $skipped = [];

        foreach ($this->messages as $message) {
            $isClassNotMatching = !empty($messageClass) && !($message instanceof $messageClass);

            if ($isClassNotMatching) {
                $skipped[] = $message;

                continue;
            }

            $dispatched[] = $this->messageBus->dispatch($message);
        }

        $this->messages = $skipped;

        return $dispatched;
    }

    public function purge(): void
    {
        $this->messages = [];
    }
}
