<?php

namespace App\Tool\Setup;

use Composer\Script\Event;
use Composer\Util\Filesystem;

class Composer
{
    public static function postCreateProject(Event $event)
    {
        $config = $event->getComposer()->getConfig();
        $rootPath = dirname($config->get('vendor-dir'));
        $projectName = basename($rootPath);

        // init parameters.yml
        //copy($rootPath.'/config/parameters.example.yml', $rootPath.'/config/parameters.yml');

        // create var directories
        $filesystem = new Filesystem();
        $dirsToCreate = ['/var/backup', '/var/search', '/var/cache',
            '/var/tmp', '/var/email', '/var/log', '/var/user-image',
            '/var/log/fileobjects', '/var/log/mail', '/var/recyclebin',
            '/var/sessions', '/var/versions', '/var/versions/asset',
            '/var/versions/document', '/var/versions/object',
            '/var/classes/DataObject', '/var/classes/customlayouts',
            '/public/var/assets', '/public/var/tmp'
        ];
        foreach ($dirsToCreate as $relativeDirectoryPath) {
            if (!file_exists($rootPath.$relativeDirectoryPath)) {
                mkdir($rootPath.$relativeDirectoryPath, 0777, true);
            }
        }

        // init composer
        rename($rootPath.'/composer.tmpl', $rootPath.'/composer.json');

        // init git
        $filesystem->removeDirectory($rootPath.'/.git');
        $filesystem->remove($rootPath.'/.gitignore');
        rename($rootPath.'/.gitignore.tmpl', $rootPath.'/.gitignore');
        $returnVal = null;
        $returnCode = null;
        exec('which git', $returnVal, $returnCode);
        if (empty($returnVal) || $returnCode) {
            fwrite(STDOUT, sprintf(
                "\033[31m Local git repository could not be initialized. Please initialize it manually with remote \033[33m[https://github.com/portadesign/%s.git]\n",
                $projectName
            ));
        } else {
            exec('git init');
            exec(sprintf(
                'git remote add origin https://github.com/portadesign/%s.git',
                $projectName
            ));
            fwrite(STDOUT, sprintf(
                "\033[32m Initialized local git repository with remote \033[33m[https://github.com/portadesign/%s.git]\n",
                $projectName
            ));
        }

        // create database
        $databaseCreated = false;
        exec('which mysql', $returnVal, $returnCode);
        if (empty($returnVal) || $returnCode) {
            fwrite(STDOUT, sprintf(
                "\033[31m Database \033[33m[%s] \033[31mcould not be created. Please create it manually.\n",
                $projectName
            ));
        } else {
            exec(sprintf(
                'mysql --login-path=deployment -e "create database %s character set utf8mb4 collate utf8mb4_general_ci"',
                $projectName
            ), $returnVal, $returnCode);
            if (!$returnCode) {
                fwrite(STDOUT, sprintf(
                    "\033[32m Created database \033[33m[%s]\n",
                    $projectName
                ));
            } else {
                fwrite(STDOUT, sprintf(
                    "\033[31m Database \033[33m[%s] \033[31mcould not be created. Please create it manually.\n",
                    $projectName
                ));
                $databaseCreated = true;
            }
        }

        // .env file
        preg_replace(
            '/###MYSQL_DATABASE###/',
            $projectName,
            file_get_contents($rootPath.'/.env')
        );

        // init readme
        $contents = preg_replace(
            '/###TITLE###/',
            ucfirst($projectName),
            file_get_contents($rootPath.'/README.tmpl')
        );
        $contents2 = preg_replace(
            '/###TITLE_LOWERCASE###/',
            strtolower($projectName),
            $contents
        );
        $repositoryUrl = sprintf('https://github.com/portadesign/%s.git', strtolower($projectName));
        $contents3 = preg_replace(
            '/###REPOSITORY###/',
            $repositoryUrl,
            $contents2
        );
        $fh = fopen($rootPath.'/README.md', 'w');
        fwrite($fh, $contents3);
        fclose($fh);
        fwrite(STDOUT, sprintf("\033[32mGenerated \033[33mREADME.md\n", $projectName));

        // cleanup
        @unlink($rootPath.'/README.tmpl');
    }
}
