<?php declare(strict_types=1);

namespace App\Twig\Extension;

use App\Tool\Utils;
use Pimcore\Model\Document;
use Twig\Extension\AbstractExtension;
use Twig\TwigFunction;

class LanguageSwitcherExtension extends AbstractExtension
{
    public function getFunctions(): array
    {
        return [
            new TwigFunction('get_language_switch', [$this, 'getLanguageSwitch']),
        ];
    }

    public function getLanguageSwitch(string $language, string $section, ?Document $rootDoc = null, bool $hpFallback = false): array
    {
        return Utils::getLanguageSwitch($language, $section, $rootDoc, $hpFallback);
    }
}
