<?php declare(strict_types=1);

namespace App\ValueCalculator;

use App\Service\LanguageService;
use Pimcore\Model\DataObject;
use Pimcore\Model\DataObject\ClassDefinition\CalculatorClassInterface;
use Pimcore\Model\DataObject\Data\CalculatedValue;

class UrlCalculator implements CalculatorClassInterface
{
    public function __construct(protected LanguageService $languageService)
    {
    }

    public function compute(DataObject\Concrete $object, CalculatedValue $context): string
    {
        return $this->getUrl($object, $context->getPosition());
    }

    public function getCalculatedValueForEditMode(DataObject\Concrete $object, CalculatedValue $context): string
    {
        return $this->compute($object, $context);
    }

    public function getUrl(DataObject\Concrete $object, string $language = null): string
    {
        if (!$language) {
            $language = $this->languageService->getDefaultLanguage();
        }

        $url = '';
        if (!($object instanceof DataObject\Concrete)) {
            return $url;
        }

        $linkGenerator = $object->getClass()->getLinkGenerator();
        if ($linkGenerator) {
            return $linkGenerator->generate($object, ['locale' => $language]);
        }

        return $url;
    }
}
