<?php

namespace AppBundle\Command;

use AppBundle\Service\Generator;
use Pimcore\Console\AbstractCommand;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;

class GeneratorClassDeleteCommand extends AbstractCommand
{
	protected function configure()
	{
		$this
			->setName('generator:class-delete')
			->setDescription('Delete a pimcore class definition')
			->addArgument(
				'name',
				InputArgument::REQUIRED,
				'Class name in CamelCase'
			);
	}

	protected function execute(InputInterface $input, OutputInterface $output)
	{
		$generator = new Generator();

		$name = $input->getArgument('name');
		if ($generator->deleteClassMapping($name)) {
			$output->writeln(sprintf('Classmapping for class [%s] deleted', $name));
		} else {
			$output->writeln(sprintf(
				'<error>Classmapping for class [%s] could not be deleted. See var/log/generator.log for details.</error>',
				$name
			));
		}

		if ($generator->deleteClassDefinition($name)) {
			$output->writeln(sprintf('Class [%s] deleted', $name));
		} else {
			$output->writeln(sprintf(
				'<error>Class [%s] could not be deleted. See var/log/generator.log for details.</error>',
				$name
			));
		}
	}
}
