<?php

namespace AppBundle\Controller;

use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Form\FormInterface;
use Zend\Paginator\Paginator;
use Pimcore\File;
use Pimcore\Logger;
use Pimcore\Model\DataObject;
use Pimcore\Model\DataObject\ContactForm;
use AppBundle\Form\ContactFormType;
use AppBundle\Model\News;
use AppBundle\Service\MailManager;

class CmsController extends BaseController
{
	/*						DOCUMENT ROUTED ACTIONS							*/

	/**
	 * @return Response
	 */
	public function templateSimpleAction()
	{
	}

	/**
	 * @return Response
	 */
	public function simpleMailAction()
	{
	}

	/**
	 * @return Response
	 */
	public function sitemapAction()
	{
	}

	/**
	 * @param Request     $request
	 * @param MailManager $mailManager
	 *
	 * @return Response
	 */
	public function contactUsAction(Request $request, MailManager $mailManager)
	{
		$form = $this->createForm(ContactFormType::class);
		$form->handleRequest($request);

		if ($form->isSubmitted()) {
			if ($this->handleContactForm($form, $mailManager)) {
				return $this->gotoUrl($this->docUrl('/kontakt'));
			}
		}

		$this->view->contactForm = $form->createView();
	}

	/**
	 * @param Request     $request
	 *
	 * @return Response
	 */
	public function newsAction(Request $request)
	{
		$page = $request->get('page', 1);

		$list = new News\Listing();
		$list->setOrder('desc');
		$list->setOrderKey('createdOn');
		$list->setCondition('createdOn < ?', [time()]);

		$paginator = new Paginator($list);
		$paginator->setCurrentPageNumber($page);
		$paginator->setItemCountPerPage(6);

		$paginationProperties = $paginator->getPages('Sliding');
		$paginationProperties->urlprefix = $this->document->getFullPath() . '?page=';

		$this->view->news = $paginator;
		$this->view->paginationProperties = $paginationProperties;
	}

	/* 						STATIC-ROUTE ROUTED ACTIONS						 */

	/**
	 * @param string $id
	 *
	 * @return Response
	 */
	public function newsDetailAction($id)
	{
		//output cached stuff
		if (!$this->isOutputCached($this->cacheKeySuffix)) {
			$news = News::getById($id);

			if (!$news) {
				return $this->createNotFoundException($this->translate('system_page_not_found'));
			}

			//get sibblings (next and previous news)
			$list = new News\Listing();
			$list->setOrder('desc');
			$list->setOrderKey('createdOn');
			$list->setCondition('createdOn < ?', [time()]);
			$list->load();
			list($this->view->previousNews, $this->view->nextNews) = $this->getSiblings($list, $news, 'createdOn');

			//extend breadcrumbs
			$this->addToBreadcrumbs[] = [
				'label' => $news->getName(),
				'url' => $news->getUrl(),
			];

			//explicit language switch
			$this->languageSwitch = $this->buildLanguageSwitchFromObject($news);

			//explicit seo stuff
			$this->headTitle->set($news->getName());
			if ($news->getSeoDescription()) {
				$this->headMeta->setName('description', $news->getSeoDescription());
			}

			$this->view->news = $news;
		}
	}

	/*				VIEW-LESS ACTIONS (ALWAYS REDIRECT)					*/

	/*							FORM HANDLERS								*/

	/**
	 * @param FormInterface $form
	 * @param MailManager   $mailManager
	 *
	 * @return bool
	 */
	private function handleContactForm(FormInterface $form, MailManager $mailManager)
	{
		if ($form->isValid()) {
			$data = $form->getData();
			$data['lang'] = $this->language;

			$contactForm = ContactForm::create($data);
			$contactForm->setCreationDate(time());
			$key = File::getValidFilename($data['fullName'].'_'.date('Y-m-d-H:i:s', time()));
			$contactForm->setKey($key);
			$contactForm->setParentId(DataObject\Folder::getByPath('/kontakt/kontaktni-formulare')->getId());
			$contactForm->setPublished(true);

			try {
				$contactForm->save();

				//send email to admin
				$mailManager->sendMail('/notifikace/pro-administratora-novy-kontaktni-formular', $this->language, null, null, [
					'deeplink' => $this->getRequest()->getSchemeAndHttpHost().'/admin/login/deeplink?object_'.$contactForm->getId().'_object',
					'form' => $contactForm,
				]);

				$this->addSuccessMsg($this->translate('msg_contact_form_success'));

				return true;
			} catch (\Exception $e) {
				Logger::error('CONTACT FORM - '.$e->getMessage()."\n".$e->getTraceAsString());
				$this->addErrorMsg($this->translate('msg_unknown_error'));
			}
		} else {
			$this->addErrorMsg($this->translate('msg_form_invalid'));
		}

		return false;
	}
}
