<?php

namespace AppBundle\Controller;

use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Form\FormInterface;
use AppBundle\Form\NewsletterFormType;
use AppBundle\Service\NewsletterManager;

class NewsletterController extends BaseController
{
	/*						DOCUMENT ROUTED ACTIONS							*/

	/*				VIEW-LESS ACTIONS (ALWAYS REDIRECT)					*/

	/**
	 * @param Request $request
	 * @param NewsletterManager $newsletterManager
	 *
	 * @return Response
	 */
	public function newsletterSubscribeAction(Request $request, NewsletterManager $newsletterManager)
	{
		$this->disableViewAutoRender();
		$this->newsletterForm->handleRequest($request);
		if ($this->newsletterForm->isSubmitted()) {
			if ($this->handleNewsletterForm($this->newsletterForm, $newsletterManager)) {
				$this->view->newsletterSent = true;
				$this->newsletterForm = $this->createForm(NewsletterFormType::class);
				$this->view->newsletterForm = $this->newsletterForm->createView();
				$this->ajaxResponseBuilder->addElement('#newsletter', 'Snippet/newsletter.html.php');
			}
		}
		return $this->ajaxResponseBuilder->addFlashMessages()->getResponse();
	}

	/**
	 * @param Request $request
	 * @param NewsletterManager $newsletterManager
	 *
	 * @return Response
	 */
	public function newsletterConfirmAction(NewsletterManager $newsletterManager, $code)
	{
		$this->disableViewAutoRender();
		if ($email = $newsletterManager->confirm($code)) {
			$this->addSuccessMsg(sprintf($this->translate('msg_newsletter_subscribed'), $email));
		} elseif (false === $email) {
			$this->addInfoMsg($this->translate('msg_newsletter_code_invalid'));
		} else {
			$this->addErrorMsg($this->translate('msg_unknown_error'));
		}
		return $this->gotoUrl($this->getPreviousUrl());
	}

	/**
	 * @param NewsletterManager $newsletterManager
	 * @param string $code
	 *
	 * @return Response
	 */
	public function newsletterUnsubscribeAction(NewsletterManager $newsletterManager, $code)
	{
		$this->disableViewAutoRender();
		if ($email  = $newsletterManager->unsubscribe($code)) {
			$this->addSuccessMsg(sprintf($this->translate('msg_newsletter_unsubscribed'), $email));
		} elseif (false === $email) {
			$this->addInfoMsg($this->translate('msg_newsletter_code_invalid'));
		} else {
			$this->addErrorMsg($this->translate('msg_unknown_error'));
		}
		return $this->gotoUrl($this->getPreviousUrl());
	}

	/*							FORM HANDLERS								*/

	/**
	 * @param FormInterface $form
	 * @param NewsletterManager $newsletterManager
	 *
	 * @return bool
	 */
	protected function handleNewsletterForm(FormInterface $form, NewsletterManager $newsletterManager)
	{
		if (!$form->isValid()) {
			$this->addErrorMsg($this->translate('msg_form_invalid'));
			return false;
		}
		$data = $form->getData();
		// antispam hidden field, should be empty
		if (!empty($data['fullName'])) {
			$this->addErrorMsg($this->translate('msg_unknown_error'));
			return false;
		}
		$data['lang'] = $this->language;
		if ($result = $newsletterManager->subscribe($data)) {
			$this->addSuccessMsg(sprintf($this->translate('msg_newsletter_registered'), $data['email']));
		} else {
			$this->addErrorMsg($this->translate('msg_unknown_error'));
		}
		return $result;
	}
}
