<?php

namespace AppBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\EmailType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Validator\Constraints\NotBlank;
use Symfony\Component\Validator\Constraints\Email;
use Symfony\Component\Validator\Constraints\Regex;

class ContactFormType extends AbstractType
{
	/**
	 * {@inheritdoc}
	 */
	public function buildForm(FormBuilderInterface $builder, array $options)
	{
		$builder
			->add('fullName', TextType::class, [
				'label' => 'label_full_name',
				'required' => true,
				'constraints' => [
					new NotBlank(['message' => 'msg_empty_field']),
				],
			])
			->add('email', EmailType::class, [
				'label' => 'label_email',
				'required' => true,
				'constraints' => [
					new NotBlank(['message' => 'msg_empty_field']),
					new Email(['message' => 'msg_invalid_email']),
				],
			])
			->add('phone', TextType::class, [
				'label' => 'label_phone',
				'required' => true,
				'constraints' => [
					new NotBlank(['message' => 'msg_empty_field']),
					new Regex([
						'pattern' => '/^(\+420|\+421|00420|00421)?[ ]*[0-9]{3}[ ]*[0-9]{3}[ ]*[0-9]{3}$/',
						'message' => 'msg_bad_format_phone',
					]),
				],
			])
			->add('message', TextareaType::class, [
				'label' => 'label_message_text',
				'required' => true,
				'constraints' => [
					new NotBlank(['message' => 'msg_empty_field']),
				],
			])
			->add('submit', SubmitType::class, [
				'label' => 'label_submit_question',
			]);
	}
}
