<?php

namespace localMigration;

use Pimcore\Bundle\EcommerceFrameworkBundle\PimcoreEcommerceFrameworkBundle;
use Pimcore\Db;
use Pimcore\Migrations\InstallVersion;
use Pimcore\Model\Redirect;
use Symfony\Component\Filesystem\Filesystem;
use Symfony\Component\Yaml\Yaml;

include_once __DIR__.'/../../../../pimcore/config/startup_cli.php';
\Pimcore\Cache::clearAll();

$db = \Pimcore\Db::get();
$incompatible = false;

$largePrefix = $db->fetchRow("SHOW GLOBAL VARIABLES LIKE 'innodb\_large\_prefix';");
if ($largePrefix && $largePrefix['Value'] != 'ON') {
    $incompatible = true;
}
$fileFormat = $db->fetchRow("SHOW GLOBAL VARIABLES LIKE 'innodb\_file\_format';");
if ($fileFormat && $fileFormat['Value'] != 'Barracuda') {
    $incompatible = true;
}
$fileFilePerTable = $db->fetchRow("SHOW GLOBAL VARIABLES LIKE 'innodb\_file\_per\_table';");
if ($fileFilePerTable && $fileFilePerTable['Value'] != 'ON') {
    $incompatible = true;
}

if ($incompatible) {
    echo "Your MySQL/MariaDB Server is incompatible!\n\n";
    echo "Please ensure the following MySQL/MariaDB system variables are set accordingly:\n";
    echo "innodb_file_format = Barracuda\ninnodb_large_prefix = 1\ninnodb_file_per_table = 1\n\n";
    exit;
}


if (version_compare(PHP_VERSION, '7.1', '<')) {
    echo "Pimcore requires PHP >= 7.1, your current version is: " . PHP_VERSION . "\n\n";
    exit;
}

$offset = 0;
if(isset($_SERVER['argv'][1])) {
    $offset = $_SERVER['argv'][1];
    if(!is_numeric($offset)) {
        echo "Build offset must be a numeric value\n"; exit;
    }
    $offset = intval($offset);
}


fwrite(STDOUT, "202\n");
// mark ecommerce install migration as migrated if framework is currently installed
if (PimcoreEcommerceFrameworkBundle::isInstalled()) {

	// create migration table if not exists
	$factory = \Pimcore::getContainer()->get('Pimcore\Migrations\Configuration\ConfigurationFactory');
	$bundle = \Pimcore::getKernel()->getBundle('PimcoreEcommerceFrameworkBundle');
	$config = $factory->getForBundle($bundle, $db);
	$config->createMigrationTable();

	$sql = <<<'SQL'
		INSERT IGNORE INTO
			pimcore_migrations (migration_set, version, migrated_at)
		VALUES
			(:migration_set, :version, NOW())
SQL;

	$db->executeQuery($sql, [
		'migration_set' => 'PimcoreEcommerceFrameworkBundle',
		'version'       => InstallVersion::INSTALL_VERSION,
	]);
}

$db->insert('users_permission_definitions', ['key' => 'admin_translations']);


fwrite(STDOUT, "219\n");
$db->query("ALTER TABLE `objects` ADD `o_childrenSortBy` ENUM('key','index') NULL DEFAULT NULL AFTER `o_className`;");
$db->query('ALTER TABLE `objects` ADD INDEX `index` (`o_index`);');


fwrite(STDOUT, "225\n");
$db->query('ALTER TABLE `documents_page` CHANGE COLUMN `description` `description` VARCHAR(383) NULL DEFAULT NULL;');
$db->query('ALTER table users ADD COLUMN `lastLogin` int(11) unsigned NULL;');
$db->query('ALTER table email_log ADD FULLTEXT INDEX `fulltext` (`from`, `to`, `cc`, `bcc`, `subject`, `params`);');


fwrite(STDOUT, "227\n");
$classList = new \Pimcore\Model\DataObject\ClassDefinition\Listing();
$classes = $classList->load();
foreach ($classes as $class) {
	$class->save();
}


$brickList = new \Pimcore\Model\DataObject\Objectbrick\Definition\Listing();
$brickList = $brickList->load();
foreach ($brickList as $brickDef) {
	$brickDef->save();
}


fwrite(STDOUT, "235\n");
$db->query("REPLACE INTO `users_permission_definitions` (`key`) VALUES ('clear_fullpage_cache');");


fwrite(STDOUT, "253\n");
$db->query('ALTER TABLE `users`
	ADD COLUMN `keyBindings` TEXT NULL AFTER `lastLogin`;
');


fwrite(STDOUT, "256\n");
$db->query('ALTER TABLE `users` ADD COLUMN `twoFactorAuthentication` VARCHAR(255) AFTER `apiKey`');


fwrite(STDOUT, "270\n");
$db->query('ALTER TABLE `classes`
	ALTER `id` DROP DEFAULT;
');

$db->query('ALTER TABLE `classes`
	CHANGE COLUMN `id` `id` VARCHAR(50) NOT NULL FIRST;');

$db->query('ALTER TABLE `objects`
	CHANGE COLUMN `o_classId` `o_classId` VARCHAR(50) NULL DEFAULT NULL AFTER `o_userModification`;');

$db->query('ALTER TABLE `gridconfigs`
	CHANGE COLUMN `classId` `classId` VARCHAR(50) NULL DEFAULT NULL AFTER `ownerId`;
');

$db->query('ALTER TABLE `gridconfig_favourites`
	ALTER `classId` DROP DEFAULT;');

$db->query('ALTER TABLE `gridconfig_favourites`
	CHANGE COLUMN `classId` `classId` VARCHAR(50) NOT NULL AFTER `ownerId`;');

$db->query('ALTER TABLE `importconfigs`
	CHANGE COLUMN `classId` `classId` VARCHAR(50) NULL DEFAULT NULL AFTER `ownerId`;
');

$db->query('ALTER TABLE `custom_layouts`
	ALTER `classId` DROP DEFAULT;
');

$db->query('ALTER TABLE `custom_layouts`
	CHANGE COLUMN `classId` `classId` VARCHAR(50) NOT NULL AFTER `id`;');


fwrite(STDOUT, "277\n");
$classList = new \Pimcore\Model\DataObject\ClassDefinition\Listing();
$classes = $classList->load();
foreach ($classes as $ckey => $class) {
	foreach ($class->getFieldDefinitions() as $fkey => $field) {
		if ($field->getUnique()) {
			$class->save(); //save class to remove unique constraint form query table
			break;
		}
	}
}


fwrite(STDOUT, "280\n");
//setting replyTo = null if default empty value exists
$emailLogs = new \Pimcore\Model\Tool\Email\Log\Listing();
$emailLogs->setCondition("replyTo = ''");
foreach ($emailLogs->load() as $ekey => $emailLog) {
	$emailLog->setReplyTo(null);
	$emailLog->save();
}


fwrite(STDOUT, "283\n");
$classList = new \Pimcore\Model\DataObject\ClassDefinition\Listing();
$classes = $classList->load();
foreach ($classes as $ckey => $class) {
	$found = false;
	foreach ($class->getFieldDefinitions() as $fkey => $field) {
		if ($field instanceof \Pimcore\Model\DataObject\ClassDefinition\Data\ObjectsMetadata) {
			$allowedClassId = $field->getAllowedClassId();
			if (is_numeric($allowedClassId)) {
				$class = \Pimcore\Model\DataObject\ClassDefinition::getById($allowedClassId);
				$allowedClassId  = $class ? $class->getName() : null;
			}

	if($allowedClassId){
		$field->setAllowedClassId($allowedClassId);
		$found = true;
	}

		}
	}
	if ($found) {
		try {
			$class->save();
		} catch (\Exception $e) {
			echo "Error: " . $e->getMessage() . "\n";
		}
	}
}

$brickList = new \Pimcore\Model\DataObject\Objectbrick\Definition\Listing();
$brickList = $brickList->load();
foreach ($brickList as $brickDef) {
	$found = false;
	foreach ($brickDef->getFieldDefinitions() as $fkey => $field) {
		if ($field instanceof \Pimcore\Model\DataObject\ClassDefinition\Data\ObjectsMetadata) {
			$allowedClassId = $field->getAllowedClassId();
			if (is_numeric($allowedClassId)) {
				$class = \Pimcore\Model\DataObject\ClassDefinition::getById($allowedClassId);
				$allowedClassId  = $class ? $class->getName() : null;
			}

	if($allowedClassId){
		$field->setAllowedClassId($allowedClassId);
		$found = true;
	}

		}
	}
	if ($found) {
		try {
			$brickDef->save();
		} catch (\Exception $e) {
			echo "Error: " . $e->getMessage() . "\n";
		}
	}
}

$fcList = new \Pimcore\Model\DataObject\Fieldcollection\Definition\Listing();
$fcList = $fcList->load();
foreach ($fcList as $collectionDef) {
	$found = false;
	foreach ($collectionDef->getFieldDefinitions() as $fkey => $field) {
		if ($field instanceof \Pimcore\Model\DataObject\ClassDefinition\Data\ObjectsMetadata) {
			$allowedClassId = $field->getAllowedClassId();
			if (is_numeric($allowedClassId)) {
				$class = \Pimcore\Model\DataObject\ClassDefinition::getById($allowedClassId);
				$allowedClassId  = $class ? $class->getName() : null;
			}

	if($allowedClassId){
		$field->setAllowedClassId($allowedClassId);
		$found = true;
	}

		}
	}
	if ($found) {
		try {
			$collectionDef->save();
		} catch (\Exception $e) {
			echo "Error: " . $e->getMessage() . "\n";
		}
	}
}


\Pimcore\Cache::clearAll();
fwrite(STDOUT, "done\n");
