<?php

namespace AppBundle\Twig\Extension;

use Twig\Extension\AbstractExtension;
use Twig\TwigFunction;

class NavigationExtension extends AbstractExtension
{
	/**
	 * @return array|TwigFunction[]
	 */
	public function getFunctions()
	{
		return [
			new TwigFunction('extend_breadcrumbs', [$this, 'extendBreadcrumbs']),
		];
	}

	/**
	 * Extends $navigation breadcrumbs with $addToBreadcrumbs.
	 *
	 * @param mixed $navigation
	 * @param mixed $addToBreadcrumbs
	 * @return \Pimcore\Navigation\Container
	 */
	public function extendBreadcrumbs($navigation, $addToBreadcrumbs)
	{
		if (!$navigation instanceof \Pimcore\Navigation\Container || empty($addToBreadcrumbs->pages)) {
			return $navigation;
		}
		$activePages = $navigation->findAllBy('active', true);
		end($activePages);
		$deepestActive = current($activePages);
		foreach ($addToBreadcrumbs->pages as $key => $page) {
			${'page_' . $key} = \Pimcore\Navigation\Page\Document::factory([
				'label' => $page['label'],
				'title' => $page['label'],
				'uri' => $page['url'],
				'active' => true,
			]);
			$deepestActive->addPage(${'page_' . $key});
			$deepestActive = ${'page_' . $key};
		}
		return $navigation;
	}
}
