<?php

namespace AppBundle\View\Helper;

use Pimcore\Templating\Helper\TemplatingEngineAwareHelperInterface;
use Symfony\Component\Templating\Helper\Helper;

class Enc extends Helper implements TemplatingEngineAwareHelperInterface
{
	use \Pimcore\Templating\Helper\Traits\TemplatingEngineAwareHelperTrait;

	/**
	 * {@inheritdoc}
	 */
	public function getName()
	{
		return 'enc';
	}

	/**
	 * @param string $string string to encode
	 * @param bool   $inJs   output is in javascipt code
	 * @param  $jsInHtmlAttrib output is in JS in HTML attribute
	 *
	 * @return string safely HTML encoded string
	 */
	public function __invoke($string, $inJs = false, $jsInHtmlAttrib = false)
	{
		if ($inJs) {
			if ($jsInHtmlAttrib) {
				return htmlspecialchars(json_encode($string), ENT_QUOTES);
			} else {
				return json_encode($string);
			}
		} else {
			return htmlspecialchars($string, ENT_QUOTES);
		}
	}
}
