<?
/**
 * @var \Pimcore\Templating\PhpEngine $this
 * @var \Pimcore\Templating\PhpEngine $view
 * @var \Pimcore\Templating\GlobalVariables $app
 */

$this->extend('layout.html.php');
?>

<div class="col-md-12">
	<div class="page-header">
		<h1>Archiv novinek</h1>
	</div>

	<div class="row">
		<?foreach($this->news as $news):?>
			<div class="col-xs-6">
				<a href="<?=$news->getUrl($this->language);?>">
					<?=\AppBundle\Tool\Utils::image(
						$news->getPreviewImage(),
						'NewsPreviewImage',
						null,
						['class' => 'img-polaroid']
					);?>
				</a>
				<div class="caption">
					<h3><a href="<?=$news->getUrl($this->language);?>"><?=$news->getName();?></a></h3>
					<p><?=\AppBundle\Tool\Utils::cutStringRespectingWhitespace($news->getPerex(), 300);?></p>
				</div>
			</div>
		<?endforeach;?>
	</div>

	<?
		$paginationProperties = $this->news->getPages("Sliding");
		$paginationProperties->urlprefix = $this->docUrl('/aktuality'). '?page=';
		echo $this->render("Snippet/pagination.html.php", ['pagination' => $paginationProperties]);
	?>
</div>
