
SET NAMES utf8mb4;



DROP TABLE IF EXISTS `eshop_old_paths`;
CREATE TABLE `eshop_old_paths` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `o_id` int(11) NOT NULL,
  `class` int(3) NOT NULL,
  `translatedPath` varchar(255) DEFAULT NULL,
  `language` varchar(8) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `key_o_id` (`o_id`),
  KEY `key_class` (`class`),
  KEY `key_translatedPath` (`translatedPath`(191)),
  KEY `key_language` (`language`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;



DROP TABLE IF EXISTS `keyvalue_groups`;
CREATE TABLE `keyvalue_groups` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `description` varchar(255) DEFAULT NULL,
  `creationDate` bigint(20) unsigned DEFAULT '0',
  `modificationDate` bigint(20) unsigned DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;



DROP TABLE IF EXISTS `keyvalue_keys`;
CREATE TABLE `keyvalue_keys` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `description` text,
  `type` enum('bool','number','select','text','translated','translatedSelect','range') DEFAULT NULL,
  `unit` varchar(255) DEFAULT NULL,
  `possiblevalues` text,
  `group` int(11) DEFAULT NULL,
  `creationDate` bigint(20) unsigned DEFAULT '0',
  `modificationDate` bigint(20) unsigned DEFAULT '0',
  `translator` int(11) DEFAULT NULL,
  `mandatory` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `group` (`group`),
  CONSTRAINT `keyvalue_keys_ibfk_1` FOREIGN KEY (`group`) REFERENCES `keyvalue_groups` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;



DROP TABLE IF EXISTS `keyvalue_translator_configuration`;
CREATE TABLE `keyvalue_translator_configuration` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(200) DEFAULT NULL,
  `translator` varchar(200) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;



DROP TABLE IF EXISTS `object_localized_data_4`;
CREATE TABLE `object_localized_data_4` (
  `ooo_id` int(11) NOT NULL DEFAULT '0',
  `language` varchar(10) NOT NULL DEFAULT '',
  `name` varchar(255) DEFAULT NULL,
  `seoDescription` longtext,
  `perex` longtext,
  `content` longtext,
  PRIMARY KEY (`ooo_id`,`language`),
  KEY `ooo_id` (`ooo_id`),
  KEY `language` (`language`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;



DROP TABLE IF EXISTS `object_localized_query_4_cs`;
CREATE TABLE `object_localized_query_4_cs` (
  `ooo_id` int(11) NOT NULL DEFAULT '0',
  `language` varchar(10) NOT NULL DEFAULT '',
  `name` varchar(255) DEFAULT NULL,
  `seoDescription` longtext,
  `perex` longtext,
  `content` longtext,
  `url` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`ooo_id`,`language`),
  KEY `ooo_id` (`ooo_id`),
  KEY `language` (`language`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;



DROP TABLE IF EXISTS `object_query_10`;
CREATE TABLE `object_query_10` (
  `oo_id` int(11) NOT NULL DEFAULT '0',
  `oo_classId` int(11) DEFAULT '10',
  `oo_className` varchar(255) DEFAULT 'User',
  `email` varchar(255) DEFAULT NULL,
  `password` varchar(190) DEFAULT NULL,
  `activationCode` varchar(255) DEFAULT NULL,
  `lang` varchar(190) DEFAULT NULL,
  `firstName` varchar(255) DEFAULT NULL,
  `lastName` varchar(255) DEFAULT NULL,
  `phone` varchar(255) DEFAULT NULL,
  `street` varchar(255) DEFAULT NULL,
  `city` varchar(255) DEFAULT NULL,
  `zipCode` varchar(255) DEFAULT NULL,
  `company` varchar(255) DEFAULT NULL,
  `dic` varchar(255) DEFAULT NULL,
  `passwordResetToken` varchar(255) DEFAULT NULL,
  `ic` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`oo_id`),
  KEY `p_index_email` (`email`(191)),
  KEY `p_index_activationCode` (`activationCode`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;



DROP TABLE IF EXISTS `object_query_4`;
CREATE TABLE `object_query_4` (
  `oo_id` int(11) NOT NULL DEFAULT '0',
  `oo_classId` int(11) DEFAULT '4',
  `oo_className` varchar(255) DEFAULT 'News',
  `createdOn` bigint(20) DEFAULT NULL,
  `previewImage__image` int(11) DEFAULT NULL,
  `previewImage__hotspots` text,
  PRIMARY KEY (`oo_id`),
  KEY `p_index_createdOn` (`createdOn`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;



DROP TABLE IF EXISTS `object_query_5`;
CREATE TABLE `object_query_5` (
  `oo_id` int(11) NOT NULL DEFAULT '0',
  `oo_classId` int(11) DEFAULT '5',
  `oo_className` varchar(255) DEFAULT 'ContactForm',
  `fullName` varchar(255) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `phone` varchar(255) DEFAULT NULL,
  `message` longtext,
  `lang` varchar(190) DEFAULT NULL,
  PRIMARY KEY (`oo_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;



DROP TABLE IF EXISTS `object_query_6`;
CREATE TABLE `object_query_6` (
  `oo_id` int(11) NOT NULL DEFAULT '0',
  `oo_classId` int(11) DEFAULT '6',
  `oo_className` varchar(255) DEFAULT 'NewsletterForm',
  `email` varchar(255) DEFAULT NULL,
  `lang` varchar(190) DEFAULT NULL,
  `unsubscribeCode` varchar(255) DEFAULT NULL,
  `firstname` varchar(255) DEFAULT NULL,
  `lastname` varchar(255) DEFAULT NULL,
  `gender` varchar(190) DEFAULT NULL,
  `newsletterActive` tinyint(1) DEFAULT NULL,
  `newsletterConfirmed` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`oo_id`),
  KEY `p_index_unsubscribeCode` (`unsubscribeCode`(191)),
  KEY `p_index_email` (`email`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;



DROP TABLE IF EXISTS `object_relations_10`;
CREATE TABLE `object_relations_10` (
  `src_id` int(11) NOT NULL DEFAULT '0',
  `dest_id` int(11) NOT NULL DEFAULT '0',
  `type` varchar(50) NOT NULL DEFAULT '',
  `fieldname` varchar(70) NOT NULL DEFAULT '0',
  `index` int(11) unsigned NOT NULL DEFAULT '0',
  `ownertype` enum('object','fieldcollection','localizedfield','objectbrick') NOT NULL DEFAULT 'object',
  `ownername` varchar(70) NOT NULL DEFAULT '',
  `position` varchar(70) NOT NULL DEFAULT '0',
  PRIMARY KEY (`src_id`,`dest_id`,`ownertype`,`ownername`,`fieldname`,`type`,`position`),
  KEY `index` (`index`),
  KEY `src_id` (`src_id`),
  KEY `dest_id` (`dest_id`),
  KEY `fieldname` (`fieldname`),
  KEY `position` (`position`),
  KEY `ownertype` (`ownertype`),
  KEY `type` (`type`),
  KEY `ownername` (`ownername`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;



DROP TABLE IF EXISTS `object_relations_4`;
CREATE TABLE `object_relations_4` (
  `src_id` int(11) NOT NULL DEFAULT '0',
  `dest_id` int(11) NOT NULL DEFAULT '0',
  `type` varchar(50) NOT NULL DEFAULT '',
  `fieldname` varchar(70) NOT NULL DEFAULT '0',
  `index` int(11) unsigned NOT NULL DEFAULT '0',
  `ownertype` enum('object','fieldcollection','localizedfield','objectbrick') NOT NULL DEFAULT 'object',
  `ownername` varchar(70) NOT NULL DEFAULT '',
  `position` varchar(70) NOT NULL DEFAULT '0',
  PRIMARY KEY (`src_id`,`dest_id`,`ownertype`,`ownername`,`fieldname`,`type`,`position`),
  KEY `index` (`index`),
  KEY `src_id` (`src_id`),
  KEY `dest_id` (`dest_id`),
  KEY `fieldname` (`fieldname`),
  KEY `position` (`position`),
  KEY `ownertype` (`ownertype`),
  KEY `type` (`type`),
  KEY `ownername` (`ownername`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;



DROP TABLE IF EXISTS `object_relations_5`;
CREATE TABLE `object_relations_5` (
  `src_id` int(11) NOT NULL DEFAULT '0',
  `dest_id` int(11) NOT NULL DEFAULT '0',
  `type` varchar(50) NOT NULL DEFAULT '',
  `fieldname` varchar(70) NOT NULL DEFAULT '0',
  `index` int(11) unsigned NOT NULL DEFAULT '0',
  `ownertype` enum('object','fieldcollection','localizedfield','objectbrick') NOT NULL DEFAULT 'object',
  `ownername` varchar(70) NOT NULL DEFAULT '',
  `position` varchar(70) NOT NULL DEFAULT '0',
  PRIMARY KEY (`src_id`,`dest_id`,`ownertype`,`ownername`,`fieldname`,`type`,`position`),
  KEY `index` (`index`),
  KEY `src_id` (`src_id`),
  KEY `dest_id` (`dest_id`),
  KEY `fieldname` (`fieldname`),
  KEY `position` (`position`),
  KEY `ownertype` (`ownertype`),
  KEY `type` (`type`),
  KEY `ownername` (`ownername`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;



DROP TABLE IF EXISTS `object_relations_6`;
CREATE TABLE `object_relations_6` (
  `src_id` int(11) NOT NULL DEFAULT '0',
  `dest_id` int(11) NOT NULL DEFAULT '0',
  `type` varchar(50) NOT NULL DEFAULT '',
  `fieldname` varchar(70) NOT NULL DEFAULT '0',
  `index` int(11) unsigned NOT NULL DEFAULT '0',
  `ownertype` enum('object','fieldcollection','localizedfield','objectbrick') NOT NULL DEFAULT 'object',
  `ownername` varchar(70) NOT NULL DEFAULT '',
  `position` varchar(70) NOT NULL DEFAULT '0',
  PRIMARY KEY (`src_id`,`dest_id`,`ownertype`,`ownername`,`fieldname`,`type`,`position`),
  KEY `index` (`index`),
  KEY `src_id` (`src_id`),
  KEY `dest_id` (`dest_id`),
  KEY `fieldname` (`fieldname`),
  KEY `position` (`position`),
  KEY `ownertype` (`ownertype`),
  KEY `type` (`type`),
  KEY `ownername` (`ownername`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;



DROP TABLE IF EXISTS `object_store_10`;
CREATE TABLE `object_store_10` (
  `oo_id` int(11) NOT NULL DEFAULT '0',
  `email` varchar(255) DEFAULT NULL,
  `password` varchar(190) DEFAULT NULL,
  `activationCode` varchar(255) DEFAULT NULL,
  `lang` varchar(190) DEFAULT NULL,
  `firstName` varchar(255) DEFAULT NULL,
  `lastName` varchar(255) DEFAULT NULL,
  `phone` varchar(255) DEFAULT NULL,
  `street` varchar(255) DEFAULT NULL,
  `city` varchar(255) DEFAULT NULL,
  `zipCode` varchar(255) DEFAULT NULL,
  `company` varchar(255) DEFAULT NULL,
  `dic` varchar(255) DEFAULT NULL,
  `passwordResetToken` varchar(255) DEFAULT NULL,
  `ic` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`oo_id`),
  KEY `p_index_email` (`email`(191)),
  KEY `p_index_activationCode` (`activationCode`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;



DROP TABLE IF EXISTS `object_store_4`;
CREATE TABLE `object_store_4` (
  `oo_id` int(11) NOT NULL DEFAULT '0',
  `createdOn` bigint(20) DEFAULT NULL,
  `previewImage__image` int(11) DEFAULT NULL,
  `previewImage__hotspots` text,
  PRIMARY KEY (`oo_id`),
  KEY `p_index_createdOn` (`createdOn`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;



DROP TABLE IF EXISTS `object_store_5`;
CREATE TABLE `object_store_5` (
  `oo_id` int(11) NOT NULL DEFAULT '0',
  `fullName` varchar(255) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `phone` varchar(255) DEFAULT NULL,
  `message` longtext,
  `lang` varchar(190) DEFAULT NULL,
  PRIMARY KEY (`oo_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;



DROP TABLE IF EXISTS `object_store_6`;
CREATE TABLE `object_store_6` (
  `oo_id` int(11) NOT NULL DEFAULT '0',
  `email` varchar(255) DEFAULT NULL,
  `lang` varchar(190) DEFAULT NULL,
  `unsubscribeCode` varchar(255) DEFAULT NULL,
  `firstname` varchar(255) DEFAULT NULL,
  `lastname` varchar(255) DEFAULT NULL,
  `gender` varchar(190) DEFAULT NULL,
  `newsletterActive` tinyint(1) DEFAULT NULL,
  `newsletterConfirmed` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`oo_id`),
  KEY `p_index_unsubscribeCode` (`unsubscribeCode`(191)),
  KEY `p_index_email` (`email`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;



INSERT INTO `assets` VALUES ('1','0','folder','','/',NULL,'1508244399','1508244399','1','1',NULL,'0');
INSERT INTO `assets` VALUES ('4','1','folder','novinky','/',NULL,'1508244399','1508244399','2','2',NULL,'0');
INSERT INTO `assets` VALUES ('5','4','folder','galerie','/novinky/',NULL,'1508244399','1508244399','2','2',NULL,'0');
INSERT INTO `assets` VALUES ('6','1','folder','dokumenty','/',NULL,'1508244399','1508244399','2','2',NULL,'0');
INSERT INTO `classes` VALUES ('5','ContactForm');
INSERT INTO `classes` VALUES ('4','News');
INSERT INTO `classes` VALUES ('6','NewsletterForm');
INSERT INTO `classes` VALUES ('10','User');
INSERT INTO `dependencies` VALUES ('document','7','document','1');
INSERT INTO `documents` VALUES ('1','0','page','','/','999999','1','1508244399','1508244399','1','1');
INSERT INTO `documents` VALUES ('3','1','folder','system','/','8','1','1508244399','1508244399','2','2');
INSERT INTO `documents` VALUES ('5','1','folder','notifikace','/','7','1','1508244399','1508244399','2','2');
INSERT INTO `documents` VALUES ('6','5','email','newsletter','/notifikace/','2','1','1508244399','1516485543','2','2');
INSERT INTO `documents` VALUES ('7','3','page','chybova-stranka','/system/','0','1','1508244399','1516541784','2','2');
INSERT INTO `documents` VALUES ('8','1','page','o-nas','/','0','1','1508244399','1516565769','2','2');
INSERT INTO `documents` VALUES ('9','1','page','kontakt','/','2','1','1508244399','1508244399','2','2');
INSERT INTO `documents` VALUES ('12','1','page','ucet','/','4','1','1508244399','1508244399','2','2');
INSERT INTO `documents` VALUES ('14','5','email','registrace','/notifikace/','0','1','1508244399','1516485460','2','2');
INSERT INTO `documents` VALUES ('16','5','email','reset-hesla','/notifikace/','1','1','1508244399','1516485532','2','2');
INSERT INTO `documents` VALUES ('21','1','page','mapa-stranek','/','6','1','1508244399','1508244399','2','2');
INSERT INTO `documents` VALUES ('22','1','page','aktuality','/','1','1','1508244399','1508244399','2','2');
INSERT INTO `documents` VALUES ('24','5','email','pro-administratora-novy-kontaktni-formular','/notifikace/','3','1','1508244399','1516485475','2','2');
INSERT INTO `documents` VALUES ('26','1','page','prihlaseni','/','3','1','1508244399','1508244399','2','2');
INSERT INTO `documents` VALUES ('27','12','page','zmena-hesla','/ucet/','0','1','1508244399','1508244399','2','2');
INSERT INTO `documents` VALUES ('28','12','page','profil','/ucet/','1','1','1508244399','1516528643','2','2');
INSERT INTO `documents_elements` VALUES ('6','email_body','wysiwyg','<p>Dobrý den,</p>\n\n<p>Děkujeme, že jste se přihlásili k odběru našeho newletteru.</p>\n\n<p>Jestliže jste se do newsletteru nepřihlásili dobrovolně nebo se v budoucnu budete chtít odhlásit, můžete použít nasledující odkaz k odhlášení:</p>\n\n<p><a href=\"%Text(unsubscribeUrl);\" target=\"_blank\">%Text(unsubscribeUrl);</a></p>\n\n<p>Pimweb</p>\n');
INSERT INTO `documents_elements` VALUES ('7','content','areablock','a:1:{i:0;a:2:{s:3:\"key\";s:1:\"1\";s:4:\"type\";s:9:\"textblock\";}}');
INSERT INTO `documents_elements` VALUES ('7','content:1.text','wysiwyg','<h1 style=\"text-align: center;\">Ups!</h1>\n\n<p>Zdá se, že tato stránka není dostupná. Zkontrolujte URL adresu nebo pokračujte na <a href=\"/\" pimcore_id=\"1\" pimcore_type=\"document\">hlavní stránku</a>.</p>\n');
INSERT INTO `documents_elements` VALUES ('8','content','areablock','a:2:{i:0;a:2:{s:3:\"key\";s:1:\"1\";s:4:\"type\";s:9:\"textblock\";}i:1;a:2:{s:3:\"key\";s:1:\"2\";s:4:\"type\";s:7:\"gallery\";}}');
INSERT INTO `documents_elements` VALUES ('8','content:1.text','wysiwyg','<p>dffdf</p>\n');
INSERT INTO `documents_elements` VALUES ('8','content:2.gallery_images','multihref','a:1:{i:0;a:5:{s:2:\"id\";i:7;s:4:\"path\";s:48:\"/dokumenty/Screenshot at 2017-09-28 10-54-25.png\";s:4:\"type\";s:5:\"asset\";s:7:\"subtype\";s:5:\"image\";s:5:\"rowId\";s:25:\"DocumentsMultihrefEntry-1\";}}');
INSERT INTO `documents_elements` VALUES ('14','email_body','wysiwyg','<p>Dobrý den,</p>\n\n<p>Děkujeme za registraci na našich stránkách <a href=\"%Text(siteUrl);\" target=\"_blank\">%Text(siteUrl);</a>. Pro dokončení registrace použijte následující odkaz:</p>\n\n<p><a href=\"%Text(activationUrl);\" target=\"_blank\">%Text(activationUrl);</a></p>\n\n<p>Pimweb</p>\n');
INSERT INTO `documents_elements` VALUES ('16','email_body','wysiwyg','<p>Dobrý den,</p>\n\n<p>Na Vašem účtu bylo požádáno o resetování hesla. Heslo si můžete změnit přes nasledujúcí odkaz:</p>\n\n<p><strong><a href=\"%Text(link);\" target=\"_blank\">%Text(link);</a></strong></p>\n\n<p>Pimweb</p>\n');
INSERT INTO `documents_elements` VALUES ('24','email_body','wysiwyg','<p>Dobrý den,</p>\n\n<p>v systému byl založen nový kontaktní formulář s klíčem <strong><a href=\"%Text(deeplink);\" target=\"_blank\">%DataObject(form, {\"method\":\"getKey\"});</a></strong>. Obsah:</p>\n\n<p>Jméno: %DataObject(form, {\"method\":\"getFullName\"});</p>\n\n<p>E-mail: %DataObject(form, {\"method\":\"getEmail\"});</p>\n\n<p>Telefon: %DataObject(form, {\"method\":\"getPhone\"});</p>\n\n<p>Zpráva: %DataObject(form, {\"method\":\"getMessage\"});</p>\n\n<p>Pimweb</p>\n');
INSERT INTO `documents_email` VALUES ('6',NULL,'cms','simple-mail',NULL,'','noreply@vm3.portadesign.cz','','','Pimweb - přihlášení k odběru newsletteru','0');
INSERT INTO `documents_email` VALUES ('14',NULL,'cms','simple-mail',NULL,'','noreply@vm3.portadesign.cz','','','Pimweb - dokončení registrace','0');
INSERT INTO `documents_email` VALUES ('16',NULL,'cms','simple-mail',NULL,'','noreply@vm3.portadesign.cz','','','Pimweb - reset hesla','0');
INSERT INTO `documents_email` VALUES ('24',NULL,'cms','simple-mail',NULL,'noreply@vm3.portadesign.cz','noreply@vm3.portadesign.cz','','','Pimweb - notifikace: nový kontaktní formulář','0');
INSERT INTO `documents_page` VALUES ('1',NULL,'default','index',NULL,'Úvod','Úvod',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `documents_page` VALUES ('7',NULL,'cms','template-simple',NULL,'Chybová stránka','Chybová stránka','a:0:{}',NULL,NULL,'','0');
INSERT INTO `documents_page` VALUES ('8',NULL,'cms','template-simple',NULL,'O nás','O nás','a:0:{}',NULL,NULL,'','0');
INSERT INTO `documents_page` VALUES ('9',NULL,'cms','contact-us',NULL,'Kontakt','Kontakt',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `documents_page` VALUES ('12',NULL,'user','account',NULL,'Účet','Účet',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `documents_page` VALUES ('21',NULL,'cms','sitemap',NULL,'Mapa stránek','Mapa stránek',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `documents_page` VALUES ('22',NULL,'cms','news',NULL,'Aktuality','Aktuality',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `documents_page` VALUES ('26',NULL,'user','login',NULL,'Přihlášení','Přihlášení',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `documents_page` VALUES ('27',NULL,'user','change-password',NULL,'Změna hesla','Změna hesla',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `documents_page` VALUES ('28',NULL,'user','profile',NULL,'Profil','Profil','a:0:{}',NULL,NULL,'','0');
INSERT INTO `objects` VALUES ('1','0','folder','','/','999999','1','1508244399','1508244399','1','1',NULL,NULL);
INSERT INTO `objects` VALUES ('2','1','folder','novinky','/','0','1','1508244399','1508244399','2','2',NULL,NULL);
INSERT INTO `objects` VALUES ('3','1','folder','uzivatele','/','0','1','1508244399','1508244399','2','2',NULL,NULL);
INSERT INTO `objects` VALUES ('4','1','folder','kontakt','/','0','1','1508244399','1508244399','2','2',NULL,NULL);
INSERT INTO `objects` VALUES ('5','4','folder','kontaktni-formulare','/kontakt/','0','1','1508244399','1508244399','2','2',NULL,NULL);
INSERT INTO `objects` VALUES ('6','4','folder','newsletter','/kontakt/','0','1','1508244399','1508244399','2','2',NULL,NULL);
INSERT INTO `properties` VALUES ('1','document','/','language','text','cs','1');
INSERT INTO `properties` VALUES ('1','document','/','navigation_name','text','Úvod','0');
INSERT INTO `properties` VALUES ('1','document','/','navigation_title','text','Úvod','0');
INSERT INTO `properties` VALUES ('1','document','/','titlePostfix','text','Pimweb','1');
INSERT INTO `properties` VALUES ('1','document','/','titleSeparator','text',' - ','1');
INSERT INTO `properties` VALUES ('3','document','/system','sitemap_xml_exclude','bool','1','1');
INSERT INTO `properties` VALUES ('8','document','/o-nas','navigation_name','text','O nás','0');
INSERT INTO `properties` VALUES ('8','document','/o-nas','navigation_title','text','O nás','0');
INSERT INTO `properties` VALUES ('9','document','/kontakt','navigation_name','text','Kontakt','0');
INSERT INTO `properties` VALUES ('9','document','/kontakt','navigation_title','text','Kontakt','0');
INSERT INTO `properties` VALUES ('12','document','/ucet','elastic_search_exclude','bool','1','1');
INSERT INTO `properties` VALUES ('12','document','/ucet','navigation_name','text','Účet','0');
INSERT INTO `properties` VALUES ('12','document','/ucet','navigation_title','text','Účet','0');
INSERT INTO `properties` VALUES ('12','document','/ucet','sitemap_xml_exclude','bool','1','1');
INSERT INTO `properties` VALUES ('21','document','/mapa-stranek','navigation_name','text','Mapa stránek','0');
INSERT INTO `properties` VALUES ('21','document','/mapa-stranek','navigation_title','text','Mapa stránek','0');
INSERT INTO `properties` VALUES ('22','document','/aktuality','navigation_name','text','Aktuality','0');
INSERT INTO `properties` VALUES ('22','document','/aktuality','navigation_title','text','Aktuality','0');
INSERT INTO `properties` VALUES ('26','document','/prihlaseni','navigation_name','text','Přihlášení','0');
INSERT INTO `properties` VALUES ('26','document','/prihlaseni','navigation_title','text','Přihlášení','0');
INSERT INTO `properties` VALUES ('27','document','/ucet/zmena-hesla','navigation_name','text','Změna hesla','0');
INSERT INTO `properties` VALUES ('27','document','/ucet/zmena-hesla','navigation_title','text','Změna hesla','0');
INSERT INTO `properties` VALUES ('28','document','/ucet/profil','navigation_name','text','Profil','0');
INSERT INTO `properties` VALUES ('28','document','/ucet/profil','navigation_title','text','Profil','0');
INSERT INTO `search_backend_data` VALUES ('8','/o-nas','document','page','page','1','1508244399','1516565769','2','2','ID: 8  \nPath: /o-nas  \ndffdf asset /dokumenty/Screenshot at 2017-09-28 10-54-25.png O nás ','language:cs titlePostfix:Pimweb titleSeparator: -  navigation_name:O nás navigation_title:O nás ');
INSERT INTO `search_backend_data` VALUES ('24','/notifikace/pro-administratora-novy-kontaktni-formular','document','email','email','1','1508244399','1516485475','2','2','ID: 24  \nPath: /notifikace/pro-administratora-novy-kontaktni-formular  \nDobrý den v systému byl založen nový kontaktní formulář s klíčem %DataObject(form { method getKey }) . Obsah Jméno getFullName E-mail getEmail Telefon getPhone Zpráva getMessage Pimweb ','language:cs titlePostfix:Pimweb titleSeparator: -  ');
INSERT INTO `search_backend_data` VALUES ('6','/notifikace/newsletter','document','email','email','1','1508244399','1516485543','2','2','ID: 6  \nPath: /notifikace/newsletter  \nDobrý den Děkujeme že jste se přihlásili k odběru našeho newletteru. Jestliže do newsletteru nepřihlásili dobrovolně nebo v budoucnu budete chtít odhlásit můžete použít nasledující odkaz odhlášení %Text(unsubscribeUrl) Pimweb ','language:cs titlePostfix:Pimweb titleSeparator: -  ');
INSERT INTO `search_backend_data` VALUES ('16','/notifikace/reset-hesla','document','email','email','1','1508244399','1516485532','2','2','ID: 16  \nPath: /notifikace/reset-hesla  \nDobrý den Na Vašem účtu bylo požádáno o resetování hesla. Heslo si můžete změnit přes nasledujúcí odkaz %Text(link) Pimweb ','language:cs titlePostfix:Pimweb titleSeparator: -  ');
INSERT INTO `search_backend_data` VALUES ('14','/notifikace/registrace','document','email','email','1','1508244399','1516485460','2','2','ID: 14  \nPath: /notifikace/registrace  \nDobrý den Děkujeme za registraci na našich stránkách %Text(siteUrl) . Pro dokončení registrace použijte následující odkaz %Text(activationUrl) Pimweb ','language:cs titlePostfix:Pimweb titleSeparator: -  ');
INSERT INTO `search_backend_data` VALUES ('28','/ucet/profil','document','page','page','1','1508244399','1516528643','2','2','ID: 28  \nPath: /ucet/profil  \n Profil','language:cs titlePostfix:Pimweb titleSeparator: -  elastic_search_exclude:1 sitemap_xml_exclude:1 navigation_name:Profil navigation_title:Profil ');
INSERT INTO `search_backend_data` VALUES ('7','/system/chybova-stranka','document','page','page','1','1508244399','1516541784','2','2','ID: 7  \nPath: /system/chybova-stranka  \nUps! Zdá se že tato stránka není dostupná. Zkontrolujte URL adresu nebo pokračujte na hlavní stránku. Chybová ','language:cs titlePostfix:Pimweb titleSeparator: -  sitemap_xml_exclude:1 ');
INSERT INTO `translations_admin` VALUES ('Activation code','cs','Aktivační kód','1508244399','1508244399');
INSERT INTO `translations_admin` VALUES ('Activation code','en','Activation code','1508244399','1508244399');
INSERT INTO `translations_admin` VALUES ('area_email','cs','E-mail','1508244399','1508244399');
INSERT INTO `translations_admin` VALUES ('area_email','en','E-mail','1508244399','1508244399');
INSERT INTO `translations_admin` VALUES ('area_email_description','cs',' ','1508244399','1508244399');
INSERT INTO `translations_admin` VALUES ('area_email_description','en',' ','1508244399','1508244399');
INSERT INTO `translations_admin` VALUES ('area_gallery','cs','Galerie','1508244399','1508244399');
INSERT INTO `translations_admin` VALUES ('area_gallery','en','Gallery','1508244399','1508244399');
INSERT INTO `translations_admin` VALUES ('area_gallery_description','cs',' ','1508244399','1508244399');
INSERT INTO `translations_admin` VALUES ('area_gallery_description','en',' ','1508244399','1508244399');
INSERT INTO `translations_admin` VALUES ('area_textblock','cs','Text','1508244399','1508244399');
INSERT INTO `translations_admin` VALUES ('area_textblock','en','Text block','1508244399','1508244399');
INSERT INTO `translations_admin` VALUES ('area_textblock_description','cs',' ','1508244399','1508244399');
INSERT INTO `translations_admin` VALUES ('area_textblock_description','en',' ','1508244399','1508244399');
INSERT INTO `translations_admin` VALUES ('base_page','cs','Base Page','1508244399','1508244399');
INSERT INTO `translations_admin` VALUES ('base_page','en','Base Page','1508244399','1508244399');
INSERT INTO `translations_admin` VALUES ('blog','cs','Blog','1508244399','1508244399');
INSERT INTO `translations_admin` VALUES ('blog','en','Blog','1508244399','1508244399');
INSERT INTO `translations_admin` VALUES ('City','cs','Město','1508244399','1508244399');
INSERT INTO `translations_admin` VALUES ('City','en','City','1508244399','1508244399');
INSERT INTO `translations_admin` VALUES ('classname','cs','Název třídy','1508244399','1508244399');
INSERT INTO `translations_admin` VALUES ('classname','en','Class name','1508244399','1508244399');
INSERT INTO `translations_admin` VALUES ('Company','cs','Společnost','1508244399','1508244399');
INSERT INTO `translations_admin` VALUES ('Company','en','Company','1508244399','1508244399');
INSERT INTO `translations_admin` VALUES ('Contact','cs','Kontakt','1508244399','1508244399');
INSERT INTO `translations_admin` VALUES ('Contact','en','Contact','1508244399','1508244399');
INSERT INTO `translations_admin` VALUES ('ContactForm','cs','Kontaktní formulář','1508244399','1508244399');
INSERT INTO `translations_admin` VALUES ('ContactForm','en','Contact form','1508244399','1508244399');
INSERT INTO `translations_admin` VALUES ('Content','cs','Obsah','1508244399','1508244399');
INSERT INTO `translations_admin` VALUES ('Content','en','Content','1508244399','1508244399');
INSERT INTO `translations_admin` VALUES ('Creation date','cs','Datum vytvoření','1508244399','1508244399');
INSERT INTO `translations_admin` VALUES ('Creation date','en','Creation date','1508244399','1508244399');
INSERT INTO `translations_admin` VALUES ('creationdate','cs','Datum vytvoření','1508244399','1508244399');
INSERT INTO `translations_admin` VALUES ('creationdate','en','Creation date','1508244399','1508244399');
INSERT INTO `translations_admin` VALUES ('Czech','cs','Čeština','1508244399','1508244399');
INSERT INTO `translations_admin` VALUES ('Czech','en','Czech','1508244399','1508244399');
INSERT INTO `translations_admin` VALUES ('DIC','cs','DIČ','1508244399','1508244399');
INSERT INTO `translations_admin` VALUES ('DIC','en','DIČ','1508244399','1508244399');
INSERT INTO `translations_admin` VALUES ('Email','cs','E-mail','1508244399','1508244399');
INSERT INTO `translations_admin` VALUES ('Email','en','E-mail','1508244399','1508244399');
INSERT INTO `translations_admin` VALUES ('filename','cs','Název souboru (složky)','1508244399','1508244399');
INSERT INTO `translations_admin` VALUES ('filename','en','Filename','1508244399','1508244399');
INSERT INTO `translations_admin` VALUES ('First name','cs','Jméno','1508244399','1508244399');
INSERT INTO `translations_admin` VALUES ('First name','en','First name','1508244399','1508244399');
INSERT INTO `translations_admin` VALUES ('firstname','cs','Jméno','1508244399','1508244399');
INSERT INTO `translations_admin` VALUES ('firstname','en','First name','1508244399','1508244399');
INSERT INTO `translations_admin` VALUES ('fullpath','cs','Cesta','1508244399','1508244399');
INSERT INTO `translations_admin` VALUES ('fullpath','en','Full path','1508244399','1508244399');
INSERT INTO `translations_admin` VALUES ('gender','cs','Pohlaví','1508244399','1508244399');
INSERT INTO `translations_admin` VALUES ('gender','en','Gender','1508244399','1508244399');
INSERT INTO `translations_admin` VALUES ('Generate','cs','Generovat','1508244399','1508244399');
INSERT INTO `translations_admin` VALUES ('Generate','en','Generate','1508244399','1508244399');
INSERT INTO `translations_admin` VALUES ('IC','cs','IČ','1508244399','1508244399');
INSERT INTO `translations_admin` VALUES ('IC','en','IČ','1508244399','1508244399');
INSERT INTO `translations_admin` VALUES ('id','cs','ID','1508244399','1508244399');
INSERT INTO `translations_admin` VALUES ('id','en','ID','1508244399','1508244399');
INSERT INTO `translations_admin` VALUES ('Language','cs','Jazyk','1508244399','1508244399');
INSERT INTO `translations_admin` VALUES ('Language','en','Language','1508244399','1508244399');
INSERT INTO `translations_admin` VALUES ('Last name','cs','Příjmení','1508244399','1508244399');
INSERT INTO `translations_admin` VALUES ('Last name','en','Last name','1508244399','1508244399');
INSERT INTO `translations_admin` VALUES ('lastname','cs','Příjmení','1508244399','1508244399');
INSERT INTO `translations_admin` VALUES ('lastname','en','Last name','1508244399','1508244399');
INSERT INTO `translations_admin` VALUES ('Master','cs','','1508244399','1508244399');
INSERT INTO `translations_admin` VALUES ('Master','en','','1508244399','1508244399');
INSERT INTO `translations_admin` VALUES ('Master (Admin Mode)','cs','','1508244399','1508244399');
INSERT INTO `translations_admin` VALUES ('Master (Admin Mode)','en','','1508244399','1508244399');
INSERT INTO `translations_admin` VALUES ('Message','cs','Zpráva','1508244399','1508244399');
INSERT INTO `translations_admin` VALUES ('Message','en','Message','1508244399','1508244399');
INSERT INTO `translations_admin` VALUES ('modificationdate','cs','Datum poslední modifikace','1508244399','1508244399');
INSERT INTO `translations_admin` VALUES ('modificationdate','en','Modification date','1508244399','1508244399');
INSERT INTO `translations_admin` VALUES ('Name','cs','Jméno (Název)','1508244399','1508244399');
INSERT INTO `translations_admin` VALUES ('Name','en','Name','1508244399','1508244399');
INSERT INTO `translations_admin` VALUES ('News','cs','Novinka','1508244399','1508244399');
INSERT INTO `translations_admin` VALUES ('News','en','News','1508244399','1508244399');
INSERT INTO `translations_admin` VALUES ('News(pl)','cs','Novinky','1508244399','1508244399');
INSERT INTO `translations_admin` VALUES ('News(pl)','en','News','1508244399','1508244399');
INSERT INTO `translations_admin` VALUES ('Newsletter','cs','Newsletter','1508244508','1508244508');
INSERT INTO `translations_admin` VALUES ('Newsletter','en','Newsletter','1508244508','1508244508');
INSERT INTO `translations_admin` VALUES ('newsletter active','cs','Newsletter aktivní','1508244399','1508244399');
INSERT INTO `translations_admin` VALUES ('newsletter active','en','Newsletter active','1508244399','1508244399');
INSERT INTO `translations_admin` VALUES ('newsletter confirmed','cs','Newsletter potvrzen','1508244399','1508244399');
INSERT INTO `translations_admin` VALUES ('newsletter confirmed','en','Newsletter confirmed','1508244399','1508244399');
INSERT INTO `translations_admin` VALUES ('newsletterActive','cs','Newsletter aktivní','1508333192','1508333192');
INSERT INTO `translations_admin` VALUES ('newsletterActive','en','Newsletter active','1508333192','1508333192');
INSERT INTO `translations_admin` VALUES ('newsletterConfirmed','cs','Newsletter potvrzen','1508333192','1508333192');
INSERT INTO `translations_admin` VALUES ('newsletterConfirmed','en','Newsletter confirmed','1508333192','1508333192');
INSERT INTO `translations_admin` VALUES ('NewsletterForm','cs','Newsletter formulář','1508244399','1508244399');
INSERT INTO `translations_admin` VALUES ('NewsletterForm','en','Newsletter form','1508244399','1508244399');
INSERT INTO `translations_admin` VALUES ('password','cs','Heslo','1508244399','1508244399');
INSERT INTO `translations_admin` VALUES ('password','en','Password','1508244399','1508244399');
INSERT INTO `translations_admin` VALUES ('Password reset token','cs','Token k resetování hesla','1508244399','1508244399');
INSERT INTO `translations_admin` VALUES ('Password reset token','en','Password reset token','1508244399','1508244399');
INSERT INTO `translations_admin` VALUES ('Perex','cs','Perex','1508244399','1508244399');
INSERT INTO `translations_admin` VALUES ('Perex','en','Perex','1508244399','1508244399');
INSERT INTO `translations_admin` VALUES ('Phone','cs','Telefon','1508244399','1508244399');
INSERT INTO `translations_admin` VALUES ('Phone','en','Phone','1508244399','1508244399');
INSERT INTO `translations_admin` VALUES ('Preview image','cs','Náhledový obrázek','1508244399','1508244399');
INSERT INTO `translations_admin` VALUES ('Preview image','en','Preview image','1508244399','1508244399');
INSERT INTO `translations_admin` VALUES ('published','cs','Zveřejněno','1508244399','1508244399');
INSERT INTO `translations_admin` VALUES ('published','en','Published','1508244399','1508244399');
INSERT INTO `translations_admin` VALUES ('seo','cs','SEO','1508244399','1508244399');
INSERT INTO `translations_admin` VALUES ('seo','en','SEO','1508244399','1508244399');
INSERT INTO `translations_admin` VALUES ('Seo description','cs','SEO popisek','1508244399','1508244399');
INSERT INTO `translations_admin` VALUES ('Seo description','en','SEO description','1508244399','1508244399');
INSERT INTO `translations_admin` VALUES ('seo slug','cs','SEO slug','1508244399','1508244399');
INSERT INTO `translations_admin` VALUES ('seo slug','en','SEO slug','1508244399','1508244399');
INSERT INTO `translations_admin` VALUES ('Simple page','cs','Jednoduchá stránka','1508244399','1508244399');
INSERT INTO `translations_admin` VALUES ('Simple page','en','Simple page','1508244399','1508244399');
INSERT INTO `translations_admin` VALUES ('Street','cs','Ulice','1508244399','1508244399');
INSERT INTO `translations_admin` VALUES ('Street','en','Street','1508244399','1508244399');
INSERT INTO `translations_admin` VALUES ('text','cs','Text','1508244399','1508244399');
INSERT INTO `translations_admin` VALUES ('text','en','Text','1508244399','1508244399');
INSERT INTO `translations_admin` VALUES ('unsubscribe code','cs','Kód k odhlášení z newsletteru','1508244399','1508244399');
INSERT INTO `translations_admin` VALUES ('unsubscribe code','en','Unsubscribe code','1508244399','1508244399');
INSERT INTO `translations_admin` VALUES ('Url','cs','URL','1516791819','1516791819');
INSERT INTO `translations_admin` VALUES ('Url','en','URL','1516791819','1516791819');
INSERT INTO `translations_admin` VALUES ('User','cs','Uživatel','1508244399','1508244399');
INSERT INTO `translations_admin` VALUES ('User','en','User','1508244399','1508244399');
INSERT INTO `translations_admin` VALUES ('Users','cs','Uživatelé','1508244399','1508244399');
INSERT INTO `translations_admin` VALUES ('Users','en','Users','1508244399','1508244399');
INSERT INTO `translations_admin` VALUES ('Zip code','cs','PSČ','1508244399','1508244399');
INSERT INTO `translations_admin` VALUES ('Zip code','en','Zip code','1508244399','1508244399');
INSERT INTO `translations_website` VALUES ('label_add','cs','Přidat','1508244399','1508244399');
INSERT INTO `translations_website` VALUES ('label_agree_with_terms','cs','Souhlasím s <a href=\"/o-nas\" target=\"_blank\">podmínkami</a>','1508244399','1508244399');
INSERT INTO `translations_website` VALUES ('label_change','cs','Změnit','1508244399','1508244399');
INSERT INTO `translations_website` VALUES ('label_city','cs','Město','1508244399','1508244399');
INSERT INTO `translations_website` VALUES ('label_color','cs','Barva','1508244399','1508244399');
INSERT INTO `translations_website` VALUES ('label_company','cs','Firma','1508244399','1508244399');
INSERT INTO `translations_website` VALUES ('label_dic','cs','DIČ','1508244399','1508244399');
INSERT INTO `translations_website` VALUES ('label_edit','cs','Upravit','1508244399','1508244399');
INSERT INTO `translations_website` VALUES ('label_email','cs','E-mail','1508244399','1508244399');
INSERT INTO `translations_website` VALUES ('label_first_name','cs','Jméno','1508244399','1508244399');
INSERT INTO `translations_website` VALUES ('label_first_page','cs','První stránka','1508244399','1508244399');
INSERT INTO `translations_website` VALUES ('label_full_name','cs','Jméno','1508244399','1508244399');
INSERT INTO `translations_website` VALUES ('label_ic','cs','IČ','1508244399','1508244399');
INSERT INTO `translations_website` VALUES ('label_last_name','cs','Příjmení','1508244399','1508244399');
INSERT INTO `translations_website` VALUES ('label_last_page','cs','Poslední stránka','1508244399','1508244399');
INSERT INTO `translations_website` VALUES ('label_login','cs','Přihlásit','1508244399','1508244399');
INSERT INTO `translations_website` VALUES ('label_message','cs','Zpráva','1508244399','1508244399');
INSERT INTO `translations_website` VALUES ('label_message_text','cs','Text zprávy','1508244399','1508244399');
INSERT INTO `translations_website` VALUES ('label_newsletter','cs','Přihlásit se k odběru newsletteru','1508244399','1508244399');
INSERT INTO `translations_website` VALUES ('label_next_page','cs','Následující stránka','1508244399','1508244399');
INSERT INTO `translations_website` VALUES ('label_password','cs','Heslo','1508244399','1508244399');
INSERT INTO `translations_website` VALUES ('label_password_again','cs','Heslo znova','1508244399','1508244399');
INSERT INTO `translations_website` VALUES ('label_password_new','cs','Nové heslo','1508244399','1508244399');
INSERT INTO `translations_website` VALUES ('label_password_new_again','cs','Nove heslo znova','1508244399','1508244399');
INSERT INTO `translations_website` VALUES ('label_password_old','cs','Staré heslo','1508244399','1508244399');
INSERT INTO `translations_website` VALUES ('label_phone','cs','Telefon','1508244399','1508244399');
INSERT INTO `translations_website` VALUES ('label_previous_page','cs','Předchozí stránka','1508244399','1508244399');
INSERT INTO `translations_website` VALUES ('label_region1','cs','Moravskoslezský','1508244399','1508244399');
INSERT INTO `translations_website` VALUES ('label_region10','cs','Pardubický','1508244399','1508244399');
INSERT INTO `translations_website` VALUES ('label_region11','cs','Vysočina','1508244399','1508244399');
INSERT INTO `translations_website` VALUES ('label_region12','cs','Jihomoravský','1508244399','1508244399');
INSERT INTO `translations_website` VALUES ('label_region13','cs','Olomoucký','1508244399','1508244399');
INSERT INTO `translations_website` VALUES ('label_region14','cs','Zlínský','1508244399','1508244399');
INSERT INTO `translations_website` VALUES ('label_region2','cs','Středočeský','1508244399','1508244399');
INSERT INTO `translations_website` VALUES ('label_region3','cs','Praha','1508244399','1508244399');
INSERT INTO `translations_website` VALUES ('label_region4','cs','Jihočeský','1508244399','1508244399');
INSERT INTO `translations_website` VALUES ('label_region5','cs','Plzeňský','1508244399','1508244399');
INSERT INTO `translations_website` VALUES ('label_region6','cs','Karlovarský','1508244399','1508244399');
INSERT INTO `translations_website` VALUES ('label_region7','cs','Ústecký','1508244399','1508244399');
INSERT INTO `translations_website` VALUES ('label_region8','cs','Liberecký','1508244399','1508244399');
INSERT INTO `translations_website` VALUES ('label_region9','cs','Královéhradecký','1508244399','1508244399');
INSERT INTO `translations_website` VALUES ('label_register','cs','Registrovat','1508244399','1508244399');
INSERT INTO `translations_website` VALUES ('label_registration_address','cs','Registrační adresa','1508244399','1508244399');
INSERT INTO `translations_website` VALUES ('label_remember_me','cs','Zapamatovat','1508244399','1508244399');
INSERT INTO `translations_website` VALUES ('label_reset_password','cs','Resetovat heslo','1508244399','1508244399');
INSERT INTO `translations_website` VALUES ('label_search','cs','Hledat','1508244399','1508244399');
INSERT INTO `translations_website` VALUES ('label_send_me_newsletter','cs','Chci odebírat newsletter','1508244399','1508244399');
INSERT INTO `translations_website` VALUES ('label_street','cs','Ulice','1508244399','1508244399');
INSERT INTO `translations_website` VALUES ('label_submit','cs','Odeslat','1508244399','1508244399');
INSERT INTO `translations_website` VALUES ('label_submit_question','cs','Odeslat dotaz','1508244399','1508244399');
INSERT INTO `translations_website` VALUES ('label_title','cs','Název','1508244399','1508244399');
INSERT INTO `translations_website` VALUES ('label_zip_code','cs','PSČ','1508244399','1508244399');
INSERT INTO `translations_website` VALUES ('msg_account_activated','cs','Účet %s byl aktivován.','1508244399','1508244399');
INSERT INTO `translations_website` VALUES ('msg_activation_code_invalid','cs','Chyba - neplatný aktivační kód.','1508244399','1508244399');
INSERT INTO `translations_website` VALUES ('msg_address_inserted','cs','Adresa byla vložena.','1508244399','1508244399');
INSERT INTO `translations_website` VALUES ('msg_address_updated','cs','Adresa byla změněna.','1508244399','1508244399');
INSERT INTO `translations_website` VALUES ('msg_agree_with_terms','cs','Musíte souhlasit s podmínkami','1508244399','1508244399');
INSERT INTO `translations_website` VALUES ('msg_authentication_error','cs','Neplatné přihlašovací údaje.','1508244399','1508244399');
INSERT INTO `translations_website` VALUES ('msg_authentication_required','cs','Pro přístup do této sekce se musíte přihlásit.','1516447628','1516447789');
INSERT INTO `translations_website` VALUES ('msg_authentication_successful','cs','Přihlášení proběhlo úspěšně.','1508244399','1508244399');
INSERT INTO `translations_website` VALUES ('msg_bad_format','cs','Údaj má nesprávný formát','1508244399','1508244399');
INSERT INTO `translations_website` VALUES ('msg_bad_format_phone','cs','Zadejte prosím správné číslo telefonu s předvolbou a bez mezer (napr. +420123456789).','1508244399','1508244399');
INSERT INTO `translations_website` VALUES ('msg_contact_form_success','cs','Kontaktní formulář byl odeslán.','1508244399','1508244399');
INSERT INTO `translations_website` VALUES ('msg_email_not_registered','cs','Chyba - E-mail %s není registrován.','1508244399','1508244399');
INSERT INTO `translations_website` VALUES ('msg_email_registered','cs','E-mail obsazen','1508244399','1508244399');
INSERT INTO `translations_website` VALUES ('msg_email_registered_for_quick_registration','cs','Na zadaný e-mail již je vytvořen účet, přihlašte se prosím','1508244399','1508244399');
INSERT INTO `translations_website` VALUES ('msg_empty_field','cs','Pole nesmí zůstat prázdné','1508244399','1508244399');
INSERT INTO `translations_website` VALUES ('msg_file_not_uploaded','cs','Soubor se nepovedlo nahrát na server.','1508244399','1508244399');
INSERT INTO `translations_website` VALUES ('msg_file_too_big','cs','Soubor je příliš velký.','1508244399','1508244399');
INSERT INTO `translations_website` VALUES ('msg_form_invalid','cs','Zdá se, že formulář obsahuje chyby. Zkontrolujte a zkuste ho odoslat znovu.','1508244399','1508244399');
INSERT INTO `translations_website` VALUES ('msg_invalid_email','cs','E-mail má nesprávný formát','1508244399','1508244399');
INSERT INTO `translations_website` VALUES ('msg_invalid_request','cs','Neplatný požadavek.','1508244399','1508244399');
INSERT INTO `translations_website` VALUES ('msg_invalid_token','cs','Neplatný token.','1508244399','1508244399');
INSERT INTO `translations_website` VALUES ('msg_logout_successful','cs','Odhlášení proběhlo úspěšně.','1508244399','1508244399');
INSERT INTO `translations_website` VALUES ('msg_newsletter_already_registered','cs','Chyba - E-mail %s již je registrován do newsletteru.','1508244399','1508244399');
INSERT INTO `translations_website` VALUES ('msg_newsletter_code_invalid','cs','Chyba - neplatný kód pro odhlášení z newsletteru.','1508244399','1508244399');
INSERT INTO `translations_website` VALUES ('msg_newsletter_registered','cs','E-mail %s byl zařazen do newsletteru.','1508244399','1508244399');
INSERT INTO `translations_website` VALUES ('msg_newsletter_unsubscribed','cs','E-mail %s byl odstraněn z newsletteru.','1508244399','1508244399');
INSERT INTO `translations_website` VALUES ('msg_no_items_found','cs','Zadaným kritériím nevyhovují žádné položky.','1508244399','1508244399');
INSERT INTO `translations_website` VALUES ('msg_not_an_image','cs','Soubor není obrázkem.','1508244399','1508244399');
INSERT INTO `translations_website` VALUES ('msg_password_change_successfull','cs','Heslo bylo změněno.','1508244399','1508244399');
INSERT INTO `translations_website` VALUES ('msg_password_reset_successfull','cs','Na registrační e-mail %s Vám byl zaslán odkaz pro změnu hesla.','1508244399','1508244399');
INSERT INTO `translations_website` VALUES ('msg_passwords_do_not_match','cs','Hesla se neshodují','1508244399','1508244399');
INSERT INTO `translations_website` VALUES ('msg_profile_changed','cs','Profil byl úspěšně změněn','1516521457','1516522314');
INSERT INTO `translations_website` VALUES ('msg_registration_successfull','cs','Registrace proběhla úspěšně. Na e-mail %s byli odeslány instrukce k aktivaci Vášho účtu.','1508244399','1508244399');
INSERT INTO `translations_website` VALUES ('msg_select_file','cs','Vyberte soubor.','1508244399','1508244399');
INSERT INTO `translations_website` VALUES ('msg_unknown_error','cs','Došlo k neznámé chybě.','1508244399','1508244399');
INSERT INTO `translations_website` VALUES ('msg_wrong_old_password','cs','Staré heslo není správné','1508244399','1508244399');
INSERT INTO `translations_website` VALUES ('system_an_error_occured','cs','Vyskytla se chyba.','1508244399','1508244399');
INSERT INTO `translations_website` VALUES ('system_application_error','cs','500 - Chyba aplikace.','1508244399','1508244399');
INSERT INTO `translations_website` VALUES ('system_empty_page','cs','Tato stránka nemá obsah a slouží pouze jako blok v stromové struktuře stránek.','1516541913','1516542041');
INSERT INTO `translations_website` VALUES ('system_page_not_found','cs','404 - Stránka nenalezena.','1508244399','1508244399');
INSERT INTO `translations_website` VALUES ('system_return_to_homepage','cs','Zpět na úvodní stránku.','1508244399','1508244399');
INSERT INTO `translations_website` VALUES ('title_add_address','cs','Přidání adresy','1508244399','1508244399');
INSERT INTO `translations_website` VALUES ('title_addresses_management','cs','Správa adres','1508244399','1508244399');
INSERT INTO `translations_website` VALUES ('title_change_password','cs','Změna hesla','1508244399','1508244399');
INSERT INTO `translations_website` VALUES ('title_edit_address','cs','Úprava adresy %s','1508244399','1508244399');
INSERT INTO `translations_website` VALUES ('title_orders_management','cs','Správa objednávek','1508244399','1508244399');
INSERT INTO `users` VALUES ('0','0','user','system',NULL,NULL,NULL,NULL,NULL,NULL,'1','1',NULL,NULL,NULL,NULL,NULL,'1',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `users` VALUES ('2','0','user','admin','$2y$10$YVpsUlZx3BU0de3UQt/SHugfczlNdfXZ9YVSKVJA9McBPKaQglWKq','','','','en','cs','1','1','application_logging,assets,backup,classes,clear_cache,clear_temp_files,dashboards,documents,document_types,emails,gdpr_data_extractor,glossary,http_errors,notes_events,objects,piwik_reports,piwik_settings,plugins,predefined_properties,qr_codes,recyclebin,redirects,reports,robots.txt,routes,seemode,seo_document_editor,share_configurations,system_settings,tags_assignment,tags_configuration,tags_search,tag_snippet_management,targeting,thumbnails,translations,users,website_settings','','0','1','1','1','','','','default','','','');
INSERT INTO `users` VALUES ('3','0','role','editor',NULL,NULL,NULL,NULL,NULL,NULL,'0','1','assets,clear_cache,dashboards,documents,emails,notes_events,objects,qr_codes,recyclebin,reports,translations',NULL,NULL,NULL,'1','1','1','4,5,6,10',NULL,NULL,'editor',NULL,NULL);
INSERT INTO `users` VALUES ('4','0','user','editor','2850ba172924bfb6a64f902ee4a32691','','','','cs','cs','0','1','','3','1','1','0','1','','','','editor','','','');
INSERT INTO `users_permission_definitions` VALUES ('application_logging');
INSERT INTO `users_permission_definitions` VALUES ('assets');
INSERT INTO `users_permission_definitions` VALUES ('backup');
INSERT INTO `users_permission_definitions` VALUES ('classes');
INSERT INTO `users_permission_definitions` VALUES ('clear_cache');
INSERT INTO `users_permission_definitions` VALUES ('clear_temp_files');
INSERT INTO `users_permission_definitions` VALUES ('dashboards');
INSERT INTO `users_permission_definitions` VALUES ('documents');
INSERT INTO `users_permission_definitions` VALUES ('document_types');
INSERT INTO `users_permission_definitions` VALUES ('emails');
INSERT INTO `users_permission_definitions` VALUES ('gdpr_data_extractor');
INSERT INTO `users_permission_definitions` VALUES ('glossary');
INSERT INTO `users_permission_definitions` VALUES ('http_errors');
INSERT INTO `users_permission_definitions` VALUES ('notes_events');
INSERT INTO `users_permission_definitions` VALUES ('objects');
INSERT INTO `users_permission_definitions` VALUES ('piwik_reports');
INSERT INTO `users_permission_definitions` VALUES ('piwik_settings');
INSERT INTO `users_permission_definitions` VALUES ('plugins');
INSERT INTO `users_permission_definitions` VALUES ('predefined_properties');
INSERT INTO `users_permission_definitions` VALUES ('qr_codes');
INSERT INTO `users_permission_definitions` VALUES ('recyclebin');
INSERT INTO `users_permission_definitions` VALUES ('redirects');
INSERT INTO `users_permission_definitions` VALUES ('reports');
INSERT INTO `users_permission_definitions` VALUES ('robots.txt');
INSERT INTO `users_permission_definitions` VALUES ('routes');
INSERT INTO `users_permission_definitions` VALUES ('seemode');
INSERT INTO `users_permission_definitions` VALUES ('seo_document_editor');
INSERT INTO `users_permission_definitions` VALUES ('share_configurations');
INSERT INTO `users_permission_definitions` VALUES ('system_settings');
INSERT INTO `users_permission_definitions` VALUES ('tags_assignment');
INSERT INTO `users_permission_definitions` VALUES ('tags_configuration');
INSERT INTO `users_permission_definitions` VALUES ('tags_search');
INSERT INTO `users_permission_definitions` VALUES ('tag_snippet_management');
INSERT INTO `users_permission_definitions` VALUES ('targeting');
INSERT INTO `users_permission_definitions` VALUES ('thumbnails');
INSERT INTO `users_permission_definitions` VALUES ('translations');
INSERT INTO `users_permission_definitions` VALUES ('users');
INSERT INTO `users_permission_definitions` VALUES ('website_settings');
INSERT INTO `users_workspaces_asset` VALUES ('1','/','3','1','1','1','1','1','1','1','1','1');
INSERT INTO `users_workspaces_document` VALUES ('1','/','3','1','1','1','1','1','1','1','1','1','1','1');
INSERT INTO `users_workspaces_document` VALUES ('3','/system','3','0','0','0','0','0','0','0','0','0','0','0');
INSERT INTO `users_workspaces_document` VALUES ('5','/notifikace','3','1','1','1','1','1','1','1','1','1','1','1');
INSERT INTO `users_workspaces_object` VALUES ('2','/novinky','3','1','1','1','1','1','1','1','1','1','1','1',NULL,NULL,NULL);
INSERT INTO `users_workspaces_object` VALUES ('3','/uzivatele','3','1','1','1','1','1','0','0','0','1','1','1',NULL,NULL,NULL);
INSERT INTO `users_workspaces_object` VALUES ('4','/kontakt','3','1','1','1','1','1','1','0','0','1','1','1',NULL,NULL,NULL);
INSERT INTO `website_settings` VALUES ('1','frontendLanguages','text','cs','0','1508244399','1508244399');


DROP VIEW IF EXISTS `object_10`;
CREATE ALGORITHM=UNDEFINED  VIEW `object_10` AS select `object_query_10`.`oo_id` AS `oo_id`,`object_query_10`.`oo_classId` AS `oo_classId`,`object_query_10`.`oo_className` AS `oo_className`,`object_query_10`.`email` AS `email`,`object_query_10`.`password` AS `password`,`object_query_10`.`activationCode` AS `activationCode`,`object_query_10`.`lang` AS `lang`,`object_query_10`.`firstName` AS `firstName`,`object_query_10`.`lastName` AS `lastName`,`object_query_10`.`phone` AS `phone`,`object_query_10`.`street` AS `street`,`object_query_10`.`city` AS `city`,`object_query_10`.`zipCode` AS `zipCode`,`object_query_10`.`company` AS `company`,`object_query_10`.`dic` AS `dic`,`object_query_10`.`passwordResetToken` AS `passwordResetToken`,`object_query_10`.`ic` AS `ic`,`objects`.`o_id` AS `o_id`,`objects`.`o_parentId` AS `o_parentId`,`objects`.`o_type` AS `o_type`,`objects`.`o_key` AS `o_key`,`objects`.`o_path` AS `o_path`,`objects`.`o_index` AS `o_index`,`objects`.`o_published` AS `o_published`,`objects`.`o_creationDate` AS `o_creationDate`,`objects`.`o_modificationDate` AS `o_modificationDate`,`objects`.`o_userOwner` AS `o_userOwner`,`objects`.`o_userModification` AS `o_userModification`,`objects`.`o_classId` AS `o_classId`,`objects`.`o_className` AS `o_className` from (`object_query_10` join `objects` on((`objects`.`o_id` = `object_query_10`.`oo_id`)));

DROP VIEW IF EXISTS `object_4`;
CREATE ALGORITHM=UNDEFINED  VIEW `object_4` AS select `object_query_4`.`oo_id` AS `oo_id`,`object_query_4`.`oo_classId` AS `oo_classId`,`object_query_4`.`oo_className` AS `oo_className`,`object_query_4`.`createdOn` AS `createdOn`,`object_query_4`.`previewImage__image` AS `previewImage__image`,`object_query_4`.`previewImage__hotspots` AS `previewImage__hotspots`,`objects`.`o_id` AS `o_id`,`objects`.`o_parentId` AS `o_parentId`,`objects`.`o_type` AS `o_type`,`objects`.`o_key` AS `o_key`,`objects`.`o_path` AS `o_path`,`objects`.`o_index` AS `o_index`,`objects`.`o_published` AS `o_published`,`objects`.`o_creationDate` AS `o_creationDate`,`objects`.`o_modificationDate` AS `o_modificationDate`,`objects`.`o_userOwner` AS `o_userOwner`,`objects`.`o_userModification` AS `o_userModification`,`objects`.`o_classId` AS `o_classId`,`objects`.`o_className` AS `o_className` from (`object_query_4` join `objects` on((`objects`.`o_id` = `object_query_4`.`oo_id`)));

DROP VIEW IF EXISTS `object_5`;
CREATE ALGORITHM=UNDEFINED  VIEW `object_5` AS select `object_query_5`.`oo_id` AS `oo_id`,`object_query_5`.`oo_classId` AS `oo_classId`,`object_query_5`.`oo_className` AS `oo_className`,`object_query_5`.`fullName` AS `fullName`,`object_query_5`.`email` AS `email`,`object_query_5`.`phone` AS `phone`,`object_query_5`.`message` AS `message`,`object_query_5`.`lang` AS `lang`,`objects`.`o_id` AS `o_id`,`objects`.`o_parentId` AS `o_parentId`,`objects`.`o_type` AS `o_type`,`objects`.`o_key` AS `o_key`,`objects`.`o_path` AS `o_path`,`objects`.`o_index` AS `o_index`,`objects`.`o_published` AS `o_published`,`objects`.`o_creationDate` AS `o_creationDate`,`objects`.`o_modificationDate` AS `o_modificationDate`,`objects`.`o_userOwner` AS `o_userOwner`,`objects`.`o_userModification` AS `o_userModification`,`objects`.`o_classId` AS `o_classId`,`objects`.`o_className` AS `o_className` from (`object_query_5` join `objects` on((`objects`.`o_id` = `object_query_5`.`oo_id`)));

DROP VIEW IF EXISTS `object_6`;
CREATE ALGORITHM=UNDEFINED  VIEW `object_6` AS select `object_query_6`.`oo_id` AS `oo_id`,`object_query_6`.`oo_classId` AS `oo_classId`,`object_query_6`.`oo_className` AS `oo_className`,`object_query_6`.`email` AS `email`,`object_query_6`.`lang` AS `lang`,`object_query_6`.`unsubscribeCode` AS `unsubscribeCode`,`object_query_6`.`firstname` AS `firstname`,`object_query_6`.`lastname` AS `lastname`,`object_query_6`.`gender` AS `gender`,`object_query_6`.`newsletterActive` AS `newsletterActive`,`object_query_6`.`newsletterConfirmed` AS `newsletterConfirmed`,`objects`.`o_id` AS `o_id`,`objects`.`o_parentId` AS `o_parentId`,`objects`.`o_type` AS `o_type`,`objects`.`o_key` AS `o_key`,`objects`.`o_path` AS `o_path`,`objects`.`o_index` AS `o_index`,`objects`.`o_published` AS `o_published`,`objects`.`o_creationDate` AS `o_creationDate`,`objects`.`o_modificationDate` AS `o_modificationDate`,`objects`.`o_userOwner` AS `o_userOwner`,`objects`.`o_userModification` AS `o_userModification`,`objects`.`o_classId` AS `o_classId`,`objects`.`o_className` AS `o_className` from (`object_query_6` join `objects` on((`objects`.`o_id` = `object_query_6`.`oo_id`)));

DROP VIEW IF EXISTS `object_localized_4_cs`;
CREATE ALGORITHM=UNDEFINED  VIEW `object_localized_4_cs` AS select `object_query_4`.`oo_id` AS `oo_id`,`object_query_4`.`oo_classId` AS `oo_classId`,`object_query_4`.`oo_className` AS `oo_className`,`object_query_4`.`createdOn` AS `createdOn`,`object_query_4`.`previewImage__image` AS `previewImage__image`,`object_query_4`.`previewImage__hotspots` AS `previewImage__hotspots`,`objects`.`o_id` AS `o_id`,`objects`.`o_parentId` AS `o_parentId`,`objects`.`o_type` AS `o_type`,`objects`.`o_key` AS `o_key`,`objects`.`o_path` AS `o_path`,`objects`.`o_index` AS `o_index`,`objects`.`o_published` AS `o_published`,`objects`.`o_creationDate` AS `o_creationDate`,`objects`.`o_modificationDate` AS `o_modificationDate`,`objects`.`o_userOwner` AS `o_userOwner`,`objects`.`o_userModification` AS `o_userModification`,`objects`.`o_classId` AS `o_classId`,`objects`.`o_className` AS `o_className`,`cs`.`ooo_id` AS `ooo_id`,`cs`.`language` AS `language`,`cs`.`name` AS `name`,`cs`.`seoDescription` AS `seoDescription`,`cs`.`perex` AS `perex`,`cs`.`content` AS `content`,`cs`.`url` AS `url` from ((`object_query_4` join `objects` on((`objects`.`o_id` = `object_query_4`.`oo_id`))) left join `object_localized_query_4_cs` `cs` on((1 and (`object_query_4`.`oo_id` = `cs`.`ooo_id`))));
