<?php

namespace AppBundle\Model;

use AppBundle\Tool\Utils;
use Pimcore\Model\DataObject;

class News extends DataObject\News implements IElasticObjectFulltext
{
	use ElasticTrait;

	/*								Helpers										*/

	/*								Mapped										*/

	/**
	 * {@inheritdoc}
	 */
	public function save()
	{
		parent::save();

		if (Utils::elasticSearchEnabled()) {
			$this->elasticSearchUpdateFulltext();
		}
	}

	/**
	 * {@inheritdoc}
	 */
	public function delete()
	{
		if (Utils::elasticSearchEnabled()) {
			$this->elasticSearchDeleteFulltext();
		}

		parent::delete();
	}

	/* 								For elastic search							 */

	/**
	 * returns elastic search document data structure.
	 *
	 * @param string $lang
	 *
	 * @return array
	 */
	public function elasticSearchLoadFulltext($lang)
	{
		$data = array_merge($this->getElasticBaseData(), [
			'path' => $this->getUrl($lang),
			'title' => $this->getName($lang),
			'description' => $this->getSeoDescription($lang),
			'content' => $this->renderView('Cms/newsDetail.html.php', $lang, [
				'news' => $this,
			]),
		]);

		return $data;
	}
}
