pimcore.registerNS("pimcore.plugin.backend");

pimcore.plugin.backend = Class.create(pimcore.plugin.admin, {
	getClassName: function () {
		return "pimcore.plugin.backend";
	},

	initialize: function () {
		pimcore.plugin.broker.registerPlugin(this);
	},

	pimcoreReady: function (params, broker){
		//CKE config for objects and documents
		pimcore.globalmanager.add('websiteEditorConfig', {
			resize_enabled: false,
			entities: false,
			entities_greek: false,
			entities_latin: false,
			disableNativeSpellChecker: false,
			allowedContent: true, // disables CKEditor ACF completely
			//extraAllowedContent: '*[pimcore_type,pimcore_id]', //this prevents CKE from removing pimcore attributes from elements
			language: pimcore.settings['language'],
			enterMode: 1,
			toolbar: [
				{ name: 'clipboard', items: [ 'Cut', 'Copy', 'Paste', 'PasteText', 'PasteFromWord', '-', 'Undo', 'Redo' ] },
				{ name: 'links', items: [ 'Link', 'Unlink', 'Anchor' ] },
				{ name: 'insert', items: [ 'Image', 'Table', 'HorizontalRule', 'SpecialChar', 'Iframe' ] },
				{ name: 'tools', items: [ 'Sourcedialog' ] },
				'/',
				{ name: 'styles', items: [ 'Styles', 'Format' ] },
				{ name: 'align', items: [ 'JustifyLeft', 'JustifyCenter', 'JustifyRight', 'JustifyBlock' ] },
				{ name: 'basicstyles', items: [ 'Bold', 'Italic', 'Strike', '-', 'RemoveFormat' ] },
				{ name: 'paragraph', items: [ 'NumberedList', 'BulletedList' ] },
			],
			stylesSet: 'websiteEditorStyles:/bundles/app/js/pimcore/cke_styles.js',
			format_tags: 'h1;h2;h3;h4;h5;h6;p',
			removeDialogTabs: 'image:Upload;table:advanced;iframe:advanced',
			ext: {
				dialogDefinitionCallback: function (ev) {
					var dialogName = ev.data.name;
					var dialogDefinition = ev.data.definition;
					var infoTab = null;
					var advancedTab = null;
					if (dialogName == 'link') {
						advancedTab = dialogDefinition.getContents('advanced');
						advancedTab.remove('advId');
						advancedTab.remove('advLangDir');
						advancedTab.remove('advAccessKey');
						advancedTab.remove('advName');
						advancedTab.remove('advLangCode');
						advancedTab.remove('advTabIndex');
						advancedTab.remove('advContentType');
						advancedTab.remove('advCSSClasses');
						advancedTab.remove('advCharset');
						advancedTab.remove('advRel');
						advancedTab.remove('advStyles');
					} else if (dialogName == 'image') {
						infoTab = dialogDefinition.getContents('info');
						advancedTab = dialogDefinition.getContents('advanced');

						infoTab.remove('txtBorder');
						infoTab.remove('txtHSpace');
						infoTab.remove('txtVSpace');
						infoTab.remove('cmbAlign');
						advancedTab.remove('linkId');
						advancedTab.remove('cmbLangDir');
						advancedTab.remove('txtLangCode');
						advancedTab.remove('txtGenLongDescr');
						advancedTab.remove('txtGenClass');
						advancedTab.remove('txtdlgGenStyle');
					} else if (dialogName == 'iframe') {
						infoTab = dialogDefinition.getContents('info');
						infoTab.remove('align');
						infoTab.remove('scrolling');
						infoTab.remove('name');
						infoTab.remove('title');
						infoTab.remove('longdesc');
					} else if (dialogName == 'table') {
						infoTab = dialogDefinition.getContents('info');
						infoTab.remove('txtWidth');
						infoTab.remove('txtHeight');
						infoTab.remove('txtBorder');
						infoTab.remove('txtCellSpace');
						infoTab.remove('txtCellPad');
						infoTab.remove('txtSummary');
						infoTab.remove('cmbAlign');
					}
				}
			}
		});
		CKEDITOR.dtd.$removeEmpty.i = 0;
		CKEDITOR.dtd.$removeEmpty.em = 0;
		CKEDITOR.on('dialogDefinition', pimcore.globalmanager.get('websiteEditorConfig').ext.dialogDefinitionCallback);
		pimcore.object.tags.wysiwyg.defaultEditorConfig = pimcore.globalmanager.get('websiteEditorConfig');

		// turn off asset and document tree previews
		var assetTree = pimcore.globalmanager.get('layout_asset_tree');
		var documentTree = pimcore.globalmanager.get('layout_document_tree');
		if (assetTree) {
			if (assetTree.tree.events.itemmouseenter) {
				assetTree.tree.events.itemmouseenter.clearListeners();
			}
			if (assetTree.tree.events.itemmouseleave) {
				assetTree.tree.events.itemmouseleave.clearListeners();
			}
		}
		if (documentTree) {
			if (documentTree.tree.events.itemmouseenter) {
				documentTree.tree.events.itemmouseenter.clearListeners();
			}
			if (documentTree.tree.events.itemmouseleave) {
				documentTree.tree.events.itemmouseleave.clearListeners();
			}
		}

		//append tools menu to main toolbar
		$.ajax({
			type: "GET",
			url: '/plugin/backend/is-elastic-search-enabled',
			success: function(data) {
				if (data.ese) {
					var menu = new Ext.menu.Menu({
						items: [{
							text: t("plugin_backend_reindex_elastic"),
							iconCls: "pimcore_icon_clear_cache",
							handler: function() {
								Ext.Msg.confirm(t('warning'), t('plugin_backend_this_may_take_a_while'), function(btn){
									if (btn == 'yes'){
										pimcore.globalmanager.get("loadingmask").show();
										Ext.Ajax.request({
											url: '/plugin/backend/reindex-elastic-search',
											success: function (response) {
												pimcore.globalmanager.get("loadingmask").hide();
											},
											failure: function () {
												pimcore.globalmanager.get("loadingmask").hide();
												Ext.MessageBox.alert(t("error"), t("plugin_backend_error_reindexing_elastic"));
											}
										});
									}
								});
							}
						}],
						cls: "pimcore_navigation_flyout"
					});
					var toolbar = pimcore.globalmanager.get("layout_toolbar");
					this.navEl = Ext.get('pimcore_menu_search').insertSibling('<li id="pimcore_menu_tools" class="pimcore_menu_item">'+t('plugin_backend_tools')+'</li>');
					this.navEl.on("mousedown", toolbar.showSubMenu.bind(menu));
				}
			}
		});
	}
});

var backendPlugin = new pimcore.plugin.backend();
