<?php

set('web_name', basename(realpath(__DIR__.'/../../../../')));
dump(get('web_name')); exit;
set('default_stage', 'vm3_production');

/*
 * local mysql root access
 */
env('bin/local/mysql', 'mysql --login-path=deployment');
env('bin/local/mysqldump', 'mysqldump --login-path=deployment');
env('bin/local/mysqladmin', 'mysqladmin --login-path=deployment');

/*
 * vhosts templates
 */
$vm3VhostConfigTemplate = str_replace('###WEB_NAME###', get('web_name'),
'<VirtualHost *:80>
	ServerName			###WEB_NAME###.cz
	ServerAlias			*.###WEB_NAME###.cz
	ServerAlias			###WEB_NAME###.vm3.portadesign.cz *.###WEB_NAME###.vm3.portadesign.cz

	CustomLog			"/data/hosting/###WEB_NAME###/logs/access_log" combined
	ErrorLog			"/data/hosting/###WEB_NAME###/logs/error_log"
	DocumentRoot		"/data/hosting/###WEB_NAME###/html"

	RewriteEngine		On
	# this is needed to pass the auth header correctly - fastcgi environment
	RewriteRule .* - [E=HTTP_AUTHORIZATION:%{HTTP:Authorization},L]
</VirtualHost>');

/*
 * cache configs
 */
set('cache_frontend', [
	'type' => 'Core',
	'options' => [
		'cache_id_prefix' => get('web_name').'_',
		'lifetime' => '99999',
		'automatic_serialization' => 'true',
	],
]);
$cacheConfigs = [
	'redis' => [
		'frontend' => get('cache_frontend'),
		'backend' => [
			'type' => '\\Pimcore\\Cache\\Backend\\Redis2',
			'custom' => 'true',
			'options' => [
				'server' => '127.0.0.1',
				'port' => '6379',
				'persistent' => '1',
				'database' => '1',
				'use_lua' => '1',
				'dbname' => get('web_name'),
			],
		],
	],
	'mongo' => [
		'frontend' => get('cache_frontend'),
		'backend' => [
			'type' => '\\Pimcore\\Cache\\Backend\\Mongodb',
			'custom' => 'true',
			'options' => [
				'dbname' => get('web_name'),
			],
		],
	],
	'memcached' => [
		'frontend' => get('cache_frontend'),
		'backend' => [
			'type' => '\\Pimcore\\Cache\\Backend\\Memcached',
			'custom' => 'true',
			'options' => [
				'tags_do_not_switch_to_innodb' => true,
				'compatibility' => true,
				'servers' => [
					[
						'host' => 'localhost',
						'port' => '112211',
						'persistent' => true,
					],
				],
			],
		],
	],
];
/*
 * uncomment this to use custom local cache backend before synchronization
 * otherwise MySQL will be used as cache backend
 */
//set('local_cache_config', $cacheConfigs['redis']);

/*
 * Remote servers configration examples
 *
 * See http://deployer.org/docs/servers for base options
 *
 * Custom options:
 *
 * {{sudo}}
 *   - means the user has sudo rights without entering password on the server
 * {{hosting_path | project_path}} [required]
 *   {{hosting_path}} - webroot will be created at hosting_path/html/{{web_name}} together with some other vhost related directories
 *   {{project_path}} - instead of hosting_path when you already have a pre-created webroot
 * {{http_user}} [sudo, optional]
 *   - will be set as file owner and the cron task will be set in his name
 * {{user_group}} [sudo, optional]
 *   - will be set as file group
 * {{mysql_db}} [optional]
 *   - if specified, that DB will be used (not created)
 *   - otherwise {{web_name}} DB will be created and used (the mysql user must have the rights to create)
 * {{mysql_user, mysql_password | mysql_login_path}} [optional]
 *   - {{mysql_user}}, {{mysql_password}}
 *   - {{mysql_login_path}} - alternative mysql login method (since mysql 5.6)
 * {{vhosts_path}} [sudo, optional]
 *   - vhost will be created here
 * {{vhosts_config_template}} [required if {{vhosts_path}}]
 *   - vhost config template with some placeholders, see above
 * {{vhost_symlink_path}} [sudo, optional]
 *   - vhost symlink will be created here
 * {{apache_reload_command}} [sudo, optional]
 *   - command to reload apache after certain tasks
 * {{cache_config}} [optional]
 *   - pimcore cache backend configuration, without it mysql cache backend will be used
 */
server('noSudo_createdDB_createdWebRoot', 'example.com')
	->user('martin')
	->identityFile('~/.ssh/id_rsa.pub', '~/.ssh/id_rsa', '')
	->env('project_path', '')
	->env('mysql_db', '')
	->env('cache_config', $cacheConfigs['redis'])
	->stage('noSudo_createdDB_createdWebRoot_production');

server('vm3', 'vm3.portadesign.cz')
	->user('martin')
	->identityFile('~/.ssh/id_rsa.pub', '~/.ssh/id_rsa', '')
	->env('sudo', true)
	->env('hosting_path', '/data/hosting')
	->env('user_group', 'portadesign')
	->env('mysql_login_path', 'deployment')
	->env('http_user', 'www-data')
	->env('vhosts_path', '/etc/apache2/sites-available')
	->env('vhosts_symlink_path', '/etc/apache2/sites-enabled')
	->env('vhosts_config_template', $vm3VhostConfigTemplate)
	->env('apache_reload_command', 'service apache2 reload')
	->env('cache_config', $cacheConfigs['redis'])
	->stage('vm3_production');
