<?
/**
 * @var \Pimcore\Templating\PhpEngine $this
 * @var \Pimcore\Templating\PhpEngine $view
 * @var \Pimcore\Templating\GlobalVariables $app
 */
?>
<? if ($this->editmode): ?>
	<?=$this->editable('gallery_images', 'multihref');?>
<? else: ?>
	<?
		$elements = $this->multihref('gallery_images')->getElements();
		$galleryRelId = (\Pimcore\Cache\Runtime::isRegistered('document_gallery_rel_id'))
			? \Pimcore\Cache\Runtime::get('document_gallery_rel_id') + 1
			: 1;
		\Pimcore\Cache\Runtime::set('document_gallery_rel_id', $galleryRelId);
	?>
	<?if(!empty($elements)):?>
		<div class="entry">
			<div class="row-fluid">
				<?while($element = array_shift($elements)):?>
					<?
						if ($element instanceof \Pimcore\Model\Asset\Folder) {
							foreach ($element->getChildren() as $child) {
								$elements[] = $child;
							}
						}
					?>
					<?if($element instanceof \Pimcore\Model\Asset\Image):?>
						<?
							$title = $element->getMetadata('title', $this->language);
							$alt = $element->getMetadata('alt', $this->language);
						?>
						<a class="fancybox" rel="gallery<?=$galleryRelId;?>" href="<?=$element->getRelativeFilesystemPath();?>"<?if(!empty($title)) echo ' title="'.$this->escape($title).'"';?>>
							<?= \AppBundle\Tool\Utils::image($element, $this->thumbnail);?>
						</a>
					<?endif;?>
				<?endwhile;?>
			</div>
		</div>
	<?endif;?>
<? endif; ?>
