<?
/**
 * @var \Pimcore\Templating\PhpEngine $this
 * @var \Pimcore\Templating\PhpEngine $view
 * @var \Pimcore\Templating\GlobalVariables $app
 */

if (!$this->cache($this->metaCacheKey)->start()) {
	if ($this->document instanceof \Pimcore\Model\Document\Page) {
		$this->headTitle()->setSeparator($this->document->getProperty('titleSeparator'));
		if (!(string) $this->headTitle()->getContainer()) {
			$this->headTitle()->set($this->document->getTitle());
		}
		$this->headTitle()->append($this->document->getProperty('titlePostfix'));
		$this->headMeta()->setName('viewport', 'width=device-width,initial-scale=1');
		$this->headMeta()->setHttpEquiv('Content-Type', 'text/html; charset=utf-8');
		$this->headMeta()->setHttpEquiv('x-ua-compatible', 'ie=edge');
		$this->headMeta()->setName('author', 'portadesign.cz');
		$metaMap = $this->headMeta()->getRaw();
		foreach ($this->headMeta()->getContainer() as $item) {
			$metaMap[] = sprintf('%s="%s"', $item->type, $item->{$item->type});
		}
		if (!in_array('name="description"', $metaMap) && $this->document->getDescription()) {
			$this->headMeta()->setName('description', $this->document->getDescription());
		}
		echo $this->headTitle();
		echo $this->headMeta();
	}
	$this->cache($this->metaCacheKey)->end();
}
