<?php

namespace AppBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\PasswordType;
use Symfony\Component\Form\Extension\Core\Type\RepeatedType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Validator\Constraints\NotBlank;

class PasswordChangeFormType extends AbstractType
{
	/**
	 * {@inheritdoc}
	 */
	public function buildForm(FormBuilderInterface $builder, array $options)
	{
		$builder
			->add('password_old', PasswordType::class, [
				'label' => 'label_password_old',
				'required' => true,
				'constraints' => [
					new NotBlank(['message' => 'msg_empty_field']),
				],
			])
			->add('password', RepeatedType::class, [
				'type' => PasswordType::class,
				'invalid_message' => 'msg_passwords_do_not_match',
				'required' => true,
				'first_options' => ['label' => 'label_password_new'],
				'second_options' => ['label' => 'label_password_new_again'],
				'constraints' => [
					new NotBlank(['message' => 'msg_empty_field']),
				],
			])
			->add('submit', SubmitType::class, [
				'label' => 'label_change',
			]);
	}
}
