<?php

namespace AppBundle\Model\Document;

use AppBundle\Tool\Utils;
use AppBundle\Model\IElasticObjectFulltext;
use Pimcore\Model\Document;

class Page extends Document\Page implements IElasticObjectFulltext
{
	use \AppBundle\Model\ElasticTrait;

	/**
	 * {@inheritdoc}
	 */
	public function save()
	{
		parent::save();

		if (Utils::elasticSearchEnabled()) {
			$this->elasticSearchUpdateFulltext();
		}
	}

	/**
	 * {@inheritdoc}
	 */
	public function delete(bool $isNested = false)
	{
		if (Utils::elasticSearchEnabled()) {
			$this->elasticSearchDeleteFulltext();
		}

		parent::delete($isNested);
	}

	/* 								For elastic search							*/

	/**
	 * @param string $lang
	 *
	 * @return array
	 */
	public function elasticSearchLoadFulltext($lang = null)
	{
		if (!$lang) {
			$lang = $this->getProperty('language');
			if (!$lang) {
				$lang = Utils::getDefaultLanguage();
			}
		}

		$data = array_merge($this->getElasticBaseData(), [
			'path' => Utils::docUrl($this->getRealFullPath(), $lang),
			'title' => $this->getTitle(),
			'description' => $this->getDescription(),
			'content' => ($this->getPublished())
				? $this->normalizeElasticText(Document\Service::render(
					$this,
					[
						'elastic_document_indexing' => true,
					],
					false // this does not work :( so we have to have a condition in layout
				))
				: '',
		]);

		return $data;
	}
}
