<?php

namespace AppBundle\Model;

use Pimcore\Model\DataObject\ClassDefinition\Data\Password;
use Pimcore\Model\DataObject\User as BaseUser;
use Symfony\Component\Security\Core\User\UserInterface;

/**
 * We have to implement Symfony's UserInterface to use our User class with an user provider.
 */
class User extends BaseUser implements UserInterface
{
	/**
	 * {@inheritdoc}
	 */
	public function getSalt()
	{
		// user has no salt as we use password_hash
		// which handles the salt by itself
		return null;
	}

	/**
	 * Use email as username.
	 *
	 * @return string
	 */
	public function getUsername()
	{
		return $this->getEmail();
	}

	/**
	 * Only one role for now.
	 *
	 * @return array
	 */
	public function getRoles()
	{
		return ['ROLE_USER'];
	}

	/**
	 * Trigger the hash calculation to remove the plain text password from the instance. This
	 * is necessary to make sure no plain text passwords are serialized.
	 *
	 * {@inheritdoc}
	 */
	public function eraseCredentials()
	{
		/* @var $field Password */
		$field = $this->getClass()->getFieldDefinition('password');
		$field->getDataForResource($this->getPassword(), $this);
	}

	/**
	 * used to render protected pages in editmode.
	 */
	public function mockForEditmode()
	{
		$this->setFirstName('John');
		$this->setLastName('Doe');
		$this->setEmail('john.doe@example.com');
		$this->setPhone(123456789);
		$this->setStreet('123 Main St');
		$this->setCity('Anytown');
		$this->setZipCode(01245);
	}
}
