#!/bin/bash
ES="http://localhost:9200"
INDICES=`curl -XGET ${ES}/_cat/indices -s --insecure | awk '{print $3}'`
META=`curl -XGET "${ES}/_cluster/state?filter_path=metadata.indices.*.aliases" -s --insecure`
#echo ${#META}
for INDEX in $INDICES
do
  if [[ ${INDEX} != \.* ]]
  then
    RES=`jq ".metadata.indices.${INDEX}.aliases" <<< ${META}`
    if [[ ${#RES} == 2 ]]
    then
      echo "Deleting ${INDEX}"
      curl -XDELETE ${ES}/${INDEX}
      echo ""
    fi
  fi
done
