<?php

namespace App\Command;

use App\Service\Generator;
use Pimcore\Console\AbstractCommand;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;

class GeneratorAreaDeleteCommand extends AbstractCommand
{
	protected function configure()
	{
		$this
			->setName('generator:area-delete')
			->setDescription('Deleate a pimcore area definition')
			->addArgument(
				'name',
				InputArgument::REQUIRED,
				'Area name in lowercase'
			);
	}

	protected function execute(InputInterface $input, OutputInterface $output)
	{
		$generator = new Generator();

		$name = strtolower($input->getArgument('name'));

		if ($generator->deleteArea($name)) {
			$output->writeln(sprintf('Area [%s] deleted', $name));
			return AbstractCommand::SUCCESS;
		} else {
			$output->writeln(sprintf(
				'<error>Area [%s] could not be deleted. See var/log/generator.log for details.</error>',
				$name
			));
			return AbstractCommand::FAILURE;
		}
	}
}
