<?php

$analysis = [
	'analyzer' => [
		'pathIndexAnalyzer' => [
			'type' => 'custom',
			'tokenizer' => 'pathIndexTokenizer',
		],
		'cs_hunspell' => [
			'type' => 'custom',
			'tokenizer' => 'standard',
			'filter' => ['lowercase', 'stopwords_CZ', 'cs_CZ', 'remove_duplicities'],
		],
		'sk_hunspell' => [
			'type' => 'custom',
			'tokenizer' => 'standard',
			'filter' => ['lowercase', 'stopwords_SK', 'sk_SK', 'remove_duplicities'],
		],
		'cs_icu_analyzer' => [
			'type' => 'custom',
			'tokenizer' => 'standard',
			'filter' => ['stopwords_CZ', 'icu_folding', 'remove_duplicities'],
		],
		'cs_icu_analyzer_sort' => [
			'type' => 'custom',
			'tokenizer' => 'keyword',
			'filter' => ['lowercase', 'cs_icu_collation'],
		],
		'sk_icu_analyzer' => [
			'type' => 'custom',
			'tokenizer' => 'standard',
			'filter' => ['stopwords_SK', 'icu_folding', 'remove_duplicities'],
		],
	],
	'filter' => [
		'stopwords_CZ' => [
			'type' => 'stop',
			'stopwords' => ['právě', 'že', '_czech_'],
			'ignore_case' => true,
		],
		'stopwords_SK' => [
			'type' => 'stop',
			'stopwords' => ['a', 'aby', 'aj', 'ako', 'ale', 'alebo', 'ani', 'áno', 'asi', 'až', 'bez', 'buď', 'by', 'cez', 'či', 'čo', 'ešte', 'ho', 'i', 'iba', 'ich', 'ja', 'je', 'jeho', 'jej', 'ju', 'k', 'kam', 'kde', 'keď', 'kto', 'ku', 'menej', 'mi', 'moja', 'moje', 'môj', 'my', 'nad', 'nám', 'než', 'nič', 'nie', 'o', 'od', 'on', 'on', 'ona', 'ona', 'oni', 'ono', 'po', 'pod', 'podľa', 'pokiaľ', 'potom', 'práve', 'prečo', 'pred', 'preto', 'pretože', 'pri', 's', 'sa', 'si', 'sme', 'so', 'som', 'späť', 'ste', 'sú', 'sú', 'ta', 'tá', 'tak', 'tak', 'takže', 'tam', 'tam', 'táto', 'teda', 'ten', 'tento', 'tieto', 'tiež', 'to', 'to', 'toho', 'tom', 'tomto', 'toto', 'tu', 'túto', 'ty', 'tým', 'týmto', 'už', 'v', 'vám', 'viac', 'vo', 'však', 'vy', 'z', 'za', 'zo'],
			'ignore_case' => true,
		],
		'cs_CZ' => [
			'type' => 'hunspell',
			'locale' => 'cs_CZ',
			'dedup' => true,
			'recursion_level' => 0,
		],
		'cs_icu_collation' => [
			'type' => 'icu_collation',
			'language' => 'cs',
		],
		'sk_SK' => [
			'type' => 'hunspell',
			'locale' => 'sk_SK',
			'dedup' => true,
			'recursion_level' => 0,
		],
		'remove_duplicities' => [
			'type' => 'unique',
			'only_on_same_position' => true,
		],
	],
	'tokenizer' => [
		'pathIndexTokenizer' => [
			'type' => 'path_hierarchy',
			'delimiter' => '/',
		],
	],
];

$baseMapping = [
	'id' => ['type' => 'integer'],
	'parentId' => ['type' => 'integer'],
	'key' => ['type' => 'keyword'],
	'type' => ['type' => 'keyword'],
	'published' => ['type' => 'boolean'],
];

return [
	'analysis' => $analysis,
	'default_mapping' => [
		'meta' => [
			'languages' => \Pimcore\Tool::getValidLanguages(),
		],
		'properties' => $baseMapping,
	],
	'fulltext_mapping' => [
		'meta' => [
			'languages' => \Pimcore\Tool::getValidLanguages(),
			'fulltextFields' => ['title', 'description', 'content'],
		],
		'properties' => array_merge($baseMapping, [
			'path' => ['type' => 'text'],
		]),
	],
	'news' => [
		'meta' => [
			'languages' => \Pimcore\Tool::getValidLanguages(),
			'fulltextFields' => ['name'],
		],
		'properties' => array_merge($baseMapping, [
			'url' => ['type' => 'keyword'],
		]),
	],
];
