<?php

namespace App\Twig\Extension;

use Twig\Extension\AbstractExtension;
use Twig\TwigFunction;
use App\Tool\Utils;

class LanguageSwitcherExtension extends AbstractExtension
{
	/**
	 * @return array|TwigFunction[]
	 */
	public function getFunctions()
	{
		return [
			new TwigFunction('get_language_switch', [$this, 'getLanguageSwitch']),
		];
	}

	/**
	 * Returns document language switcher.
	 *
	 * @param string $language
	 * @param string $section
	 * @param \Pimcore\Model\Document $rootDoc
	 * @param boolean $hpFallback
	 * @return array
	 */
	public function getLanguageSwitch($language, $section, $rootDoc = null, $hpFallback = false)
	{
		return Utils::getLanguageSwitch($language, $section, $rootDoc, $hpFallback);
	}
}
