<?php

namespace App\View\Helper;

use Pimcore\Model\Document\Page;
use Pimcore\Templating\Helper\TemplatingEngineAwareHelperInterface;
use Symfony\Component\Templating\Helper\Helper;

class IsActive extends Helper implements TemplatingEngineAwareHelperInterface
{
	use \Pimcore\Templating\Helper\Traits\TemplatingEngineAwareHelperTrait;

	/**
	 * {@inheritdoc}
	 */
	public function getName()
	{
		return 'isActive';
	}

	/**
	 * @param int $documentId
	 *
	 * @return bool true if documentId matched the ID of active document
	 */
	public function __invoke($documentId = null)
	{
		$isActive = false;

		if ($documentId) {
			$isActive = ($this->templatingEngine->document instanceof Page &&
				($this->templatingEngine->document->getId() == $documentId || $this->templatingEngine->document->getContentMasterDocumentId() == $documentId)
			);
		}

		return $isActive;
	}
}
