"use strict";
(self["webpackChunkporta_frontend_starter_kit"] = self["webpackChunkporta_frontend_starter_kit"] || []).push([["scripts"],{

/***/ "./assets/js/components/ajax.js":
/*!**************************************!*\
  !*** ./assets/js/components/ajax.js ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ajax": () => (/* binding */ ajax)
/* harmony export */ });
/* harmony import */ var jquery__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! jquery */ "./node_modules/jquery/dist/jquery.js");
/* harmony import */ var jquery__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(jquery__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _flash_messages__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./flash-messages */ "./assets/js/components/flash-messages.js");
/* harmony import */ var _forms__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./forms */ "./assets/js/components/forms.js");
/* harmony import */ var fancybox__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! fancybox */ "./node_modules/fancybox/dist/js/jquery.fancybox.cjs.js");
/* harmony import */ var fancybox__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(fancybox__WEBPACK_IMPORTED_MODULE_3__);



 //jqueryFancybox();

const ajax = () => {
  jquery__WEBPACK_IMPORTED_MODULE_0___default()(document).ready(function ($) {
    // ...
    $('body').on('click', 'a.ajax', function () {
      $(this).myAjax($(this).attr('data-to-inject'));
      return false;
    });
    $('body').on('submit', 'form.ajax', function () {
      $(this).myAjax($(this).attr('data-to-inject'));
      return false;
    });
  }); //send form or href click via ajax
  //on forms allows injection or change of values

  (jquery__WEBPACK_IMPORTED_MODULE_0___default().fn.myAjax) = function (toInject) {
    var url = null;
    var requestData = null;
    var form = null;

    if (this.prop('tagName').toLowerCase() == 'form') {
      form = this.closest('form');
      url = form.attr('action');

      if (typeof toInject === 'object') {
        for (var key in toInject) {
          //change a value if element exits
          if (jquery__WEBPACK_IMPORTED_MODULE_0___default()("input[name='" + key + "']", form).length > 0) {
            jquery__WEBPACK_IMPORTED_MODULE_0___default()("input[name='" + key + "']", form).val(toInject[key]);
          } else {
            //or insert a new one if it doesn't
            if (toInject.hasOwnProperty(key)) {
              jquery__WEBPACK_IMPORTED_MODULE_0___default()('<input>').attr({
                type: 'hidden',
                id: key,
                name: key,
                value: toInject[key]
              }).appendTo(form);
            }
          }
        }
      }

      requestData = form.serializeArray();

      if (form.prop('enctype') == 'multipart/form-data') {
        var formData = new FormData();

        for (var p in requestData) {
          formData.append(requestData[p].name, requestData[p].value);
        }

        jquery__WEBPACK_IMPORTED_MODULE_0___default()('input[type=file]').each(form), function (i, input) {
          if (input.files.length) {
            formData.append(input.name, input.files[0]);
          }
        };
        requestData = formData;
      }

      if (this.attr('data-persist-to-hash')) {
        disableHashChange = true; //add formId element with id value

        jquery__WEBPACK_IMPORTED_MODULE_0___default()('<input>').attr({
          type: 'hidden',
          name: 'formId',
          value: this.attr('id')
        }).appendTo(form);
        window.location.hash = '#' + jquery__WEBPACK_IMPORTED_MODULE_0___default().param(jquery__WEBPACK_IMPORTED_MODULE_0___default()('#' + this.attr('id')).values());
      }
    } else {
      url = this.attr('href');
      requestData = toInject;

      if (this.attr('data-persist-to-hash') && this.attr('id')) {
        disableHashChange = true;
        window.location.hash = '#' + this.attr('id');
      }
    }

    jquery__WEBPACK_IMPORTED_MODULE_0___default()('.loader-overlay').show();
    var ajaxOptions = {
      url: url ? url : window.location.href,
      type: form === null ? 'GET' : 'POST',
      data: requestData
    };

    if (form && form.prop('enctype') == 'multipart/form-data') {
      ajaxOptions.contentType = false;
      ajaxOptions.processData = false;
      ajaxOptions.cache = false;
    }

    var hideLoader = true;
    jquery__WEBPACK_IMPORTED_MODULE_0___default().ajax(ajaxOptions).done(function (responseData) {
      //handle snippets
      var popup = null;
      var evalScript = null;
      var index = null;

      if (typeof responseData !== 'object') {
        responseData = JSON.parse(responseData);
      }

      for (var key in responseData.snippets) {
        switch (responseData.snippets[key].type) {
          case 'element':
            {
              jquery__WEBPACK_IMPORTED_MODULE_0___default()(key).html(responseData.snippets[key].body);
            }
            break;

          case 'element-append':
            {
              jquery__WEBPACK_IMPORTED_MODULE_0___default()(key).append(responseData.snippets[key].body);
            }
            break;

          case 'popup':
            {
              popup = responseData.snippets[key].body;
            }
            break;

          case 'popup-close':
            {
              jquery__WEBPACK_IMPORTED_MODULE_0___default().fancybox.close();
            }
            break;

          case 'redirect':
            {
              document.location.href = responseData.snippets[key].body;
              hideLoader = false;
            }
            break;

          case 'redirect-ajax':
            {
              var url = responseData.snippets[key].body;
              var trigger = jquery__WEBPACK_IMPORTED_MODULE_0___default()('<a href="' + url + '" class="ajax"></a>').appendTo('body');
              trigger.click();
              trigger.remove();
              hideLoader = false;
            }
            break;

          case 'remove':
            {
              if (typeof responseData.snippets[key].body === 'object') {
                for (index in responseData.snippets[key].body) {
                  jquery__WEBPACK_IMPORTED_MODULE_0___default()(responseData.snippets[key].body[index]).remove();
                }
              } else {
                jquery__WEBPACK_IMPORTED_MODULE_0___default()(responseData.snippets[key].body).remove();
              }
            }
            break;

          case 'hide':
            {
              if (typeof responseData.snippets[key].body === 'object') {
                for (index in responseData.snippets[key].body) {
                  jquery__WEBPACK_IMPORTED_MODULE_0___default()(responseData.snippets[key].body[index]).hide();
                }
              } else {
                jquery__WEBPACK_IMPORTED_MODULE_0___default()(responseData.snippets[key].body).hide();
              }
            }
            break;

          case 'show':
            {
              if (typeof responseData.snippets[key].body === 'object') {
                for (index in responseData.snippets[key].body) {
                  jquery__WEBPACK_IMPORTED_MODULE_0___default()(responseData.snippets[key].body[index]).show();
                }
              } else {
                jquery__WEBPACK_IMPORTED_MODULE_0___default()(responseData.snippets[key].body).show();
              }
            }
            break;

          case 'populate':
            {
              if (jquery__WEBPACK_IMPORTED_MODULE_0___default()(key).length && jquery__WEBPACK_IMPORTED_MODULE_0___default()(key).is('form')) {
                jquery__WEBPACK_IMPORTED_MODULE_0___default()(key).values(responseData.snippets[key].body.data, responseData.snippets[key].body.prefix);

                if (jquery__WEBPACK_IMPORTED_MODULE_0___default()(key).attr('data-js-validation')) {
                  jquery__WEBPACK_IMPORTED_MODULE_0___default()(key).valid();
                }
              }
            }
            break;

          case 'eval':
            {
              evalScript = responseData.snippets[key].body;
            }
            break;
        } //reload on null snippet
        //if (responseData[key] == null) window.location.reload();

      } //check if there was a popup


      if (popup !== null) {
        jquery__WEBPACK_IMPORTED_MODULE_0___default()('.loader-overlay').hide();

        if ((jquery__WEBPACK_IMPORTED_MODULE_0___default().fn.fancybox)) {
          jquery__WEBPACK_IMPORTED_MODULE_0___default().fancybox.open(popup, defaultFancyboxConfig);
        }
      } //check if there was an eval


      if (evalScript !== null) {
        eval(evalScript);
      }
    }).fail(function () {
      alert('That is an error.');
    }).always(function () {
      afterAjax();

      if (hideLoader) {
        jquery__WEBPACK_IMPORTED_MODULE_0___default()('.loader-overlay').hide();
      }
    });
  };

  function afterAjax() {
    (0,_forms__WEBPACK_IMPORTED_MODULE_2__.initJsValidation)(); // Stejná výška elementů

    jquery__WEBPACK_IMPORTED_MODULE_0___default()(window).resize(); // Close FM

    (0,_flash_messages__WEBPACK_IMPORTED_MODULE_1__.initFlashMessages)();
  }
};



/***/ }),

/***/ "./assets/js/components/flash-messages.js":
/*!************************************************!*\
  !*** ./assets/js/components/flash-messages.js ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "initFlashMessages": () => (/* binding */ initFlashMessages)
/* harmony export */ });
const initFlashMessages = () => {
  Array.from(document.querySelectorAll('.flash-message__close')).forEach((closeBtn, i) => {
    closeBtn.addEventListener('click', () => {
      const fm = closeBtn.closest('.flash-message');
      fm.classList.add('flash-message--hidden');
    });
  });
  const flashMessages = document.querySelectorAll('.flash-message');

  if (flashMessages.length) {
    setTimeout(() => {
      Array.from(flashMessages).forEach((fm, i) => {
        if (fm.getAttribute('data-hide')) {
          fm.classList.add('flash-message--hidden');
        }
      });
    }, 5000);
  }
};



/***/ }),

/***/ "./assets/js/components/forms.js":
/*!***************************************!*\
  !*** ./assets/js/components/forms.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "forms": () => (/* binding */ forms),
/* harmony export */   "initJsValidation": () => (/* binding */ initJsValidation)
/* harmony export */ });
/* harmony import */ var jquery__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! jquery */ "./node_modules/jquery/dist/jquery.js");
/* harmony import */ var jquery__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(jquery__WEBPACK_IMPORTED_MODULE_0__);


const forms = () => {
  jquery__WEBPACK_IMPORTED_MODULE_0___default()(document).ready(function ($) {
    //js validation
    initJsValidation(); // auto-populate

    $('form[data-populate]').each(function () {
      $(this).values();
    });
  }); //submit form via JS, allows injection or change of values

  (jquery__WEBPACK_IMPORTED_MODULE_0___default().fn.submitForm) = function (toInject) {
    if (typeof toInject === 'object') {
      for (var key in toInject) {
        //change a value if element exits
        if (jquery__WEBPACK_IMPORTED_MODULE_0___default()("input[name='" + key + "']", this).length > 0) {
          jquery__WEBPACK_IMPORTED_MODULE_0___default()("input[name='" + key + "']", this).val(toInject[key]);
        } else {
          //or insert a new one if it doesn't
          if (toInject.hasOwnProperty(key)) {
            jquery__WEBPACK_IMPORTED_MODULE_0___default()('<input>').attr({
              type: 'hidden',
              id: key,
              name: key,
              value: toInject[key]
            }).appendTo(this);
          }
        }
      }
    }

    jquery__WEBPACK_IMPORTED_MODULE_0___default()(this).submit();
  };
  /* jQuery.values: get or set all of the name/value pairs from child input controls
  * @argument data {array} If included, will populate all child controls.
  * @argument inputPrefix {string} If included, will prefix all inputs and uppercase the first char
  * @returns element if data was provided, or array of values if not
  */


  (jquery__WEBPACK_IMPORTED_MODULE_0___default().fn.values) = function (data, inputPrefix) {
    var els = jquery__WEBPACK_IMPORTED_MODULE_0___default()(this).find(':input').get(); //if data and inputPrefix are not passed we try to read them from the data-populate and data-populate-prefix attributes

    if (typeof data != 'undefined') {
      if (typeof data != 'object') {
        data = JSON.parse(data);
      }
    } else {
      var dataAttr = jquery__WEBPACK_IMPORTED_MODULE_0___default()(this).attr('data-populate');

      if (typeof dataAttr != "undefined") {
        data = JSON.parse(dataAttr);

        if (typeof data != 'object') {
          data = JSON.parse(data);
        }
      }
    }

    if (typeof inputPrefix == 'undefined') {
      inputPrefix = jquery__WEBPACK_IMPORTED_MODULE_0___default()(this).attr('data-populate-prefix');
    }

    if (typeof data == 'undefined') {
      // return all data
      data = {};
      jquery__WEBPACK_IMPORTED_MODULE_0___default().each(els, function () {
        //var inputName = (typeof inputPrefix == 'string') ? (inputPrefix + this.name.charAt(0).toUpperCase() + this.name.slice(1)) : this.name;
        var multiCheckbox = this.type == 'checkbox' && this.name.indexOf("[]") > -1;

        if (this.name && !this.disabled && (this.checked || /select|textarea/i.test(this.nodeName) || /text|hidden|password/i.test(this.type))) {
          if (multiCheckbox) {
            if (data[this.name] === undefined) data[this.name] = [];
            data[this.name].push(jquery__WEBPACK_IMPORTED_MODULE_0___default()(this).val());
          } else {
            data[this.name] = jquery__WEBPACK_IMPORTED_MODULE_0___default()(this).val();
          }
        }
      });
      return data;
    } else {
      jquery__WEBPACK_IMPORTED_MODULE_0___default().each(els, function () {
        var key = this.name;
        var isMultiCheckbox = this.type == 'checkbox' && key.indexOf("[]") > -1;

        if (isMultiCheckbox) {
          key = key.replace("[]", '');
        }

        if (typeof inputPrefix == 'string') {
          key = key.replace(inputPrefix, '');
          key = key.charAt(0).toLowerCase() + key.slice(1);
        }

        if (this.name && data[key]) {
          if (isMultiCheckbox) {
            jquery__WEBPACK_IMPORTED_MODULE_0___default()(this).attr("checked", jquery__WEBPACK_IMPORTED_MODULE_0___default().inArray(jquery__WEBPACK_IMPORTED_MODULE_0___default()(this).val(), data[key]) >= 0);
          } else if (this.type == 'checkbox' || this.type == 'radio') {
            jquery__WEBPACK_IMPORTED_MODULE_0___default()(this).attr("checked", data[key] == jquery__WEBPACK_IMPORTED_MODULE_0___default()(this).val());
          } else {
            jquery__WEBPACK_IMPORTED_MODULE_0___default()(this).val(data[key]);
          }
        }
      });
      return jquery__WEBPACK_IMPORTED_MODULE_0___default()(this);
    }
  };
  /*
  jQuery deparam is an extraction of the deparam method from Ben Alman's jQuery BBQ
  http://benalman.com/projects/jquery-bbq-plugin/
  */


  (function ($) {
    $.deparam = function (params, coerce) {
      var obj = {},
          coerce_types = {
        'true': !0,
        'false': !1,
        'null': null
      }; // Iterate over all name=value pairs.

      $.each(params.replace(/\+/g, ' ').split('&'), function (j, v) {
        var param = v.split('='),
            key = decodeURIComponent(param[0]),
            val,
            cur = obj,
            i = 0,
            // If key is more complex than 'foo', like 'a[]' or 'a[b][c]', split it
        // into its component parts.
        keys = key.split(']['),
            keys_last = keys.length - 1; // If the first keys part contains [ and the last ends with ], then []
        // are correctly balanced.

        if (/\[/.test(keys[0]) && /\]$/.test(keys[keys_last])) {
          // Remove the trailing ] from the last keys part.
          keys[keys_last] = keys[keys_last].replace(/\]$/, ''); // Split first keys part into two parts on the [ and add them back onto
          // the beginning of the keys array.

          keys = keys.shift().split('[').concat(keys);
          keys_last = keys.length - 1;
        } else {
          // Basic 'foo' style key.
          keys_last = 0;
        } // Are we dealing with a name=value pair, or just a name?


        if (param.length === 2) {
          val = decodeURIComponent(param[1]); // Coerce values.

          if (coerce) {
            val = val && !isNaN(val) ? +val // number
            : val === 'undefined' ? undefined // undefined
            : coerce_types[val] !== undefined ? coerce_types[val] // true, false, null
            : val; // string
          }

          if (keys_last) {
            // Complex key, build deep object structure based on a few rules:
            // * The 'cur' pointer starts at the object top-level.
            // * [] = array push (n is set to array length), [n] = array if n is
            //   numeric, otherwise object.
            // * If at the last keys part, set the value.
            // * For each keys part, if the current level is undefined create an
            //   object or array based on the type of the next keys part.
            // * Move the 'cur' pointer to the next level.
            // * Rinse & repeat.
            for (; i <= keys_last; i++) {
              key = keys[i] === '' ? cur.length : keys[i];
              cur = cur[key] = i < keys_last ? cur[key] || (keys[i + 1] && isNaN(keys[i + 1]) ? {} : []) : val;
            }
          } else {
            // Simple key, even simpler rules, since only scalars and shallow
            // arrays are allowed.
            if ($.isArray(obj[key])) {
              // val is already an array, so push on the next value.
              obj[key].push(val);
            } else if (obj[key] !== undefined) {
              // val isn't an array, but since a second value has been specified,
              // convert val into an array.
              obj[key] = [obj[key], val];
            } else {
              // val is a scalar.
              obj[key] = val;
            }
          }
        } else if (key) {
          // No value was defined, so set something meaningful.
          obj[key] = coerce ? undefined : '';
        }
      });
      return obj;
    };
  });
}; //initializes validate.js rules from Zend backend validation rules in data attributes


const initJsValidation = () => {
  jquery__WEBPACK_IMPORTED_MODULE_0___default()('form').each(function () {
    if (jquery__WEBPACK_IMPORTED_MODULE_0___default()(this).attr('data-validation-initialized')) return;

    if (jquery__WEBPACK_IMPORTED_MODULE_0___default()(this).attr('data-js-validation')) {
      var messages = {};
      var errorWrapperSelector = jquery__WEBPACK_IMPORTED_MODULE_0___default()(this).attr('data-error-wrapper-selector');
      var errorWrapperClass = jquery__WEBPACK_IMPORTED_MODULE_0___default()(this).attr('data-error-wrapper-class');
      var errorClassOnElement = jquery__WEBPACK_IMPORTED_MODULE_0___default()(this).attr('data-error-class-on-element');
      jquery__WEBPACK_IMPORTED_MODULE_0___default()('input[data-error-messages], textarea[data-error-messages], checkbox[data-error-messages], select[data-error-messages]', this).each(function () {
        messages[jquery__WEBPACK_IMPORTED_MODULE_0___default()(this).attr('name')] = JSON.parse(jquery__WEBPACK_IMPORTED_MODULE_0___default()(this).attr('data-error-messages'));
      }); //additional rules

      var rules = {};
      jquery__WEBPACK_IMPORTED_MODULE_0___default()('*', this).filter(':input').each(function () {
        var i = 0;
        if (!jquery__WEBPACK_IMPORTED_MODULE_0___default()(this).attr('id')) return;
        var depends = jquery__WEBPACK_IMPORTED_MODULE_0___default()(this).attr('depends');
        if (depends !== undefined) depends = JSON.parse(depends);else return;
        var dependentValSelectors = [];
        if (!Array.isArray(depends.key)) depends.key = [depends.key];

        for (i in depends.key) {
          var key = depends.key[i];
          var dependentElement = jquery__WEBPACK_IMPORTED_MODULE_0___default()('*[name="' + key + '"]');
          var dependentValSelector = dependentElement.attr('type') == 'radio' ? 'input[name="' + key + '"]:checked' : '#' + key;
          dependentValSelectors.push(dependentValSelector);
        }

        var elementId = jquery__WEBPACK_IMPORTED_MODULE_0___default()(this).attr('id');
        rules[elementId] = {
          required: {
            depends: function () {
              for (i in dependentValSelectors) {
                if (jquery__WEBPACK_IMPORTED_MODULE_0___default()(dependentValSelectors[i]).val() == depends.value) return true;
              }

              return false;
            }
          }
        };

        if (depends.hasOwnProperty('additionalValidators')) {
          for (i in depends.additionalValidators) {
            rules[elementId][i] = depends.additionalValidators[i];
          }
        }
      });
      jquery__WEBPACK_IMPORTED_MODULE_0___default()(this).validate({
        'errorClass': jquery__WEBPACK_IMPORTED_MODULE_0___default()(this).attr('data-error-class'),
        'errorElement': jquery__WEBPACK_IMPORTED_MODULE_0___default()(this).attr('data-error-element'),
        errorPlacement: function (error, element) {
          jquery__WEBPACK_IMPORTED_MODULE_0___default()('.error-placement-wrapper[data-element-id=' + element.attr('id') + ']').html(error);
        },
        highlight: function (element) {
          if (errorWrapperSelector && errorWrapperClass) {
            jquery__WEBPACK_IMPORTED_MODULE_0___default()(element).closest(errorWrapperSelector).addClass(errorWrapperClass);
          }

          if (errorClassOnElement) {
            jquery__WEBPACK_IMPORTED_MODULE_0___default()(element).addClass(errorClassOnElement);
          }
        },
        unhighlight: function (element) {
          if (errorWrapperSelector && errorWrapperClass) {
            jquery__WEBPACK_IMPORTED_MODULE_0___default()(element).closest(errorWrapperSelector).removeClass(errorWrapperClass);
          }

          jquery__WEBPACK_IMPORTED_MODULE_0___default()('.error-placement-wrapper[data-element-id=' + element.id + ']').empty();

          if (errorClassOnElement) {
            jquery__WEBPACK_IMPORTED_MODULE_0___default()(element).removeClass(errorClassOnElement);
          }
        },
        'messages': messages,
        rules: rules,
        submitHandler: function (form) {
          //prevent multiple form submissions
          if (!jquery__WEBPACK_IMPORTED_MODULE_0___default()(form).attr('data-form-submitted') || jquery__WEBPACK_IMPORTED_MODULE_0___default()(this).attr('data-allow-multiple-submissions')) {
            jquery__WEBPACK_IMPORTED_MODULE_0___default()(form).attr('data-form-submitted', '1');

            if (jquery__WEBPACK_IMPORTED_MODULE_0___default()(form).hasClass('ajax')) {
              jquery__WEBPACK_IMPORTED_MODULE_0___default()(form).myAjax(jquery__WEBPACK_IMPORTED_MODULE_0___default()(form).attr('data-to-inject'));
            } else {
              form.submit();
            }
          }
        }
      });
      jquery__WEBPACK_IMPORTED_MODULE_0___default()(this).attr('data-validation-initialized', '1');
    } else {
      //prevent multiple form submissions on no-js-validated forms
      if (!jquery__WEBPACK_IMPORTED_MODULE_0___default()(this).hasClass('ajax') && !jquery__WEBPACK_IMPORTED_MODULE_0___default()(this).attr('data-allow-multiple-submissions')) {
        jquery__WEBPACK_IMPORTED_MODULE_0___default()(this).on('submit', function () {
          if (!jquery__WEBPACK_IMPORTED_MODULE_0___default()(this).attr('data-form-submitted')) {
            jquery__WEBPACK_IMPORTED_MODULE_0___default()(this).attr('data-form-submitted', '1');
            jquery__WEBPACK_IMPORTED_MODULE_0___default()(this).submit();
            return true;
          } else {
            return false;
          }
        });
      }
    }
  });
};



/***/ }),

/***/ "./assets/js/components/togglers.js":
/*!******************************************!*\
  !*** ./assets/js/components/togglers.js ***!
  \******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "initTogglers": () => (/* binding */ initTogglers),
/* harmony export */   "togglers": () => (/* binding */ togglers)
/* harmony export */ });
/* harmony import */ var jquery__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! jquery */ "./node_modules/jquery/dist/jquery.js");
/* harmony import */ var jquery__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(jquery__WEBPACK_IMPORTED_MODULE_0__);


const initTogglers = () => {
  togglers();
  jquery__WEBPACK_IMPORTED_MODULE_0___default()('.sh-trig').toggler();
};

const togglers = () => {
  function scrollToContent() {
    var offset = 0;

    if (settings.offsetScroll) {
      offset = settings.offsetScroll;
    }

    jquery__WEBPACK_IMPORTED_MODULE_0___default()("html:not(:animated),body:not(:animated)").animate({
      scrollTop: jquery__WEBPACK_IMPORTED_MODULE_0___default()(content).offset().top + offset
    }, 500, function () {//window.location.hash = content.attr('id');
    });
  }

  function scrollToTrigger() {
    var offset = 0;

    if (settings.offsetScroll) {
      offset = settings.offsetScroll + 200;
    }

    jquery__WEBPACK_IMPORTED_MODULE_0___default()("html:not(:animated),body:not(:animated)").animate({
      scrollTop: jquery__WEBPACK_IMPORTED_MODULE_0___default()('[data-content=' + trigger.attr('data-content') + ']').offset().top + offset
    }, 500, function () {//window.location.hash = content.attr('id');
    });
  }

  (jquery__WEBPACK_IMPORTED_MODULE_0___default().fn.toggler) = function (settings) {
    settings = jquery__WEBPACK_IMPORTED_MODULE_0___default().extend({
      showSpeed: 100,
      hideSpeed: 100,
      hideTrigger: false,
      slide: false,
      scrollToContent: false,
      offsetScroll: 0,
      hideOnDocumentClick: false,
      documentClickElement: '',
      hideOnEscape: false,
      checkboxReverse: false
    }, settings);
    jquery__WEBPACK_IMPORTED_MODULE_0___default()(this).each(function () {
      var trigger = jquery__WEBPACK_IMPORTED_MODULE_0___default()(this),
          content = jquery__WEBPACK_IMPORTED_MODULE_0___default()('#' + trigger.data('content'));
      trigger.on('click', function () {
        if (content.is(':hidden')) {
          if (settings.slide) {
            content.slideDown(settings.showSpeed, function () {
              if (settings.scrollToContent) {
                scrollToContent();
              }
            });
          } else {
            content.fadeIn(settings.showSpeed, function () {
              if (settings.scrollToContent) {
                scrollToContent();
              }
            });
          }

          jquery__WEBPACK_IMPORTED_MODULE_0___default()(this).addClass('active').find('.text').text(jquery__WEBPACK_IMPORTED_MODULE_0___default()(this).attr('data-less'));

          if (settings.hideTrigger) {
            trigger.hide();
          }
        } else {
          if (settings.slide) {
            content.slideUp(settings.hideSpeed, function () {
              if (settings.scrollToContent) {
                scrollToTrigger();
              }
            });
          } else {
            content.fadeOut(settings.hideSpeed, function () {
              if (settings.scrollToContent) {
                scrollToTrigger();
              }
            });
          }

          jquery__WEBPACK_IMPORTED_MODULE_0___default()(this).removeClass('active').find('.text').text(jquery__WEBPACK_IMPORTED_MODULE_0___default()(this).attr('data-more'));

          if (settings.hideTrigger) {
            jquery__WEBPACK_IMPORTED_MODULE_0___default()('[data-content=' + trigger.attr('data-content') + ']').fadeIn(settings.hideSpeed);
          }
        }

        return false;
      }); // Hide on document click

      if (settings.hideOnDocumentClick) {
        jquery__WEBPACK_IMPORTED_MODULE_0___default()(document).bind('click', function (e) {
          if (!jquery__WEBPACK_IMPORTED_MODULE_0___default()(settings.documentClickElement).is(e.target) && jquery__WEBPACK_IMPORTED_MODULE_0___default()(settings.documentClickElement).has(e.target).length === 0) {
            content.fadeOut();
          }
        });
      } // Escape button


      if (settings.hideOnEscape) {
        jquery__WEBPACK_IMPORTED_MODULE_0___default()(document).keyup(function (e) {
          if (e.keyCode === 27) {
            content.fadeOut();
          }
        });
      }
    });
  };
};



/***/ }),

/***/ "./assets/js/scripts.js":
/*!******************************!*\
  !*** ./assets/js/scripts.js ***!
  \******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var jquery__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! jquery */ "./node_modules/jquery/dist/jquery.js");
/* harmony import */ var jquery__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(jquery__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _components_ajax__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./components/ajax */ "./assets/js/components/ajax.js");
/* harmony import */ var _components_flash_messages__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./components/flash-messages */ "./assets/js/components/flash-messages.js");
/* harmony import */ var _components_forms__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./components/forms */ "./assets/js/components/forms.js");
/* harmony import */ var _components_togglers__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./components/togglers */ "./assets/js/components/togglers.js");





(0,_components_ajax__WEBPACK_IMPORTED_MODULE_1__.ajax)();
(0,_components_forms__WEBPACK_IMPORTED_MODULE_3__.forms)();
jquery__WEBPACK_IMPORTED_MODULE_0___default()(() => {
  (0,_components_togglers__WEBPACK_IMPORTED_MODULE_4__.initTogglers)();
  (0,_components_flash_messages__WEBPACK_IMPORTED_MODULE_2__.initFlashMessages)();
});

/***/ })

},
/******/ __webpack_require__ => { // webpackRuntimeModules
/******/ var __webpack_exec__ = (moduleId) => (__webpack_require__(__webpack_require__.s = moduleId))
/******/ __webpack_require__.O(0, ["vendors-node_modules_fancybox_dist_js_jquery_fancybox_cjs_js-node_modules_jquery_dist_jquery_js"], () => (__webpack_exec__("./assets/js/scripts.js")));
/******/ var __webpack_exports__ = __webpack_require__.O();
/******/ }
]);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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