<?php

namespace App\Controller;

use App\Form\NewsletterFormType;
use App\Service\NewsletterManager;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Form\FormInterface;

class NewsletterController extends BaseController
{
	/*						DOCUMENT ROUTED ACTIONS							*/

	/*				VIEW-LESS ACTIONS (ALWAYS REDIRECT)					*/

	/**
	 * @param Request $request
	 * @param NewsletterManager $newsletterManager
	 *
	 * @return Response
	 */
	public function newsletterSubscribeAction(Request $request, NewsletterManager $newsletterManager)
	{
		$this->newsletterForm->handleRequest($request);
		if ($this->newsletterForm->isSubmitted()) {
			if ($this->handleNewsletterForm($this->newsletterForm, $newsletterManager, true)) {
				$this->newsletterForm = $this->createForm(NewsletterFormType::class);

				$this->ajaxResponseBuilder->addElement('#newsletter', 'snippet/newsletter.html.twig', [
					'newsletterSent' => true,
					'newsletterForm' => $this->newsletterForm->createView()
				]);
			}
		}
		return $this->ajaxResponseBuilder->addFlashMessages()->getResponse();
	}

	/**
	 * @param Request $request
	 * @param NewsletterManager $newsletterManager
	 *
	 * @return Response
	 */
	public function newsletterConfirmAction(NewsletterManager $newsletterManager, $code)
	{
		if ($email = $newsletterManager->confirm($code)) {
			$this->addSuccessMsg(sprintf($this->translate('msg_newsletter_subscribed'), $email));
		} elseif (false === $email) {
			$this->addInfoMsg($this->translate('msg_newsletter_code_invalid'));
		} else {
			$this->addErrorMsg($this->translate('msg_unknown_error'));
		}
		return $this->gotoUrl($this->getPreviousUrl());
	}

	/**
	 * @param NewsletterManager $newsletterManager
	 * @param string $code
	 *
	 * @return Response
	 */
	public function newsletterUnsubscribeAction(NewsletterManager $newsletterManager, $code)
	{
		if ($email  = $newsletterManager->unsubscribe($code)) {
			$this->addSuccessMsg(sprintf($this->translate('msg_newsletter_unsubscribed'), $email));
		} elseif (false === $email) {
			$this->addInfoMsg($this->translate('msg_newsletter_code_invalid'));
		} else {
			$this->addErrorMsg($this->translate('msg_unknown_error'));
		}
		return $this->gotoUrl($this->getPreviousUrl());
	}

	/*							FORM HANDLERS								*/

	/**
	 * @param FormInterface $form
	 * @param NewsletterManager $newsletterManager
	 *
	 * @return bool
	 */
	protected function handleNewsletterForm(FormInterface $form, NewsletterManager $newsletterManager, $flashForCurrentRequest = false)
	{
		if (!$form->isValid()) {
			$this->addErrorMsg($this->translate('msg_form_invalid'), $flashForCurrentRequest);
			return false;
		}
		$data = $form->getData();
		// antispam hidden field, should be empty
		if (!empty($data['fullName'])) {
			$this->addErrorMsg($this->translate('msg_unknown_error'), $flashForCurrentRequest);
			return false;
		}
		$data['lang'] = $this->language;
		if ($result = $newsletterManager->subscribe($data)) {
			$this->addSuccessMsg(sprintf($this->translate('msg_newsletter_registered'), $data['email']), $flashForCurrentRequest);
		} else {
			$this->addErrorMsg($this->translate('msg_unknown_error'), $flashForCurrentRequest);
		}
		return $result;
	}
}
