<?php

namespace App\EventListener;

use Pimcore\Event\BundleManager\PathsEvent;
use Pimcore\Event\BundleManagerEvents;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

class AdminAssetsListener implements EventSubscriberInterface
{
	public static function getSubscribedEvents()
	{
		return [
			BundleManagerEvents::JS_PATHS => 'onJsPaths',
			BundleManagerEvents::CSS_PATHS => 'onCssPaths',
			BundleManagerEvents::EDITMODE_JS_PATHS => 'onEditmodeJsPaths',
			BundleManagerEvents::EDITMODE_CSS_PATHS => 'onEditmodeCssPaths'
		];
	}

	public function onJsPaths(PathsEvent $event)
	{
		$event->setPaths(array_merge($event->getPaths(), [
			'/admin/js/backend.js',
		]));
	}

	public function onCssPaths(PathsEvent $event)
	{
		$event->setPaths(array_merge($event->getPaths(), [
			'/admin/css/backend.css',
		]));
	}

	public function onEditmodeJsPaths(PathsEvent $event)
	{
		$event->setPaths(array_merge($event->getPaths(), [
			'/admin/js/plugins/anchor/plugin.min.js',
			'/admin/js/plugins/charmap/plugin.min.js',
			'/admin/js/plugins/code/plugin.min.js',
			'/admin/js/plugins/image/plugin.min.js',
			'/admin/js/plugins/lists/plugin.min.js',
			'/admin/js/plugins/media/plugin.min.js',
			'/admin/js/plugins/table/plugin.min.js',
			'/admin/js/tinymce_config.js',
			'/admin/js/document_editmode.js',
		]));
	}

	public function onEditmodeCssPaths(PathsEvent $event)
	{
		$event->setPaths(array_merge($event->getPaths(), [
		]));
	}
}
