<?php

namespace App\EventListener;

use Pimcore\Bundle\GoogleMarketingBundle\Event\GoogleAnalyticsEvents;
use Pimcore\Bundle\GoogleMarketingBundle\Event\GoogleTagManagerEvents;
use Pimcore\Bundle\GoogleMarketingBundle\Model\Event\TagManager\CodeEvent;
use Pimcore\Bundle\GoogleMarketingBundle\Model\Event\TrackingDataEvent;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

class GoogleTrackingCodeListener implements EventSubscriberInterface
{
	/**
	 * {@inheritdoc}
	 */
	public static function getSubscribedEvents()
	{
		return [
			GoogleAnalyticsEvents::CODE_TRACKING_DATA => 'onGATrackingData',
			GoogleTagManagerEvents::CODE_HEAD => 'onGTMHead',
			GoogleTagManagerEvents::CODE_BODY => 'onGTMBody',
		];
	}

	/**
	 * @param TrackingDataEvent $event
	 */
	public function onGATrackingData(TrackingDataEvent $event)
	{
		$event->setTemplate('snippet/marketing/ga.html.twig');
	}

	/**
	 * @param TrackingDataEvent $event
	 */
	public function onGTMHead(CodeEvent $event)
	{
		$event->setTemplate('snippet/marketing/gtmHead.html.twig');
	}

	/**
	 * @param TrackingDataEvent $event
	 */
	public function onGTMBody(CodeEvent $event)
	{
		$event->setTemplate('snippet/marketing/gtmBody.html.twig');
	}
}
