<?php

namespace App\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\EmailType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Validator\Constraints\NotBlank;
use Symfony\Component\Validator\Constraints\Email;

class PasswordResetFormType extends AbstractType
{
	/**
	 * {@inheritdoc}
	 */
	public function buildForm(FormBuilderInterface $builder, array $options)
	{
		$builder
			->add('email', EmailType::class, [
				'label' => 'label_email',
				'required' => true,
				'constraints' => [
					new NotBlank(['message' => 'msg_empty_field']),
					new Email(['message' => 'msg_invalid_email']),
				],
			])
			->add('submit', SubmitType::class, [
				'label' => 'label_reset_password',
			]);
	}
}
