<?php

namespace App\Command;

use App\Service\Generator;
use Pimcore\Console\AbstractCommand;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;

class GeneratorDocumentEmailCreateCommand extends AbstractCommand
{
	protected function configure()
	{
		$this
			->setName('generator:document-email-create')
			->setDescription('Create a pimcore e-mail document template')
			->addArgument(
				'subject',
				InputArgument::REQUIRED,
				'E-mail subject (will also be used as document key)'
			)
			->addOption(
				'parent', 'p',
				InputOption::VALUE_REQUIRED,
				'Parent document real full path or ID'
			);
	}

	protected function execute(InputInterface $input, OutputInterface $output)
	{
		$generator = new Generator();

		$subject = ucfirst($input->getArgument('subject'));
		$parent = $input->getOption('parent');

		$email = $generator->createDocumentEmail($subject, $parent);

		if ($email) {
			$output->writeln(sprintf('E-mail [%s] created with ID [%d]',
				$email->getRealFullPath(),
				$email->getId()
			));
			return AbstractCommand::SUCCESS;
		} else {
			$output->writeln('<error>Document e-mail could not be created. See var/log/generator.log for details.</error>');
			return AbstractCommand::FAILURE;
		}
	}
}
