<?php

namespace App\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\Extension\Core\Type\EmailType;
use Symfony\Component\Form\Extension\Core\Type\PasswordType;
use Symfony\Component\Form\Extension\Core\Type\RepeatedType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Validator\Constraints\NotBlank;
use Symfony\Component\Validator\Constraints\Email;
use Symfony\Component\Validator\Constraints\Regex;

class RegistrationFormType extends AbstractType
{
	/**
	 * {@inheritdoc}
	 */
	public function buildForm(FormBuilderInterface $builder, array $options)
	{
		if (false === $options['forProfile']) {
			$builder
				->add('email', EmailType::class, [
					'label' => 'label_email',
					'required' => true,
					'constraints' => [
						new NotBlank(['message' => 'msg_empty_field']),
						new Email(['message' => 'msg_invalid_email']),
					],
				])
				->add('password', RepeatedType::class, [
					'type' => PasswordType::class,
					'invalid_message' => 'msg_passwords_do_not_match',
					'required' => true,
					'first_options' => ['label' => 'label_password'],
					'second_options' => ['label' => 'label_password_again'],
					'constraints' => [
						new NotBlank(['message' => 'msg_empty_field']),
					],
				])
				->add('newsletter', CheckboxType::class, [
					'label' => 'label_send_me_newsletter',
					'required' => false,
				])
				->add('agreed', CheckboxType::class, [
					'label' => 'label_agree_with_terms',
					'required' => true,
					'constraints' => [
						new NotBlank(['message' => 'msg_agree_with_terms']),
					],
				]);
		}

		$builder
			->add('firstName', TextType::class, [
				'label' => 'label_first_name',
				'required' => true,
				'constraints' => [
					new NotBlank(['message' => 'msg_empty_field']),
				],
			])
			->add('lastName', TextType::class, [
				'label' => 'label_last_name',
				'required' => true,
				'constraints' => [
					new NotBlank(['message' => 'msg_empty_field']),
				],
			])
			->add('phone', TextType::class, [
				'label' => 'label_phone',
				'required' => true,
				'constraints' => [
					new NotBlank(['message' => 'msg_empty_field']),
					new Regex([
						'pattern' => '/^(\+420|\+421|00420|00421)?[ ]*[0-9]{3}[ ]*[0-9]{3}[ ]*[0-9]{3}$/',
						'message' => 'msg_bad_format_phone',
					]),
				],
			])
			->add('street', TextType::class, [
				'label' => 'label_street',
				'required' => true,
				'constraints' => [
					new NotBlank(['message' => 'msg_empty_field']),
				],
			])
			->add('city', TextType::class, [
				'label' => 'label_city',
				'required' => true,
				'constraints' => [
					new NotBlank(['message' => 'msg_empty_field']),
				],
			])
			->add('zipCode', TextType::class, [
				'label' => 'label_zip_code',
				'required' => true,
				'constraints' => [
					new NotBlank(['message' => 'msg_empty_field']),
					new Regex([
						'pattern' => '/^[0-9]{3} ?[0-9]{2}$/',
						'message' => 'msg_bad_format',
					]),
				],
			])
			->add('company', TextType::class, [
				'label' => 'label_company',
				'required' => false,
			])
			->add('ic', TextType::class, [
				'label' => 'label_ic',
				'required' => false,
			])
			->add('dic', TextType::class, [
				'label' => 'label_dic',
				'required' => false,
			])
			->add('submit', SubmitType::class, [
				'label' => ($options['forProfile']) ? 'label_edit' : 'label_register',
			]);
	}

	/**
	 * {@inheritdoc}
	 */
	public function configureOptions(OptionsResolver $resolver)
	{
		$resolver->setDefaults([
			'forProfile' => false,
		]);
	}
}
