<?php

namespace localMigration;

use Pimcore\Bundle\EcommerceFrameworkBundle\PimcoreEcommerceFrameworkBundle;
use Pimcore\Logger;
use Pimcore\Model\Tool\TmpStore;
use Pimcore\Model\Redirect;
use Symfony\Component\Filesystem\Filesystem;
use Symfony\Component\Yaml\Yaml;

include_once __DIR__.'/../../../../pimcore/config/startup_cli.php';
\Pimcore\Cache::clearAll();
$db = \Pimcore\Db::get();

fwrite(STDOUT, "134\n");
// only add mapping if the ecommerce framework bundle is enabled
if (PimcoreEcommerceFrameworkBundle::isEnabled()) {
	$configFile = PIMCORE_APP_ROOT.'/config/local/update_134_ecommerce_legacy_mapping.yml';
	$configData = [
	'pimcore_ecommerce_framework' => [
		'use_legacy_class_mapping' => true,
	],
];
	$fs = new Filesystem();
	$relativeConfigFile = $fs->makePathRelative($configFile, PIMCORE_PROJECT_ROOT);
	try {
		$yaml = Yaml::dump($configData, 100);
		$yaml = '# created by build 134 - you can safely remove this if you don\'t need any legacy class mapping'."\n".$yaml;
		$fs->dumpFile($configFile, $yaml);
	} catch (Exception $e) {
		echo sprintf(PHP_EOL.'<p><strong style="color: red">ERROR:</strong> Failed to write YML config to <code>%s</code>: %s</p>'.PHP_EOL, $configFile, $e->getMessage());
		echo <<<EOF
<p>Please add the following configuration manually:<br>
<pre>
pimcore_ecommerce_framework:
	use_legacy_class_mapping: true
</pre>
</p>
EOF;
	}
} else {
	fwrite(STDOUT, "Skipping, because e-commerce bundle is not enabled.\n");
}

fwrite(STDOUT, "141\n");
$db->insert('users_permission_definitions', ['key' => 'piwik_settings']);
$db->insert('users_permission_definitions', ['key' => 'piwik_reports']);

fwrite(STDOUT, "144\n");
$db->query('
CREATE TABLE `gridconfigs` (
	`id` INT(11) NOT NULL AUTO_INCREMENT,
	`ownerId` INT(11) NULL,
	`classId` INT(11) NULL,
	`name` VARCHAR(50) NULL,
	`searchType` VARCHAR(50) NULL,
	`config` LONGTEXT NULL,
	`description` LONGTEXT NULL,	
	`creationDate` INT(11) NULL,
	`modificationDate` INT(11) NULL,
	PRIMARY KEY (`id`),
	INDEX `ownerId` (`ownerId`),
	INDEX `classId` (`classId`),
	INDEX `searchType` (`searchType`)
)
DEFAULT CHARSET=utf8mb4;
;
');
$db->query('
CREATE TABLE `gridconfig_favourites` (
	`ownerId` INT(11) NOT NULL,
	`classId` INT(11) NOT NULL,
	`objectId` INT(11) NOT NULL DEFAULT \'0\',
	`gridConfigId` INT(11) NULL,
	`searchType` VARCHAR(50) NOT NULL DEFAULT \'\',
  PRIMARY KEY (`ownerId`, `classId`, `searchType`, `objectId`),
	INDEX `ownerId` (`ownerId`),
	INDEX `classId` (`classId`),
	INDEX `searchType` (`searchType`)
)
DEFAULT CHARSET=utf8mb4;
;
');
$db->query('
CREATE TABLE `gridconfig_shares` (
	`gridConfigId` INT(11) NOT NULL,
	`sharedWithUserId` INT(11) NOT NULL,
	PRIMARY KEY (`gridConfigId`, `sharedWithUserId`),
	INDEX `gridConfigId` (`gridConfigId`),
	INDEX `sharedWithUserId` (`sharedWithUserId`)
)
DEFAULT CHARSET=utf8mb4;
;
');

fwrite(STDOUT, "145\n");
$classList = new \Pimcore\Model\DataObject\ClassDefinition\Listing();
$classes = $classList->load();
if (is_array($classes)) {
	foreach ($classes as $class) {
		$doSave = false;
		foreach ($class->getFieldDefinitions() as $fieldDef) {
			if ($fieldDef instanceof \Pimcore\Model\DataObject\ClassDefinition\Data\Select) {
				$fieldDef->setQueryColumnType('varchar');
				$fieldDef->setColumnType('varchar');
				$doSave = true;
			}
		}
		if ($doSave) {
			$class->save();
		}
	}
}

fwrite(STDOUT, "149\n");
$message = <<<EOF
The Piwik integration now requires to configure a full URI to the Piwik installation including protocol. If you are using
the Piwik integration please update your settings accordingly as Piwik tracking will be disabled until you update the URL.
Plase have a look at the <a target="_blank" href="https://pimcore.com/docs/5.0.x/Installation_and_Upgrade/Upgrade_Notes/Within_V5.html#page_Build_149_2017_11_14">upgrade docs</a>
for details.
EOF;
echo sprintf('<p>%s</p>'.PHP_EOL, $message);

fwrite(STDOUT, "151\n");
$db->query("UPDATE users_permission_definitions SET `key`='tags_configuration' WHERE `key`=\"tags_config\"");

fwrite(STDOUT, "152\n");

$db->query('
CREATE TABLE `importconfigs` (
	`id` INT(11) NOT NULL AUTO_INCREMENT,
	`ownerId` INT(11) NULL,
	`classId` INT(11) NULL,
	`name` VARCHAR(50) NULL,
	`config` LONGTEXT NULL,
	`description` LONGTEXT NULL,	
	`creationDate` INT(11) NULL,
	`modificationDate` INT(11) NULL,
	`shareGlobally` TINYINT(1) NULL,
	PRIMARY KEY (`id`),
	INDEX `ownerId` (`ownerId`),
	INDEX `classId` (`classId`),
	INDEX `shareGlobally` (`shareGlobally`)
)
DEFAULT CHARSET=utf8mb4;
;
');
$db->query('
CREATE TABLE `importconfig_shares` (
	`importConfigId` INT(11) NOT NULL,
	`sharedWithUserId` INT(11) NOT NULL,
	PRIMARY KEY (`importConfigId`, `sharedWithUserId`),
	INDEX `importConfigId` (`importConfigId`),
	INDEX `sharedWithUserId` (`sharedWithUserId`)
)
DEFAULT CHARSET=utf8mb4;
;
');
$db->query('
ALTER TABLE `gridconfigs`
	ADD COLUMN `shareGlobally` TINYINT(1) NULL DEFAULT NULL AFTER `creationDate`,
	ADD INDEX `shareGlobally` (`shareGlobally`);
;
');

fwrite(STDOUT, "153\n");
$db->insert('users_permission_definitions', ['key' => 'share_configurations']);
$db->insert('users_permission_definitions', ['key' => 'gdpr_data_extractor']);

fwrite(STDOUT, "159\n");
$db->query('
ALTER TABLE `redirects`
	ADD COLUMN `type` VARCHAR(100) DEFAULT NULL AFTER `id`,
	ADD COLUMN `regex` TINYINT(1) DEFAULT NULL AFTER `priority`
;
');
$db->beginTransaction();
try {
	// existing behaviour was always a regex-match, so update existing rows to do so
	$db->query('UPDATE redirects SET regex = 1');
	// update type depending on sourceEntireUrl setting
	$db->executeQuery('UPDATE redirects SET type = ? WHERE sourceEntireUrl = 1', [
		Redirect::TYPE_ENTIRE_URI,
	]);
	$db->executeQuery('UPDATE redirects SET type = ? WHERE sourceEntireUrl <> 1 OR sourceEntireUrl IS NULL', [
		Redirect::TYPE_PATH_QUERY,
	]);
	$db->commit();
} catch (\Throwable $e) {
	$db->rollBack();
	Logger::crit($e);
	throw $e;
}
// drop column as it isn't needed anymore
// unfortunately MySQL does not support transactional DDL
// so we need to do this after the transaction succeeded
$db->query('ALTER TABLE redirects DROP COLUMN sourceEntireUrl');

fwrite(STDOUT, "161\n");
$tmpStoreId = 'pimcore-5.1-build-161-notice';
if (!TmpStore::get($tmpStoreId)) {
	TmpStore::add($tmpStoreId, 'true', null, 86400 * 30);
	echo '<b>You\'re going to install Pimcore 5.1</b><br />';
	echo 'This release includes breaking changes in the targeting engine and for bundles implementing admin features.<br/>';
	echo 'Please see <a href="https://pimcore.com/docs/5.0.x/Development_Documentation/Installation_and_Upgrade/Upgrade_Notes/Within_V5.html#page_Pimcore-5-1" target="_blank">the upgrade notes</a> for details and restart the update process to continue.';
}

$db->query('ALTER TABLE `quantityvalue_units` MODIFY `abbreviation` varchar(20)');
// targeting
$db->query('RENAME TABLE targeting_personas TO targeting_target_groups');
$db->query('ALTER TABLE `targeting_target_groups` DROP `conditions`');
$db->query('ALTER TABLE `documents_page` CHANGE `personas` `targetGroupIds` VARCHAR(255)');
$db->query('RENAME TABLE targeting_rules TO PLEASE_DELETE__targeting_rules');
$db->query(<<<'EOF'
CREATE TABLE `targeting_rules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `description` text,
  `scope` varchar(50) DEFAULT NULL,
  `active` tinyint(1) DEFAULT NULL,
  `prio` smallint(5) unsigned NOT NULL DEFAULT '0',
  `conditions` longtext,
  `actions` longtext,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
EOF
);
$db->query(<<<'EOF'
CREATE TABLE `targeting_storage` (
  `visitorId` varchar(100) NOT NULL,
  `scope` varchar(50) NOT NULL,
  `name` varchar(100) NOT NULL,
  `value` text,
  `creationDate` datetime DEFAULT NULL,
  `modificationDate` datetime DEFAULT NULL,
  PRIMARY KEY (`visitorId`,`scope`,`name`),
  KEY `targeting_storage_scope_index` (`scope`),
  KEY `targeting_storage_name_index` (`name`),
  KEY `targeting_storage_visitorId_index` (`visitorId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
EOF
);

\Pimcore\Cache::clearAll();
fwrite(STDOUT, "done\n");
