<?php

namespace localMigration;

include_once __DIR__.'/../../../../pimcore/config/startup_cli.php';
\Pimcore\Cache::clearAll();
$db = \Pimcore\Db::get();

fwrite(STDOUT, "195 pre-update\n");
$largePrefix = $db->fetchRow("SHOW GLOBAL VARIABLES LIKE 'innodb\_large\_prefix';");
if ($largePrefix && $largePrefix['Value'] != 'ON') {
    $incompatible = true;
}
$fileFormat = $db->fetchRow("SHOW GLOBAL VARIABLES LIKE 'innodb\_file\_format';");
if ($fileFormat && $fileFormat['Value'] != 'Barracuda') {
    $incompatible = true;
}
$fileFilePerTable = $db->fetchRow("SHOW GLOBAL VARIABLES LIKE 'innodb\_file\_per\_table';");
if ($fileFilePerTable && $fileFilePerTable['Value'] != 'ON') {
    $incompatible = true;
}
if ($incompatible) {
    echo '<b>Your MySQL/MariaDB Server is incompatible!</b><br />';
    echo 'Please ensure the following MySQL/MariaDB system variables are set accordingly: <br/>';
    echo '<pre>innodb_file_format = Barracuda
innodb_large_prefix = 1
innodb_file_per_table = 1</pre>';
    exit;
}

fwrite(STDOUT, "168\n");
$db->query('ALTER TABLE email_log ADD COLUMN `replyTo` VARCHAR(255) DEFAULT NULL AFTER `from`;');
$db->query('ALTER TABLE documents_email ADD COLUMN `replyTo` VARCHAR(255) DEFAULT NULL AFTER `from`;');

fwrite(STDOUT, "181\n");
$db->query('ALTER TABLE `email_log` ADD INDEX `sentDate` (`sentDate`, `id`);');

fwrite(STDOUT, "182\n");
// move PIMCORE_LOG_FILEOBJECT_DIRECTORY to private var
$oldPath = PIMCORE_LOG_DIRECTORY . '/fileobjects';
$newPath = PIMCORE_PRIVATE_VAR . '/application-logger';
if (is_dir($oldPath) && !is_dir($newPath)) {
    rename($oldPath, $newPath);
}

fwrite(STDOUT, "183\n");
$db->query('ALTER TABLE `versions` ADD COLUMN `binaryDataHash` VARCHAR(40) NULL DEFAULT NULL;');
$db->query('ALTER TABLE `versions` ADD INDEX `binaryDataHash` (`binaryDataHash`);');

fwrite(STDOUT, "184\n");
$db->query('ALTER TABLE `versions` DROP COLUMN `binaryDataHash`;');

fwrite(STDOUT, "186\n");
$websiteSettings = $db->fetchAll('SELECT * FROM website_settings');
if (!$websiteSettings) {
    $websiteSettings = [];
}
$file = \Pimcore\Config::locateConfigFile('website-settings.php');
$table = \Pimcore\Db\PhpArrayFileTable::get($file);
$table->truncate();
foreach ($websiteSettings as $websiteSetting) {
    unset($websiteSetting['id']);
    $table->insertOrUpdate($websiteSetting, $websiteSetting['id']);
}
$db->query('RENAME TABLE `website_settings` TO `PLEASE_DELETE__website_settings`;');

fwrite(STDOUT, "191\n");
try {
    $db->insert('users_permission_definitions', ['key' => 'asset_metadata']);
} catch (\Exception $e) {
}

fwrite(STDOUT, "195\n");
$db->query('ALTER TABLE assets ROW_FORMAT=DYNAMIC;');
$db->query('ALTER TABLE documents ROW_FORMAT=DYNAMIC;');
$db->query('ALTER TABLE objects ROW_FORMAT=DYNAMIC;');
$db->query('ALTER TABLE properties ROW_FORMAT=DYNAMIC;');
$db->query('ALTER TABLE search_backend_data ROW_FORMAT=DYNAMIC;');
$db->query('ALTER TABLE users_workspaces_asset ROW_FORMAT=DYNAMIC;');
$db->query('ALTER TABLE users_workspaces_document ROW_FORMAT=DYNAMIC;');
$db->query('ALTER TABLE users_workspaces_object ROW_FORMAT=DYNAMIC;');
$db->query("ALTER TABLE `assets`
	CHANGE COLUMN `filename` `filename` VARCHAR(255) CHARACTER SET 'utf8' COLLATE 'utf8_general_ci'  NULL DEFAULT ''AFTER `type`,
	CHANGE COLUMN `path` `path` VARCHAR(765) CHARACTER SET 'utf8' COLLATE 'utf8_general_ci' NULL DEFAULT NULL AFTER `filename`;
");
$db->query("ALTER TABLE `documents`
	CHANGE COLUMN `key` `key` VARCHAR(255) CHARACTER SET 'utf8' COLLATE 'utf8_general_ci'  NULL DEFAULT ''AFTER `type`,
	CHANGE COLUMN `path` `path` VARCHAR(765) CHARACTER SET 'utf8' COLLATE 'utf8_general_ci' NULL DEFAULT NULL AFTER `key`;
");
$db->query("ALTER TABLE `objects`
	CHANGE COLUMN `o_key` `o_key` VARCHAR(255) CHARACTER SET 'utf8' COLLATE 'utf8_general_ci'  NULL DEFAULT ''AFTER `o_type`,
	CHANGE COLUMN `o_path` `o_path` VARCHAR(765) CHARACTER SET 'utf8' COLLATE 'utf8_general_ci' NULL DEFAULT NULL AFTER `o_key`;
");
$db->query("ALTER TABLE `properties`
	CHANGE COLUMN `cpath` `cpath` VARCHAR(765) CHARACTER SET 'utf8' COLLATE 'utf8_general_ci'  NULL DEFAULT ''AFTER `ctype`;
");
$db->query("ALTER TABLE `search_backend_data`
	CHANGE COLUMN `fullpath` `fullpath` VARCHAR(765) CHARACTER SET 'utf8' COLLATE 'utf8_general_ci'  NULL DEFAULT ''AFTER `id`;
");
$db->query("ALTER TABLE `users_workspaces_asset`
	CHANGE COLUMN `cpath` `cpath` VARCHAR(765) CHARACTER SET 'utf8' COLLATE 'utf8_general_ci'  NULL DEFAULT ''AFTER `cid`;
");
$db->query("ALTER TABLE `users_workspaces_document`
	CHANGE COLUMN `cpath` `cpath` VARCHAR(765) CHARACTER SET 'utf8' COLLATE 'utf8_general_ci'  NULL DEFAULT ''AFTER `cid`;
");
$db->query("ALTER TABLE `users_workspaces_object`
	CHANGE COLUMN `cpath` `cpath` VARCHAR(765) CHARACTER SET 'utf8' COLLATE 'utf8_general_ci'  NULL DEFAULT ''AFTER `cid`;
");

\Pimcore\Cache::clearAll();
fwrite(STDOUT, "done\n");
