<?php

namespace App\View\Helper;

use App\Tool\Utils;
use Pimcore\Templating\Helper\TemplatingEngineAwareHelperInterface;
use Symfony\Component\Templating\Helper\Helper;

class DocUrl extends Helper implements TemplatingEngineAwareHelperInterface
{
	use \Pimcore\Templating\Helper\Traits\TemplatingEngineAwareHelperTrait;

	/**
	 * {@inheritdoc}
	 */
	public function getName()
	{
		return 'docUrl';
	}

	/**
	 * @param string $realFullPath the master document real full path, e.g. '/en/about-us' if 'en' is your default language
	 *
	 * @return string relative url
	 */
	public function __invoke($realFullPath)
	{
		return Utils::docUrl($realFullPath, $this->templatingEngine->language);
	}
}
