
SET NAMES utf8mb4;



DROP TABLE IF EXISTS `eshop_old_paths`;
CREATE TABLE `eshop_old_paths` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `o_id` int(11) NOT NULL,
  `class` int(3) NOT NULL,
  `translatedPath` varchar(255) DEFAULT NULL,
  `language` varchar(8) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `key_o_id` (`o_id`),
  KEY `key_class` (`class`),
  KEY `key_translatedPath` (`translatedPath`(191)),
  KEY `key_language` (`language`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;



DROP TABLE IF EXISTS `keyvalue_groups`;
CREATE TABLE `keyvalue_groups` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `description` varchar(255) DEFAULT NULL,
  `creationDate` bigint(20) unsigned DEFAULT '0',
  `modificationDate` bigint(20) unsigned DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;



DROP TABLE IF EXISTS `keyvalue_keys`;
CREATE TABLE `keyvalue_keys` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `description` text,
  `type` enum('bool','number','select','text','translated','translatedSelect','range') DEFAULT NULL,
  `unit` varchar(255) DEFAULT NULL,
  `possiblevalues` text,
  `group` int(11) DEFAULT NULL,
  `creationDate` bigint(20) unsigned DEFAULT '0',
  `modificationDate` bigint(20) unsigned DEFAULT '0',
  `translator` int(11) DEFAULT NULL,
  `mandatory` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `group` (`group`),
  CONSTRAINT `keyvalue_keys_ibfk_1` FOREIGN KEY (`group`) REFERENCES `keyvalue_groups` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;



DROP TABLE IF EXISTS `keyvalue_translator_configuration`;
CREATE TABLE `keyvalue_translator_configuration` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(200) DEFAULT NULL,
  `translator` varchar(200) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;



DROP TABLE IF EXISTS `object_localized_data_4`;
CREATE TABLE `object_localized_data_4` (
  `ooo_id` int(11) NOT NULL DEFAULT '0',
  `language` varchar(10) NOT NULL DEFAULT '',
  `name` varchar(255) DEFAULT NULL,
  `seoDescription` longtext,
  `perex` longtext,
  `content` longtext,
  PRIMARY KEY (`ooo_id`,`language`),
  KEY `language` (`language`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;



DROP TABLE IF EXISTS `object_localized_query_4_cs`;
CREATE TABLE `object_localized_query_4_cs` (
  `ooo_id` int(11) NOT NULL DEFAULT '0',
  `language` varchar(10) NOT NULL DEFAULT '',
  `name` varchar(255) DEFAULT NULL,
  `seoDescription` longtext,
  `perex` longtext,
  `content` longtext,
  `url` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`ooo_id`,`language`),
  KEY `language` (`language`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;



DROP TABLE IF EXISTS `object_localized_query_4_en`;
CREATE TABLE `object_localized_query_4_en` (
  `ooo_id` int(11) NOT NULL DEFAULT '0',
  `language` varchar(10) NOT NULL DEFAULT '',
  `name` varchar(255) DEFAULT NULL,
  `url` varchar(255) DEFAULT NULL,
  `seoDescription` longtext,
  `perex` longtext,
  `content` longtext,
  PRIMARY KEY (`ooo_id`,`language`),
  KEY `language` (`language`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;



DROP TABLE IF EXISTS `object_query_10`;
CREATE TABLE `object_query_10` (
  `oo_id` int(11) NOT NULL DEFAULT '0',
  `oo_classId` int(11) DEFAULT '10',
  `oo_className` varchar(255) DEFAULT 'User',
  `email` varchar(255) DEFAULT NULL,
  `password` varchar(190) DEFAULT NULL,
  `activationCode` varchar(255) DEFAULT NULL,
  `lang` varchar(190) DEFAULT NULL,
  `firstName` varchar(255) DEFAULT NULL,
  `lastName` varchar(255) DEFAULT NULL,
  `phone` varchar(255) DEFAULT NULL,
  `street` varchar(255) DEFAULT NULL,
  `city` varchar(255) DEFAULT NULL,
  `zipCode` varchar(255) DEFAULT NULL,
  `company` varchar(255) DEFAULT NULL,
  `dic` varchar(255) DEFAULT NULL,
  `passwordResetToken` varchar(255) DEFAULT NULL,
  `ic` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`oo_id`),
  KEY `p_index_email` (`email`(191)),
  KEY `p_index_activationCode` (`activationCode`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;



DROP TABLE IF EXISTS `object_query_4`;
CREATE TABLE `object_query_4` (
  `oo_id` int(11) NOT NULL DEFAULT '0',
  `oo_classId` int(11) DEFAULT '4',
  `oo_className` varchar(255) DEFAULT 'News',
  `createdOn` bigint(20) DEFAULT NULL,
  `previewImage__image` int(11) DEFAULT NULL,
  `previewImage__hotspots` text,
  PRIMARY KEY (`oo_id`),
  KEY `p_index_createdOn` (`createdOn`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;



DROP TABLE IF EXISTS `object_query_5`;
CREATE TABLE `object_query_5` (
  `oo_id` int(11) NOT NULL DEFAULT '0',
  `oo_classId` int(11) DEFAULT '5',
  `oo_className` varchar(255) DEFAULT 'ContactForm',
  `fullName` varchar(255) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `phone` varchar(255) DEFAULT NULL,
  `message` longtext,
  `lang` varchar(190) DEFAULT NULL,
  PRIMARY KEY (`oo_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;



DROP TABLE IF EXISTS `object_query_6`;
CREATE TABLE `object_query_6` (
  `oo_id` int(11) NOT NULL DEFAULT '0',
  `oo_classId` int(11) DEFAULT '6',
  `oo_className` varchar(255) DEFAULT 'NewsletterForm',
  `email` varchar(255) DEFAULT NULL,
  `lang` varchar(190) DEFAULT NULL,
  `unsubscribeCode` varchar(255) DEFAULT NULL,
  `firstname` varchar(255) DEFAULT NULL,
  `lastname` varchar(255) DEFAULT NULL,
  `gender` varchar(190) DEFAULT NULL,
  `newsletterActive` tinyint(1) DEFAULT NULL,
  `newsletterConfirmed` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`oo_id`),
  KEY `p_index_unsubscribeCode` (`unsubscribeCode`(191)),
  KEY `p_index_email` (`email`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;



DROP TABLE IF EXISTS `object_relations_10`;
CREATE TABLE `object_relations_10` (
  `src_id` int(11) NOT NULL DEFAULT '0',
  `dest_id` int(11) NOT NULL DEFAULT '0',
  `type` varchar(50) NOT NULL DEFAULT '',
  `fieldname` varchar(70) NOT NULL DEFAULT '0',
  `index` int(11) unsigned NOT NULL DEFAULT '0',
  `ownertype` enum('object','fieldcollection','localizedfield','objectbrick') NOT NULL DEFAULT 'object',
  `ownername` varchar(70) NOT NULL DEFAULT '',
  `position` varchar(70) NOT NULL DEFAULT '0',
  KEY `forward_lookup` (`src_id`,`ownertype`,`ownername`,`position`),
  KEY `reverse_lookup` (`dest_id`,`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;



DROP TABLE IF EXISTS `object_relations_4`;
CREATE TABLE `object_relations_4` (
  `src_id` int(11) NOT NULL DEFAULT '0',
  `dest_id` int(11) NOT NULL DEFAULT '0',
  `type` varchar(50) NOT NULL DEFAULT '',
  `fieldname` varchar(70) NOT NULL DEFAULT '0',
  `index` int(11) unsigned NOT NULL DEFAULT '0',
  `ownertype` enum('object','fieldcollection','localizedfield','objectbrick') NOT NULL DEFAULT 'object',
  `ownername` varchar(70) NOT NULL DEFAULT '',
  `position` varchar(70) NOT NULL DEFAULT '0',
  KEY `forward_lookup` (`src_id`,`ownertype`,`ownername`,`position`),
  KEY `reverse_lookup` (`dest_id`,`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;



DROP TABLE IF EXISTS `object_relations_5`;
CREATE TABLE `object_relations_5` (
  `src_id` int(11) NOT NULL DEFAULT '0',
  `dest_id` int(11) NOT NULL DEFAULT '0',
  `type` varchar(50) NOT NULL DEFAULT '',
  `fieldname` varchar(70) NOT NULL DEFAULT '0',
  `index` int(11) unsigned NOT NULL DEFAULT '0',
  `ownertype` enum('object','fieldcollection','localizedfield','objectbrick') NOT NULL DEFAULT 'object',
  `ownername` varchar(70) NOT NULL DEFAULT '',
  `position` varchar(70) NOT NULL DEFAULT '0',
  KEY `forward_lookup` (`src_id`,`ownertype`,`ownername`,`position`),
  KEY `reverse_lookup` (`dest_id`,`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;



DROP TABLE IF EXISTS `object_relations_6`;
CREATE TABLE `object_relations_6` (
  `src_id` int(11) NOT NULL DEFAULT '0',
  `dest_id` int(11) NOT NULL DEFAULT '0',
  `type` varchar(50) NOT NULL DEFAULT '',
  `fieldname` varchar(70) NOT NULL DEFAULT '0',
  `index` int(11) unsigned NOT NULL DEFAULT '0',
  `ownertype` enum('object','fieldcollection','localizedfield','objectbrick') NOT NULL DEFAULT 'object',
  `ownername` varchar(70) NOT NULL DEFAULT '',
  `position` varchar(70) NOT NULL DEFAULT '0',
  KEY `forward_lookup` (`src_id`,`ownertype`,`ownername`,`position`),
  KEY `reverse_lookup` (`dest_id`,`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;



DROP TABLE IF EXISTS `object_store_10`;
CREATE TABLE `object_store_10` (
  `oo_id` int(11) NOT NULL DEFAULT '0',
  `email` varchar(255) DEFAULT NULL,
  `password` varchar(190) DEFAULT NULL,
  `activationCode` varchar(255) DEFAULT NULL,
  `lang` varchar(190) DEFAULT NULL,
  `firstName` varchar(255) DEFAULT NULL,
  `lastName` varchar(255) DEFAULT NULL,
  `phone` varchar(255) DEFAULT NULL,
  `street` varchar(255) DEFAULT NULL,
  `city` varchar(255) DEFAULT NULL,
  `zipCode` varchar(255) DEFAULT NULL,
  `company` varchar(255) DEFAULT NULL,
  `dic` varchar(255) DEFAULT NULL,
  `passwordResetToken` varchar(255) DEFAULT NULL,
  `ic` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`oo_id`),
  KEY `p_index_email` (`email`(191)),
  KEY `p_index_activationCode` (`activationCode`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;



DROP TABLE IF EXISTS `object_store_4`;
CREATE TABLE `object_store_4` (
  `oo_id` int(11) NOT NULL DEFAULT '0',
  `createdOn` bigint(20) DEFAULT NULL,
  `previewImage__image` int(11) DEFAULT NULL,
  `previewImage__hotspots` text,
  PRIMARY KEY (`oo_id`),
  KEY `p_index_createdOn` (`createdOn`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;



DROP TABLE IF EXISTS `object_store_5`;
CREATE TABLE `object_store_5` (
  `oo_id` int(11) NOT NULL DEFAULT '0',
  `fullName` varchar(255) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `phone` varchar(255) DEFAULT NULL,
  `message` longtext,
  `lang` varchar(190) DEFAULT NULL,
  PRIMARY KEY (`oo_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;



DROP TABLE IF EXISTS `object_store_6`;
CREATE TABLE `object_store_6` (
  `oo_id` int(11) NOT NULL DEFAULT '0',
  `email` varchar(255) DEFAULT NULL,
  `lang` varchar(190) DEFAULT NULL,
  `unsubscribeCode` varchar(255) DEFAULT NULL,
  `firstname` varchar(255) DEFAULT NULL,
  `lastname` varchar(255) DEFAULT NULL,
  `gender` varchar(190) DEFAULT NULL,
  `newsletterActive` tinyint(1) DEFAULT NULL,
  `newsletterConfirmed` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`oo_id`),
  KEY `p_index_unsubscribeCode` (`unsubscribeCode`(191)),
  KEY `p_index_email` (`email`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;



DROP TABLE IF EXISTS `pimcore_migrations`;
CREATE TABLE `pimcore_migrations` (
  `migration_set` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `version` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `migrated_at` datetime NOT NULL,
  PRIMARY KEY (`migration_set`,`version`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



INSERT INTO assets (`id`,`parentId`,`type`,`filename`,`path`,`mimetype`,`creationDate`,`modificationDate`,`userOwner`,`userModification`,`customSettings`,`hasMetaData`,`versionCount`) VALUES ('1','0','folder','','/',NULL,'1508244399','1508244399','1','1',NULL,'0','0');
INSERT INTO assets (`id`,`parentId`,`type`,`filename`,`path`,`mimetype`,`creationDate`,`modificationDate`,`userOwner`,`userModification`,`customSettings`,`hasMetaData`,`versionCount`) VALUES ('4','1','folder','novinky','/',NULL,'1508244399','1508244399','2','2',NULL,'0','0');
INSERT INTO assets (`id`,`parentId`,`type`,`filename`,`path`,`mimetype`,`creationDate`,`modificationDate`,`userOwner`,`userModification`,`customSettings`,`hasMetaData`,`versionCount`) VALUES ('5','4','folder','galerie','/novinky/',NULL,'1508244399','1508244399','2','2',NULL,'0','0');
INSERT INTO assets (`id`,`parentId`,`type`,`filename`,`path`,`mimetype`,`creationDate`,`modificationDate`,`userOwner`,`userModification`,`customSettings`,`hasMetaData`,`versionCount`) VALUES ('6','1','folder','dokumenty','/',NULL,'1508244399','1508244399','2','2',NULL,'0','0');
INSERT INTO classes (`id`,`name`) VALUES ('5','ContactForm');
INSERT INTO classes (`id`,`name`) VALUES ('4','News');
INSERT INTO classes (`id`,`name`) VALUES ('6','NewsletterForm');
INSERT INTO classes (`id`,`name`) VALUES ('10','User');
INSERT INTO dependencies (`id`,`sourcetype`,`sourceid`,`targettype`,`targetid`) VALUES ('1','document','7','document','1');
INSERT INTO documents (`id`,`parentId`,`type`,`key`,`path`,`index`,`published`,`creationDate`,`modificationDate`,`userOwner`,`userModification`,`versionCount`) VALUES ('1','0','page','','/','999999','1','1508244399','1508244399','1','1','0');
INSERT INTO documents (`id`,`parentId`,`type`,`key`,`path`,`index`,`published`,`creationDate`,`modificationDate`,`userOwner`,`userModification`,`versionCount`) VALUES ('3','1','folder','system','/','8','1','1508244399','1508244399','2','2','0');
INSERT INTO documents (`id`,`parentId`,`type`,`key`,`path`,`index`,`published`,`creationDate`,`modificationDate`,`userOwner`,`userModification`,`versionCount`) VALUES ('5','1','folder','notifikace','/','7','1','1508244399','1508244399','2','2','0');
INSERT INTO documents (`id`,`parentId`,`type`,`key`,`path`,`index`,`published`,`creationDate`,`modificationDate`,`userOwner`,`userModification`,`versionCount`) VALUES ('6','5','email','newsletter','/notifikace/','2','1','1508244399','1516485543','2','2','0');
INSERT INTO documents (`id`,`parentId`,`type`,`key`,`path`,`index`,`published`,`creationDate`,`modificationDate`,`userOwner`,`userModification`,`versionCount`) VALUES ('7','3','page','chybova-stranka','/system/','0','1','1508244399','1589189412','2','6','1');
INSERT INTO documents (`id`,`parentId`,`type`,`key`,`path`,`index`,`published`,`creationDate`,`modificationDate`,`userOwner`,`userModification`,`versionCount`) VALUES ('8','1','page','o-nas','/','0','1','1508244399','1516565769','2','2','0');
INSERT INTO documents (`id`,`parentId`,`type`,`key`,`path`,`index`,`published`,`creationDate`,`modificationDate`,`userOwner`,`userModification`,`versionCount`) VALUES ('9','1','page','kontakt','/','2','1','1508244399','1508244399','2','2','0');
INSERT INTO documents (`id`,`parentId`,`type`,`key`,`path`,`index`,`published`,`creationDate`,`modificationDate`,`userOwner`,`userModification`,`versionCount`) VALUES ('12','1','page','ucet','/','4','1','1508244399','1508244399','2','2','0');
INSERT INTO documents (`id`,`parentId`,`type`,`key`,`path`,`index`,`published`,`creationDate`,`modificationDate`,`userOwner`,`userModification`,`versionCount`) VALUES ('14','5','email','registrace','/notifikace/','0','1','1508244399','1516485460','2','2','0');
INSERT INTO documents (`id`,`parentId`,`type`,`key`,`path`,`index`,`published`,`creationDate`,`modificationDate`,`userOwner`,`userModification`,`versionCount`) VALUES ('16','5','email','reset-hesla','/notifikace/','1','1','1508244399','1516485532','2','2','0');
INSERT INTO documents (`id`,`parentId`,`type`,`key`,`path`,`index`,`published`,`creationDate`,`modificationDate`,`userOwner`,`userModification`,`versionCount`) VALUES ('21','1','page','mapa-stranek','/','6','1','1508244399','1508244399','2','2','0');
INSERT INTO documents (`id`,`parentId`,`type`,`key`,`path`,`index`,`published`,`creationDate`,`modificationDate`,`userOwner`,`userModification`,`versionCount`) VALUES ('22','1','page','aktuality','/','1','1','1508244399','1508244399','2','2','0');
INSERT INTO documents (`id`,`parentId`,`type`,`key`,`path`,`index`,`published`,`creationDate`,`modificationDate`,`userOwner`,`userModification`,`versionCount`) VALUES ('24','5','email','pro-administratora-novy-kontaktni-formular','/notifikace/','3','1','1508244399','1516485475','2','2','0');
INSERT INTO documents (`id`,`parentId`,`type`,`key`,`path`,`index`,`published`,`creationDate`,`modificationDate`,`userOwner`,`userModification`,`versionCount`) VALUES ('26','1','page','prihlaseni','/','3','1','1508244399','1508244399','2','2','0');
INSERT INTO documents (`id`,`parentId`,`type`,`key`,`path`,`index`,`published`,`creationDate`,`modificationDate`,`userOwner`,`userModification`,`versionCount`) VALUES ('27','12','page','zmena-hesla','/ucet/','0','1','1508244399','1508244399','2','2','0');
INSERT INTO documents (`id`,`parentId`,`type`,`key`,`path`,`index`,`published`,`creationDate`,`modificationDate`,`userOwner`,`userModification`,`versionCount`) VALUES ('28','12','page','profil','/ucet/','1','1','1508244399','1516528643','2','2','0');
INSERT INTO documents_elements (`documentId`,`name`,`type`,`data`) VALUES ('6','email_body','wysiwyg','<p>Dobrý den,</p>\n\n<p>Děkujeme, že jste se přihlásili k odběru našeho newletteru.</p>\n\n<p>Jestliže jste se do newsletteru nepřihlásili dobrovolně nebo se v budoucnu budete chtít odhlásit, můžete použít nasledující odkaz k odhlášení:</p>\n\n<p><a href=\"%Text(unsubscribeUrl);\" target=\"_blank\">%Text(unsubscribeUrl);</a></p>\n\n<p>Pimweb</p>\n');
INSERT INTO documents_elements (`documentId`,`name`,`type`,`data`) VALUES ('7','content','areablock','a:1:{i:0;a:3:{s:3:\"key\";s:1:\"1\";s:4:\"type\";s:9:\"textblock\";s:6:\"hidden\";b:0;}}');
INSERT INTO documents_elements (`documentId`,`name`,`type`,`data`) VALUES ('7','content:1.text','wysiwyg','<h1 style=\"text-align: center;\">Ups!</h1>\n\n<p>Zdá se, že tato stránka není dostupná. Zkontrolujte URL adresu nebo pokračujte na <a href=\"/\" pimcore_id=\"1\" pimcore_type=\"document\">hlavní stránku</a>.</p>\n');
INSERT INTO documents_elements (`documentId`,`name`,`type`,`data`) VALUES ('8','content','areablock','a:2:{i:0;a:2:{s:3:\"key\";s:1:\"1\";s:4:\"type\";s:9:\"textblock\";}i:1;a:2:{s:3:\"key\";s:1:\"2\";s:4:\"type\";s:7:\"gallery\";}}');
INSERT INTO documents_elements (`documentId`,`name`,`type`,`data`) VALUES ('8','content:1.text','wysiwyg','');
INSERT INTO documents_elements (`documentId`,`name`,`type`,`data`) VALUES ('8','content:2.gallery_images','relations','a:0:{}');
INSERT INTO documents_elements (`documentId`,`name`,`type`,`data`) VALUES ('14','email_body','wysiwyg','<p>Dobrý den,</p>\n\n<p>Děkujeme za registraci na našich stránkách <a href=\"%Text(siteUrl);\" target=\"_blank\">%Text(siteUrl);</a>. Pro dokončení registrace použijte následující odkaz:</p>\n\n<p><a href=\"%Text(activationUrl);\" target=\"_blank\">%Text(activationUrl);</a></p>\n\n<p>Pimweb</p>\n');
INSERT INTO documents_elements (`documentId`,`name`,`type`,`data`) VALUES ('16','email_body','wysiwyg','<p>Dobrý den,</p>\n\n<p>Na Vašem účtu bylo požádáno o resetování hesla. Heslo si můžete změnit přes nasledujúcí odkaz:</p>\n\n<p><strong><a href=\"%Text(link);\" target=\"_blank\">%Text(link);</a></strong></p>\n\n<p>Pimweb</p>\n');
INSERT INTO documents_elements (`documentId`,`name`,`type`,`data`) VALUES ('24','email_body','wysiwyg','<p>Dobrý den,</p>\n\n<p>v systému byl založen nový kontaktní formulář s klíčem <strong><a href=\"%Text(deeplink);\" target=\"_blank\">%DataObject(form, {\"method\":\"getKey\"});</a></strong>. Obsah:</p>\n\n<p>Jméno: %DataObject(form, {\"method\":\"getFullName\"});</p>\n\n<p>E-mail: %DataObject(form, {\"method\":\"getEmail\"});</p>\n\n<p>Telefon: %DataObject(form, {\"method\":\"getPhone\"});</p>\n\n<p>Zpráva: %DataObject(form, {\"method\":\"getMessage\"});</p>\n\n<p>Pimweb</p>\n');
INSERT INTO documents_email (`id`,`module`,`controller`,`action`,`template`,`to`,`from`,`replyTo`,`cc`,`bcc`,`subject`,`missingRequiredEditable`) VALUES ('6',NULL,'cms','simple-mail',NULL,'','noreply@vm3.portadesign.cz',NULL,'','','Pimweb - přihlášení k odběru newsletteru',NULL);
INSERT INTO documents_email (`id`,`module`,`controller`,`action`,`template`,`to`,`from`,`replyTo`,`cc`,`bcc`,`subject`,`missingRequiredEditable`) VALUES ('14',NULL,'cms','simple-mail',NULL,'','noreply@vm3.portadesign.cz',NULL,'','','Pimweb - dokončení registrace',NULL);
INSERT INTO documents_email (`id`,`module`,`controller`,`action`,`template`,`to`,`from`,`replyTo`,`cc`,`bcc`,`subject`,`missingRequiredEditable`) VALUES ('16',NULL,'cms','simple-mail',NULL,'','noreply@vm3.portadesign.cz',NULL,'','','Pimweb - reset hesla',NULL);
INSERT INTO documents_email (`id`,`module`,`controller`,`action`,`template`,`to`,`from`,`replyTo`,`cc`,`bcc`,`subject`,`missingRequiredEditable`) VALUES ('24',NULL,'cms','simple-mail',NULL,'noreply@vm3.portadesign.cz','noreply@vm3.portadesign.cz',NULL,'','','Pimweb - notifikace: nový kontaktní formulář',NULL);
INSERT INTO documents_page (`id`,`module`,`controller`,`action`,`template`,`title`,`description`,`metaData`,`prettyUrl`,`contentMasterDocumentId`,`targetGroupIds`,`missingRequiredEditable`) VALUES ('1',NULL,'default','index',NULL,'Úvod','Úvod',NULL,NULL,NULL,NULL,NULL);
INSERT INTO documents_page (`id`,`module`,`controller`,`action`,`template`,`title`,`description`,`metaData`,`prettyUrl`,`contentMasterDocumentId`,`targetGroupIds`,`missingRequiredEditable`) VALUES ('7',NULL,'@AppBundle\\Controller\\DefaultController','errorPage',NULL,'Chybová stránka','Chybová stránka','a:0:{}',NULL,NULL,'',NULL);
INSERT INTO documents_page (`id`,`module`,`controller`,`action`,`template`,`title`,`description`,`metaData`,`prettyUrl`,`contentMasterDocumentId`,`targetGroupIds`,`missingRequiredEditable`) VALUES ('8',NULL,'cms','template-simple',NULL,'O nás','O nás','a:0:{}',NULL,NULL,'',NULL);
INSERT INTO documents_page (`id`,`module`,`controller`,`action`,`template`,`title`,`description`,`metaData`,`prettyUrl`,`contentMasterDocumentId`,`targetGroupIds`,`missingRequiredEditable`) VALUES ('9',NULL,'cms','contact-us',NULL,'Kontakt','Kontakt',NULL,NULL,NULL,NULL,NULL);
INSERT INTO documents_page (`id`,`module`,`controller`,`action`,`template`,`title`,`description`,`metaData`,`prettyUrl`,`contentMasterDocumentId`,`targetGroupIds`,`missingRequiredEditable`) VALUES ('12',NULL,'user','account',NULL,'Účet','Účet',NULL,NULL,NULL,NULL,NULL);
INSERT INTO documents_page (`id`,`module`,`controller`,`action`,`template`,`title`,`description`,`metaData`,`prettyUrl`,`contentMasterDocumentId`,`targetGroupIds`,`missingRequiredEditable`) VALUES ('21',NULL,'cms','sitemap',NULL,'Mapa stránek','Mapa stránek',NULL,NULL,NULL,NULL,NULL);
INSERT INTO documents_page (`id`,`module`,`controller`,`action`,`template`,`title`,`description`,`metaData`,`prettyUrl`,`contentMasterDocumentId`,`targetGroupIds`,`missingRequiredEditable`) VALUES ('22',NULL,'cms','news',NULL,'Aktuality','Aktuality',NULL,NULL,NULL,NULL,NULL);
INSERT INTO documents_page (`id`,`module`,`controller`,`action`,`template`,`title`,`description`,`metaData`,`prettyUrl`,`contentMasterDocumentId`,`targetGroupIds`,`missingRequiredEditable`) VALUES ('26',NULL,'user','login',NULL,'Přihlášení','Přihlášení',NULL,NULL,NULL,NULL,NULL);
INSERT INTO documents_page (`id`,`module`,`controller`,`action`,`template`,`title`,`description`,`metaData`,`prettyUrl`,`contentMasterDocumentId`,`targetGroupIds`,`missingRequiredEditable`) VALUES ('27',NULL,'user','change-password',NULL,'Změna hesla','Změna hesla',NULL,NULL,NULL,NULL,NULL);
INSERT INTO documents_page (`id`,`module`,`controller`,`action`,`template`,`title`,`description`,`metaData`,`prettyUrl`,`contentMasterDocumentId`,`targetGroupIds`,`missingRequiredEditable`) VALUES ('28',NULL,'user','profile',NULL,'Profil','Profil','a:0:{}',NULL,NULL,'',NULL);
INSERT INTO objects (`o_id`,`o_parentId`,`o_type`,`o_key`,`o_path`,`o_index`,`o_published`,`o_creationDate`,`o_modificationDate`,`o_userOwner`,`o_userModification`,`o_classId`,`o_className`,`o_childrenSortBy`,`o_versionCount`) VALUES ('1','0','folder','','/','999999','1','1508244399','1508244399','1','1',NULL,NULL,NULL,'0');
INSERT INTO objects (`o_id`,`o_parentId`,`o_type`,`o_key`,`o_path`,`o_index`,`o_published`,`o_creationDate`,`o_modificationDate`,`o_userOwner`,`o_userModification`,`o_classId`,`o_className`,`o_childrenSortBy`,`o_versionCount`) VALUES ('2','1','folder','novinky','/','0','1','1508244399','1508244399','2','2',NULL,NULL,NULL,'0');
INSERT INTO objects (`o_id`,`o_parentId`,`o_type`,`o_key`,`o_path`,`o_index`,`o_published`,`o_creationDate`,`o_modificationDate`,`o_userOwner`,`o_userModification`,`o_classId`,`o_className`,`o_childrenSortBy`,`o_versionCount`) VALUES ('3','1','folder','uzivatele','/','0','1','1508244399','1508244399','2','2',NULL,NULL,NULL,'0');
INSERT INTO objects (`o_id`,`o_parentId`,`o_type`,`o_key`,`o_path`,`o_index`,`o_published`,`o_creationDate`,`o_modificationDate`,`o_userOwner`,`o_userModification`,`o_classId`,`o_className`,`o_childrenSortBy`,`o_versionCount`) VALUES ('4','1','folder','kontakt','/','0','1','1508244399','1508244399','2','2',NULL,NULL,NULL,'0');
INSERT INTO objects (`o_id`,`o_parentId`,`o_type`,`o_key`,`o_path`,`o_index`,`o_published`,`o_creationDate`,`o_modificationDate`,`o_userOwner`,`o_userModification`,`o_classId`,`o_className`,`o_childrenSortBy`,`o_versionCount`) VALUES ('5','4','folder','kontaktni-formulare','/kontakt/','0','1','1508244399','1508244399','2','2',NULL,NULL,NULL,'0');
INSERT INTO objects (`o_id`,`o_parentId`,`o_type`,`o_key`,`o_path`,`o_index`,`o_published`,`o_creationDate`,`o_modificationDate`,`o_userOwner`,`o_userModification`,`o_classId`,`o_className`,`o_childrenSortBy`,`o_versionCount`) VALUES ('6','4','folder','newsletter','/kontakt/','0','1','1508244399','1508244399','2','2',NULL,NULL,NULL,'0');
INSERT INTO pimcore_migrations (`migration_set`,`version`,`migrated_at`) VALUES ('pimcore_core','20180724144005','2019-05-13 14:15:37');
INSERT INTO pimcore_migrations (`migration_set`,`version`,`migrated_at`) VALUES ('pimcore_core','20180830113528','2019-05-13 14:15:54');
INSERT INTO pimcore_migrations (`migration_set`,`version`,`migrated_at`) VALUES ('pimcore_core','20180830122128','2019-05-13 14:15:54');
INSERT INTO pimcore_migrations (`migration_set`,`version`,`migrated_at`) VALUES ('pimcore_core','20180904201947','2019-05-13 14:15:55');
INSERT INTO pimcore_migrations (`migration_set`,`version`,`migrated_at`) VALUES ('pimcore_core','20180906142115','2019-05-13 14:15:56');
INSERT INTO pimcore_migrations (`migration_set`,`version`,`migrated_at`) VALUES ('pimcore_core','20180907115436','2019-05-13 14:15:56');
INSERT INTO pimcore_migrations (`migration_set`,`version`,`migrated_at`) VALUES ('pimcore_core','20180912140913','2019-05-13 14:15:56');
INSERT INTO pimcore_migrations (`migration_set`,`version`,`migrated_at`) VALUES ('pimcore_core','20180913132106','2019-05-13 14:15:56');
INSERT INTO pimcore_migrations (`migration_set`,`version`,`migrated_at`) VALUES ('pimcore_core','20180924111736','2019-05-13 14:15:56');
INSERT INTO pimcore_migrations (`migration_set`,`version`,`migrated_at`) VALUES ('pimcore_core','20181008132414','2019-05-13 14:15:56');
INSERT INTO pimcore_migrations (`migration_set`,`version`,`migrated_at`) VALUES ('pimcore_core','20181009135158','2019-05-13 14:15:56');
INSERT INTO pimcore_migrations (`migration_set`,`version`,`migrated_at`) VALUES ('pimcore_core','20181115114003','2019-05-13 14:15:56');
INSERT INTO pimcore_migrations (`migration_set`,`version`,`migrated_at`) VALUES ('pimcore_core','20181126094412','2019-05-13 14:15:56');
INSERT INTO pimcore_migrations (`migration_set`,`version`,`migrated_at`) VALUES ('pimcore_core','20181126144341','2019-05-13 14:15:56');
INSERT INTO pimcore_migrations (`migration_set`,`version`,`migrated_at`) VALUES ('pimcore_core','20181128074035','2019-05-13 14:15:56');
INSERT INTO pimcore_migrations (`migration_set`,`version`,`migrated_at`) VALUES ('pimcore_core','20181128112320','2019-05-13 14:15:56');
INSERT INTO pimcore_migrations (`migration_set`,`version`,`migrated_at`) VALUES ('pimcore_core','20181214145532','2019-05-13 14:15:56');
INSERT INTO pimcore_migrations (`migration_set`,`version`,`migrated_at`) VALUES ('pimcore_core','20190102143436','2019-05-13 14:15:57');
INSERT INTO pimcore_migrations (`migration_set`,`version`,`migrated_at`) VALUES ('pimcore_core','20190102153226','2019-05-13 14:15:57');
INSERT INTO pimcore_migrations (`migration_set`,`version`,`migrated_at`) VALUES ('pimcore_core','20190108131401','2019-05-13 14:15:57');
INSERT INTO pimcore_migrations (`migration_set`,`version`,`migrated_at`) VALUES ('pimcore_core','20190124105627','2019-05-13 14:15:57');
INSERT INTO pimcore_migrations (`migration_set`,`version`,`migrated_at`) VALUES ('pimcore_core','20190131074054','2019-05-13 14:15:57');
INSERT INTO pimcore_migrations (`migration_set`,`version`,`migrated_at`) VALUES ('pimcore_core','20190131095936','2019-05-13 14:15:57');
INSERT INTO pimcore_migrations (`migration_set`,`version`,`migrated_at`) VALUES ('pimcore_core','20190320133439','2019-05-13 14:15:57');
INSERT INTO pimcore_migrations (`migration_set`,`version`,`migrated_at`) VALUES ('pimcore_core','20190402073052','2019-05-13 14:15:57');
INSERT INTO pimcore_migrations (`migration_set`,`version`,`migrated_at`) VALUES ('pimcore_core','20190403120728','2019-05-13 14:15:57');
INSERT INTO pimcore_migrations (`migration_set`,`version`,`migrated_at`) VALUES ('pimcore_core','20190405112707','2019-05-13 14:15:58');
INSERT INTO pimcore_migrations (`migration_set`,`version`,`migrated_at`) VALUES ('pimcore_core','20190408084129','2019-05-13 14:15:58');
INSERT INTO pimcore_migrations (`migration_set`,`version`,`migrated_at`) VALUES ('pimcore_core','20190508074339','2020-07-03 18:07:16');
INSERT INTO pimcore_migrations (`migration_set`,`version`,`migrated_at`) VALUES ('pimcore_core','20190515130651','2020-07-03 18:07:16');
INSERT INTO pimcore_migrations (`migration_set`,`version`,`migrated_at`) VALUES ('pimcore_core','20190520151448','2020-07-03 18:07:16');
INSERT INTO pimcore_migrations (`migration_set`,`version`,`migrated_at`) VALUES ('pimcore_core','20190522130545','2020-07-03 18:07:16');
INSERT INTO pimcore_migrations (`migration_set`,`version`,`migrated_at`) VALUES ('pimcore_core','20190527121800','2020-07-03 18:07:16');
INSERT INTO pimcore_migrations (`migration_set`,`version`,`migrated_at`) VALUES ('pimcore_core','20190618154000','2020-07-03 18:07:17');
INSERT INTO pimcore_migrations (`migration_set`,`version`,`migrated_at`) VALUES ('pimcore_core','20190701141857','2020-07-03 18:07:17');
INSERT INTO pimcore_migrations (`migration_set`,`version`,`migrated_at`) VALUES ('pimcore_core','20190708175236','2020-07-03 18:07:17');
INSERT INTO pimcore_migrations (`migration_set`,`version`,`migrated_at`) VALUES ('pimcore_core','20190729085052','2020-07-03 18:07:17');
INSERT INTO pimcore_migrations (`migration_set`,`version`,`migrated_at`) VALUES ('pimcore_core','20190802090149','2020-07-03 18:07:17');
INSERT INTO pimcore_migrations (`migration_set`,`version`,`migrated_at`) VALUES ('pimcore_core','20190806160450','2020-07-03 18:07:19');
INSERT INTO pimcore_migrations (`migration_set`,`version`,`migrated_at`) VALUES ('pimcore_core','20190807121356','2020-07-03 18:07:19');
INSERT INTO pimcore_migrations (`migration_set`,`version`,`migrated_at`) VALUES ('pimcore_core','20190828142756','2020-07-03 18:07:19');
INSERT INTO pimcore_migrations (`migration_set`,`version`,`migrated_at`) VALUES ('pimcore_core','20190902085052','2020-07-03 18:07:20');
INSERT INTO pimcore_migrations (`migration_set`,`version`,`migrated_at`) VALUES ('pimcore_core','20190904154339','2020-07-03 18:07:20');
INSERT INTO pimcore_migrations (`migration_set`,`version`,`migrated_at`) VALUES ('pimcore_core','20191015131700','2020-07-03 18:07:20');
INSERT INTO pimcore_migrations (`migration_set`,`version`,`migrated_at`) VALUES ('pimcore_core','20191107141816','2020-07-03 18:07:20');
INSERT INTO pimcore_migrations (`migration_set`,`version`,`migrated_at`) VALUES ('pimcore_core','20191114123638','2020-07-03 18:07:20');
INSERT INTO pimcore_migrations (`migration_set`,`version`,`migrated_at`) VALUES ('pimcore_core','20191114132014','2020-07-03 18:07:20');
INSERT INTO pimcore_migrations (`migration_set`,`version`,`migrated_at`) VALUES ('pimcore_core','20191121150326','2020-07-03 18:07:20');
INSERT INTO pimcore_migrations (`migration_set`,`version`,`migrated_at`) VALUES ('pimcore_core','20191125135853','2020-07-03 18:07:20');
INSERT INTO pimcore_migrations (`migration_set`,`version`,`migrated_at`) VALUES ('pimcore_core','20191125200416','2020-07-03 18:07:20');
INSERT INTO pimcore_migrations (`migration_set`,`version`,`migrated_at`) VALUES ('pimcore_core','20191126130004','2020-07-03 18:07:20');
INSERT INTO pimcore_migrations (`migration_set`,`version`,`migrated_at`) VALUES ('pimcore_core','20191208175348','2020-07-03 18:07:21');
INSERT INTO pimcore_migrations (`migration_set`,`version`,`migrated_at`) VALUES ('pimcore_core','20191213115045','2020-07-03 18:07:21');
INSERT INTO pimcore_migrations (`migration_set`,`version`,`migrated_at`) VALUES ('pimcore_core','20191218073528','2020-07-03 18:07:21');
INSERT INTO pimcore_migrations (`migration_set`,`version`,`migrated_at`) VALUES ('pimcore_core','20191230103524','2020-07-03 18:07:22');
INSERT INTO pimcore_migrations (`migration_set`,`version`,`migrated_at`) VALUES ('pimcore_core','20191230104529','2020-07-03 18:07:22');
INSERT INTO pimcore_migrations (`migration_set`,`version`,`migrated_at`) VALUES ('pimcore_core','20200113120101','2020-07-03 18:07:22');
INSERT INTO pimcore_migrations (`migration_set`,`version`,`migrated_at`) VALUES ('pimcore_core','20200116181758','2020-07-03 18:07:22');
INSERT INTO pimcore_migrations (`migration_set`,`version`,`migrated_at`) VALUES ('pimcore_core','20200121095650','2020-07-03 18:07:22');
INSERT INTO pimcore_migrations (`migration_set`,`version`,`migrated_at`) VALUES ('pimcore_core','20200121131304','2020-07-03 18:07:22');
INSERT INTO pimcore_migrations (`migration_set`,`version`,`migrated_at`) VALUES ('pimcore_core','20200127102432','2020-07-03 18:07:22');
INSERT INTO pimcore_migrations (`migration_set`,`version`,`migrated_at`) VALUES ('pimcore_core','20200129102132','2020-07-03 18:07:22');
INSERT INTO pimcore_migrations (`migration_set`,`version`,`migrated_at`) VALUES ('pimcore_core','20200210101048','2020-07-03 18:07:22');
INSERT INTO pimcore_migrations (`migration_set`,`version`,`migrated_at`) VALUES ('pimcore_core','20200210164037','2020-07-03 18:07:22');
INSERT INTO pimcore_migrations (`migration_set`,`version`,`migrated_at`) VALUES ('pimcore_core','20200211115044','2020-07-03 18:07:23');
INSERT INTO pimcore_migrations (`migration_set`,`version`,`migrated_at`) VALUES ('pimcore_core','20200212130011','2020-07-03 18:07:23');
INSERT INTO pimcore_migrations (`migration_set`,`version`,`migrated_at`) VALUES ('pimcore_core','20200218104052','2020-07-03 18:07:23');
INSERT INTO pimcore_migrations (`migration_set`,`version`,`migrated_at`) VALUES ('pimcore_core','20200226102938','2020-07-03 18:07:23');
INSERT INTO pimcore_migrations (`migration_set`,`version`,`migrated_at`) VALUES ('pimcore_core','20200310122412','2020-07-03 18:07:23');
INSERT INTO pimcore_migrations (`migration_set`,`version`,`migrated_at`) VALUES ('pimcore_core','20200313092019','2020-07-03 18:07:23');
INSERT INTO pimcore_migrations (`migration_set`,`version`,`migrated_at`) VALUES ('pimcore_core','20200317163018','2020-07-03 18:07:23');
INSERT INTO pimcore_migrations (`migration_set`,`version`,`migrated_at`) VALUES ('pimcore_core','20200318100042','2020-07-03 18:07:24');
INSERT INTO pimcore_migrations (`migration_set`,`version`,`migrated_at`) VALUES ('pimcore_core','20200324141723','2020-07-03 18:07:24');
INSERT INTO pimcore_migrations (`migration_set`,`version`,`migrated_at`) VALUES ('pimcore_core','20200407120641','2020-07-03 18:07:24');
INSERT INTO pimcore_migrations (`migration_set`,`version`,`migrated_at`) VALUES ('pimcore_core','20200407132737','2020-07-03 18:07:24');
INSERT INTO pimcore_migrations (`migration_set`,`version`,`migrated_at`) VALUES ('pimcore_core','20200407145422','2020-07-03 18:07:25');
INSERT INTO pimcore_migrations (`migration_set`,`version`,`migrated_at`) VALUES ('pimcore_core','20200410112354','2020-07-03 18:07:25');
INSERT INTO pimcore_migrations (`migration_set`,`version`,`migrated_at`) VALUES ('pimcore_core','20200421142950','2020-07-03 18:07:25');
INSERT INTO pimcore_migrations (`migration_set`,`version`,`migrated_at`) VALUES ('pimcore_core','20200422090352','2020-07-03 18:07:26');
INSERT INTO pimcore_migrations (`migration_set`,`version`,`migrated_at`) VALUES ('pimcore_core','20200428082346','2020-07-03 18:07:26');
INSERT INTO pimcore_migrations (`migration_set`,`version`,`migrated_at`) VALUES ('pimcore_core','20200428111313','2020-07-03 18:07:26');
INSERT INTO pimcore_migrations (`migration_set`,`version`,`migrated_at`) VALUES ('pimcore_core','20200529121630','2020-07-03 18:07:26');
INSERT INTO pimcore_migrations (`migration_set`,`version`,`migrated_at`) VALUES ('pimcore_core','20200604110336','2020-07-03 18:07:26');
INSERT INTO pimcore_migrations (`migration_set`,`version`,`migrated_at`) VALUES ('pimcore_core','20200703093410','2020-07-22 15:49:49');
INSERT INTO properties (`cid`,`ctype`,`cpath`,`name`,`type`,`data`,`inheritable`) VALUES ('1','document','/','language','text','cs','1');
INSERT INTO properties (`cid`,`ctype`,`cpath`,`name`,`type`,`data`,`inheritable`) VALUES ('1','document','/','navigation_name','text','Úvod','0');
INSERT INTO properties (`cid`,`ctype`,`cpath`,`name`,`type`,`data`,`inheritable`) VALUES ('1','document','/','navigation_title','text','Úvod','0');
INSERT INTO properties (`cid`,`ctype`,`cpath`,`name`,`type`,`data`,`inheritable`) VALUES ('1','document','/','titlePostfix','text','Pimweb','1');
INSERT INTO properties (`cid`,`ctype`,`cpath`,`name`,`type`,`data`,`inheritable`) VALUES ('1','document','/','titleSeparator','text',' - ','1');
INSERT INTO properties (`cid`,`ctype`,`cpath`,`name`,`type`,`data`,`inheritable`) VALUES ('3','document','/system','sitemap_xml_exclude','bool','1','1');
INSERT INTO properties (`cid`,`ctype`,`cpath`,`name`,`type`,`data`,`inheritable`) VALUES ('8','document','/o-nas','navigation_name','text','O nás','0');
INSERT INTO properties (`cid`,`ctype`,`cpath`,`name`,`type`,`data`,`inheritable`) VALUES ('8','document','/o-nas','navigation_title','text','O nás','0');
INSERT INTO properties (`cid`,`ctype`,`cpath`,`name`,`type`,`data`,`inheritable`) VALUES ('9','document','/kontakt','navigation_name','text','Kontakt','0');
INSERT INTO properties (`cid`,`ctype`,`cpath`,`name`,`type`,`data`,`inheritable`) VALUES ('9','document','/kontakt','navigation_title','text','Kontakt','0');
INSERT INTO properties (`cid`,`ctype`,`cpath`,`name`,`type`,`data`,`inheritable`) VALUES ('12','document','/ucet','elastic_search_exclude','bool','1','1');
INSERT INTO properties (`cid`,`ctype`,`cpath`,`name`,`type`,`data`,`inheritable`) VALUES ('12','document','/ucet','navigation_name','text','Účet','0');
INSERT INTO properties (`cid`,`ctype`,`cpath`,`name`,`type`,`data`,`inheritable`) VALUES ('12','document','/ucet','navigation_title','text','Účet','0');
INSERT INTO properties (`cid`,`ctype`,`cpath`,`name`,`type`,`data`,`inheritable`) VALUES ('12','document','/ucet','sitemap_xml_exclude','bool','1','1');
INSERT INTO properties (`cid`,`ctype`,`cpath`,`name`,`type`,`data`,`inheritable`) VALUES ('21','document','/mapa-stranek','navigation_name','text','Mapa stránek','0');
INSERT INTO properties (`cid`,`ctype`,`cpath`,`name`,`type`,`data`,`inheritable`) VALUES ('21','document','/mapa-stranek','navigation_title','text','Mapa stránek','0');
INSERT INTO properties (`cid`,`ctype`,`cpath`,`name`,`type`,`data`,`inheritable`) VALUES ('22','document','/aktuality','navigation_name','text','Aktuality','0');
INSERT INTO properties (`cid`,`ctype`,`cpath`,`name`,`type`,`data`,`inheritable`) VALUES ('22','document','/aktuality','navigation_title','text','Aktuality','0');
INSERT INTO properties (`cid`,`ctype`,`cpath`,`name`,`type`,`data`,`inheritable`) VALUES ('26','document','/prihlaseni','navigation_name','text','Přihlášení','0');
INSERT INTO properties (`cid`,`ctype`,`cpath`,`name`,`type`,`data`,`inheritable`) VALUES ('26','document','/prihlaseni','navigation_title','text','Přihlášení','0');
INSERT INTO properties (`cid`,`ctype`,`cpath`,`name`,`type`,`data`,`inheritable`) VALUES ('27','document','/ucet/zmena-hesla','navigation_name','text','Změna hesla','0');
INSERT INTO properties (`cid`,`ctype`,`cpath`,`name`,`type`,`data`,`inheritable`) VALUES ('27','document','/ucet/zmena-hesla','navigation_title','text','Změna hesla','0');
INSERT INTO properties (`cid`,`ctype`,`cpath`,`name`,`type`,`data`,`inheritable`) VALUES ('28','document','/ucet/profil','navigation_name','text','Profil','0');
INSERT INTO properties (`cid`,`ctype`,`cpath`,`name`,`type`,`data`,`inheritable`) VALUES ('28','document','/ucet/profil','navigation_title','text','Profil','0');
INSERT INTO search_backend_data (`id`,`fullpath`,`maintype`,`type`,`subtype`,`published`,`creationDate`,`modificationDate`,`userOwner`,`userModification`,`data`,`properties`) VALUES ('6','/notifikace/newsletter','document','email','email','1','1508244399','1516485543','2','2','ID: 6  \nPath: /notifikace/newsletter  \nDobrý den Děkujeme že jste se přihlásili k odběru našeho newletteru. Jestliže do newsletteru nepřihlásili dobrovolně nebo v budoucnu budete chtít odhlásit můžete použít nasledující odkaz odhlášení %Text(unsubscribeUrl) Pimweb ','language:cs titlePostfix:Pimweb titleSeparator: -  ');
INSERT INTO search_backend_data (`id`,`fullpath`,`maintype`,`type`,`subtype`,`published`,`creationDate`,`modificationDate`,`userOwner`,`userModification`,`data`,`properties`) VALUES ('7','/system/chybova-stranka','document','page','page','1','1508244399','1589189412','2','6','ID: 7  \nPath: /system/chybova-stranka  \nchybova-strankaUps! Zdá se že tato stránka není dostupná. Zkontrolujte URL adresu nebo pokračujte na hlavní stránku. Chybová system chybova stranka','language:cs titlePostfix:Pimweb titleSeparator: -  sitemap_xml_exclude:1 ');
INSERT INTO search_backend_data (`id`,`fullpath`,`maintype`,`type`,`subtype`,`published`,`creationDate`,`modificationDate`,`userOwner`,`userModification`,`data`,`properties`) VALUES ('8','/o-nas','document','page','page','1','1508244399','1557911103','2','5','ID: 8  \nPath: /o-nas  \no-nas O nás o nas','language:cs titlePostfix:Pimweb titleSeparator: -  navigation_name:O nás navigation_title:O nás ');
INSERT INTO search_backend_data (`id`,`fullpath`,`maintype`,`type`,`subtype`,`published`,`creationDate`,`modificationDate`,`userOwner`,`userModification`,`data`,`properties`) VALUES ('14','/notifikace/registrace','document','email','email','1','1508244399','1516485460','2','2','ID: 14  \nPath: /notifikace/registrace  \nDobrý den Děkujeme za registraci na našich stránkách %Text(siteUrl) . Pro dokončení registrace použijte následující odkaz %Text(activationUrl) Pimweb ','language:cs titlePostfix:Pimweb titleSeparator: -  ');
INSERT INTO search_backend_data (`id`,`fullpath`,`maintype`,`type`,`subtype`,`published`,`creationDate`,`modificationDate`,`userOwner`,`userModification`,`data`,`properties`) VALUES ('16','/notifikace/reset-hesla','document','email','email','1','1508244399','1516485532','2','2','ID: 16  \nPath: /notifikace/reset-hesla  \nDobrý den Na Vašem účtu bylo požádáno o resetování hesla. Heslo si můžete změnit přes nasledujúcí odkaz %Text(link) Pimweb ','language:cs titlePostfix:Pimweb titleSeparator: -  ');
INSERT INTO search_backend_data (`id`,`fullpath`,`maintype`,`type`,`subtype`,`published`,`creationDate`,`modificationDate`,`userOwner`,`userModification`,`data`,`properties`) VALUES ('24','/notifikace/pro-administratora-novy-kontaktni-formular','document','email','email','1','1508244399','1516485475','2','2','ID: 24  \nPath: /notifikace/pro-administratora-novy-kontaktni-formular  \nDobrý den v systému byl založen nový kontaktní formulář s klíčem %DataObject(form { method getKey }) . Obsah Jméno getFullName E-mail getEmail Telefon getPhone Zpráva getMessage Pimweb ','language:cs titlePostfix:Pimweb titleSeparator: -  ');
INSERT INTO search_backend_data (`id`,`fullpath`,`maintype`,`type`,`subtype`,`published`,`creationDate`,`modificationDate`,`userOwner`,`userModification`,`data`,`properties`) VALUES ('28','/ucet/profil','document','page','page','1','1508244399','1516528643','2','2','ID: 28  \nPath: /ucet/profil  \n Profil','language:cs titlePostfix:Pimweb titleSeparator: -  elastic_search_exclude:1 sitemap_xml_exclude:1 navigation_name:Profil navigation_title:Profil ');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES (';','cs','','1595500496','1595500496');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES (';','de','','1595500496','1595500496');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES (';','en','','1595500496','1595500496');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES (';','es','','1595500496','1595500496');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES (';','fa','','1595500496','1595500496');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES (';','fr','','1595500496','1595500496');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES (';','it','','1595500496','1595500496');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES (';','ja','','1595500496','1595500496');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES (';','nl','','1595500496','1595500496');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES (';','pl','','1595500496','1595500496');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES (';','pt_BR','','1595500496','1595500496');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES (';','ru','','1595500496','1595500496');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES (';','sk','','1595500496','1595500496');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES (';','sv','','1595500496','1595500496');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES (';','sv_FI','','1595500496','1595500496');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES (';','tr','','1595500496','1595500496');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES (';','uk','','1595500496','1595500496');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES (';','zh_Hans','','1595500496','1595500496');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('Activation code','cs','Aktivační kód','1508244399','1508244399');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('Activation code','en','Activation code','1508244399','1508244399');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('City','cs','Město','1508244399','1508244399');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('City','en','City','1508244399','1508244399');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('Company','cs','Společnost','1508244399','1508244399');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('Company','en','Company','1508244399','1508244399');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('Contact','cs','Kontakt','1508244399','1508244399');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('Contact','en','Contact','1508244399','1508244399');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('ContactForm','cs','Kontaktní formulář','1508244399','1508244399');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('ContactForm','en','Contact form','1508244399','1508244399');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('Content','cs','Obsah','1508244399','1508244399');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('Content','en','Content','1508244399','1508244399');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('Creation date','cs','Datum vytvoření','1508244399','1508244399');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('Creation date','en','Creation date','1508244399','1508244399');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('Czech','cs','Čeština','1508244399','1508244399');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('Czech','en','Czech','1508244399','1508244399');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('DIC','cs','DIČ','1508244399','1508244399');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('DIC','en','DIČ','1508244399','1508244399');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('Email','cs','E-mail','1508244399','1508244399');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('Email','en','E-mail','1508244399','1508244399');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('First name','cs','Jméno','1508244399','1508244399');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('First name','en','First name','1508244399','1508244399');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('Generate','cs','Generovat','1508244399','1508244399');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('Generate','en','Generate','1508244399','1508244399');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('IC','cs','IČ','1508244399','1508244399');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('IC','en','IČ','1508244399','1508244399');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('Language','cs','Jazyk','1508244399','1508244399');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('Language','en','Language','1508244399','1508244399');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('Last name','cs','Příjmení','1508244399','1508244399');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('Last name','en','Last name','1508244399','1508244399');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('Master','cs','','1508244399','1508244399');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('Master','en','','1508244399','1508244399');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('Master (Admin Mode)','cs','','1508244399','1508244399');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('Master (Admin Mode)','en','','1508244399','1508244399');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('Message','cs','Zpráva','1508244399','1508244399');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('Message','en','Message','1508244399','1508244399');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('Name','cs','Jméno (Název)','1508244399','1508244399');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('Name','en','Name','1508244399','1508244399');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('News','cs','Novinka','1508244399','1508244399');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('News','en','News','1508244399','1508244399');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('News(pl)','cs','Novinky','1508244399','1508244399');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('News(pl)','en','News','1508244399','1508244399');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('Newsletter','cs','Newsletter','1508244508','1508244508');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('Newsletter','en','Newsletter','1508244508','1508244508');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('NewsletterForm','cs','Newsletter formulář','1508244399','1508244399');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('NewsletterForm','en','Newsletter form','1508244399','1508244399');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('Password reset token','cs','Token k resetování hesla','1508244399','1508244399');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('Password reset token','en','Password reset token','1508244399','1508244399');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('Perex','cs','Perex','1508244399','1508244399');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('Perex','en','Perex','1508244399','1508244399');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('Phone','cs','Telefon','1508244399','1508244399');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('Phone','en','Phone','1508244399','1508244399');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('Preview image','cs','Náhledový obrázek','1508244399','1508244399');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('Preview image','en','Preview image','1508244399','1508244399');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('SEO','cs','','1589189241','1589189241');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('SEO','de','','1589189241','1589189241');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('SEO','en','','1589189241','1589189241');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('SEO','es','','1589189241','1589189241');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('SEO','fa','','1589189241','1589189241');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('SEO','fr','','1589189241','1589189241');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('SEO','it','','1589189241','1589189241');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('SEO','nl','','1589189241','1589189241');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('SEO','pl','','1589189241','1589189241');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('SEO','sk','','1589189241','1589189241');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('SEO','sv','','1589189241','1589189241');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('SEO','sv_FI','','1589189241','1589189241');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('SEO','tr','','1589189241','1589189241');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('SEO','zh_Hans','','1589189241','1589189241');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('Seo description','cs','SEO popisek','1508244399','1508244399');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('Seo description','en','SEO description','1508244399','1508244399');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('Simple page','cs','Jednoduchá stránka','1508244399','1508244399');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('Simple page','en','Simple page','1508244399','1508244399');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('Street','cs','Ulice','1508244399','1508244399');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('Street','en','Street','1508244399','1508244399');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('Url','cs','URL','1516791819','1516791819');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('Url','en','URL','1516791819','1516791819');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('User','cs','Uživatel','1508244399','1508244399');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('User','en','User','1508244399','1508244399');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('Users','cs','Uživatelé','1508244399','1508244399');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('Users','en','Users','1508244399','1508244399');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('Zip code','cs','PSČ','1508244399','1508244399');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('Zip code','en','Zip code','1508244399','1508244399');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('area_email','cs','E-mail','1508244399','1508244399');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('area_email','en','E-mail','1508244399','1508244399');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('area_email_description','cs',' ','1508244399','1508244399');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('area_email_description','en',' ','1508244399','1508244399');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('area_gallery','cs','Galerie','1508244399','1508244399');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('area_gallery','en','Gallery','1508244399','1508244399');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('area_gallery_description','cs',' ','1508244399','1508244399');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('area_gallery_description','en',' ','1508244399','1508244399');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('area_textblock','cs','Text','1508244399','1508244399');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('area_textblock','en','Text block','1508244399','1508244399');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('area_textblock_description','cs',' ','1508244399','1508244399');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('area_textblock_description','en',' ','1508244399','1508244399');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('base_page','cs','Base Page','1508244399','1508244399');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('base_page','en','Base Page','1508244399','1508244399');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('blog','cs','Blog','1508244399','1508244399');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('blog','en','Blog','1508244399','1508244399');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('bundle_ecommerce.back-office.order-list.filter-date.to','en','To Date','1593792439','1593792439');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('bundle_ecommerce.back-office.order-list.total-orders','en','Total Orders','1593792439','1593792439');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('bundle_ecommerce.back-office.order.cart-taxes','en','Cart Taxes','1593792439','1593792439');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('bundle_ecommerce.back-office.order.customer-account.orderCount','en','Order Count','1593792439','1593792439');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('bundle_ecommerce_mainmenu','ca','','1557165542','1557165542');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('bundle_ecommerce_mainmenu','cs','','1557165542','1557165542');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('bundle_ecommerce_mainmenu','de','','1557165542','1557165542');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('bundle_ecommerce_mainmenu','en','','1557165542','1557165542');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('bundle_ecommerce_mainmenu','es','','1557165542','1557165542');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('bundle_ecommerce_mainmenu','fa','','1557165542','1557165542');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('bundle_ecommerce_mainmenu','fr','','1557165542','1557165542');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('bundle_ecommerce_mainmenu','it','','1557165542','1557165542');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('bundle_ecommerce_mainmenu','ja','','1557165542','1557165542');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('bundle_ecommerce_mainmenu','nl','','1557165542','1557165542');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('bundle_ecommerce_mainmenu','pl','','1557165542','1557165542');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('bundle_ecommerce_mainmenu','pt','','1557165542','1557165542');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('bundle_ecommerce_mainmenu','pt_BR','','1557165542','1557165542');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('bundle_ecommerce_mainmenu','ru','','1557165542','1557165542');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('bundle_ecommerce_mainmenu','sk','','1557165542','1557165542');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('bundle_ecommerce_mainmenu','sv','','1557165542','1557165542');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('bundle_ecommerce_mainmenu','tr','','1557165542','1557165542');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('bundle_ecommerce_mainmenu','uk','','1557165542','1557165542');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('bundle_ecommerce_mainmenu','zh_Hans','','1557165542','1557165542');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('bundle_ecommerce_mainmenu','zh_Hant','','1557165542','1557165542');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('classname','cs','Název třídy','1508244399','1508244399');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('classname','en','Class name','1508244399','1508244399');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('creationdate','cs','Datum vytvoření','1508244399','1508244399');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('creationdate','en','Creation date','1508244399','1508244399');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('editor','cs','','1595358859','1595358859');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('editor','de','','1595358859','1595358859');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('editor','en','','1595358859','1595358859');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('editor','es','','1595358859','1595358859');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('editor','fa','','1595358859','1595358859');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('editor','fr','','1595358859','1595358859');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('editor','it','','1595358859','1595358859');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('editor','ja','','1595358859','1595358859');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('editor','nl','','1595358859','1595358859');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('editor','pl','','1595358859','1595358859');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('editor','pt_BR','','1595358859','1595358859');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('editor','ru','','1595358859','1595358859');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('editor','sk','','1595358859','1595358859');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('editor','sv','','1595358859','1595358859');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('editor','sv_FI','','1595358859','1595358859');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('editor','tr','','1595358859','1595358859');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('editor','uk','','1595358859','1595358859');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('editor','zh_Hans','','1595358859','1595358859');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('filename','cs','Název souboru (složky)','1508244399','1508244399');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('filename','en','Filename','1508244399','1508244399');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('firstname','cs','Jméno','1508244399','1508244399');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('firstname','en','First name','1508244399','1508244399');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('fullpath','cs','Cesta','1508244399','1508244399');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('fullpath','en','Full path','1508244399','1508244399');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('gender','cs','Pohlaví','1508244399','1508244399');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('gender','en','Gender','1508244399','1508244399');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('id','cs','ID','1508244399','1508244399');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('id','en','ID','1508244399','1508244399');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('lastname','cs','Příjmení','1508244399','1508244399');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('lastname','en','Last name','1508244399','1508244399');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('modificationdate','cs','Datum poslední modifikace','1508244399','1508244399');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('modificationdate','en','Modification date','1508244399','1508244399');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('newsletter active','cs','Newsletter aktivní','1508244399','1508244399');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('newsletter active','en','Newsletter active','1508244399','1508244399');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('newsletter confirmed','cs','Newsletter potvrzen','1508244399','1508244399');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('newsletter confirmed','en','Newsletter confirmed','1508244399','1508244399');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('newsletterActive','cs','Newsletter aktivní','1508333192','1508333192');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('newsletterActive','en','Newsletter active','1508333192','1508333192');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('newsletterConfirmed','cs','Newsletter potvrzen','1508333192','1508333192');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('newsletterConfirmed','en','Newsletter confirmed','1508333192','1508333192');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('password','cs','Heslo','1508244399','1508244399');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('password','en','Password','1508244399','1508244399');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('published','cs','Zveřejněno','1508244399','1508244399');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('published','en','Published','1508244399','1508244399');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('seo','cs','SEO','1508244399','1508244399');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('seo','en','SEO','1508244399','1508244399');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('seo slug','cs','SEO slug','1508244399','1508244399');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('seo slug','en','SEO slug','1508244399','1508244399');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('text','cs','Text','1508244399','1508244399');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('text','en','Text','1508244399','1508244399');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('unsubscribe code','cs','Kód k odhlášení z newsletteru','1508244399','1508244399');
INSERT INTO translations_admin (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('unsubscribe code','en','Unsubscribe code','1508244399','1508244399');
INSERT INTO translations_website (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('label_add','cs','Přidat','1508244399','1508244399');
INSERT INTO translations_website (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('label_agree_with_terms','cs','Souhlasím s <a href=\"/o-nas\" target=\"_blank\">podmínkami</a>','1508244399','1508244399');
INSERT INTO translations_website (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('label_change','cs','Změnit','1508244399','1508244399');
INSERT INTO translations_website (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('label_city','cs','Město','1508244399','1508244399');
INSERT INTO translations_website (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('label_color','cs','Barva','1508244399','1508244399');
INSERT INTO translations_website (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('label_company','cs','Firma','1508244399','1508244399');
INSERT INTO translations_website (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('label_dic','cs','DIČ','1508244399','1508244399');
INSERT INTO translations_website (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('label_edit','cs','Upravit','1508244399','1508244399');
INSERT INTO translations_website (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('label_email','cs','E-mail','1508244399','1508244399');
INSERT INTO translations_website (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('label_first_name','cs','Jméno','1508244399','1508244399');
INSERT INTO translations_website (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('label_first_page','cs','První stránka','1508244399','1508244399');
INSERT INTO translations_website (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('label_full_name','cs','Jméno','1508244399','1508244399');
INSERT INTO translations_website (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('label_ic','cs','IČ','1508244399','1508244399');
INSERT INTO translations_website (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('label_last_name','cs','Příjmení','1508244399','1508244399');
INSERT INTO translations_website (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('label_last_page','cs','Poslední stránka','1508244399','1508244399');
INSERT INTO translations_website (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('label_login','cs','Přihlásit','1508244399','1508244399');
INSERT INTO translations_website (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('label_message','cs','Zpráva','1508244399','1508244399');
INSERT INTO translations_website (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('label_message_text','cs','Text zprávy','1508244399','1508244399');
INSERT INTO translations_website (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('label_newsletter','cs','Přihlásit se k odběru newsletteru','1508244399','1508244399');
INSERT INTO translations_website (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('label_next_page','cs','Následující stránka','1508244399','1508244399');
INSERT INTO translations_website (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('label_password','cs','Heslo','1508244399','1508244399');
INSERT INTO translations_website (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('label_password_again','cs','Heslo znova','1508244399','1508244399');
INSERT INTO translations_website (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('label_password_new','cs','Nové heslo','1508244399','1508244399');
INSERT INTO translations_website (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('label_password_new_again','cs','Nove heslo znova','1508244399','1508244399');
INSERT INTO translations_website (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('label_password_old','cs','Staré heslo','1508244399','1508244399');
INSERT INTO translations_website (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('label_phone','cs','Telefon','1508244399','1508244399');
INSERT INTO translations_website (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('label_previous_page','cs','Předchozí stránka','1508244399','1508244399');
INSERT INTO translations_website (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('label_region1','cs','Moravskoslezský','1508244399','1508244399');
INSERT INTO translations_website (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('label_region10','cs','Pardubický','1508244399','1508244399');
INSERT INTO translations_website (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('label_region11','cs','Vysočina','1508244399','1508244399');
INSERT INTO translations_website (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('label_region12','cs','Jihomoravský','1508244399','1508244399');
INSERT INTO translations_website (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('label_region13','cs','Olomoucký','1508244399','1508244399');
INSERT INTO translations_website (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('label_region14','cs','Zlínský','1508244399','1508244399');
INSERT INTO translations_website (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('label_region2','cs','Středočeský','1508244399','1508244399');
INSERT INTO translations_website (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('label_region3','cs','Praha','1508244399','1508244399');
INSERT INTO translations_website (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('label_region4','cs','Jihočeský','1508244399','1508244399');
INSERT INTO translations_website (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('label_region5','cs','Plzeňský','1508244399','1508244399');
INSERT INTO translations_website (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('label_region6','cs','Karlovarský','1508244399','1508244399');
INSERT INTO translations_website (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('label_region7','cs','Ústecký','1508244399','1508244399');
INSERT INTO translations_website (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('label_region8','cs','Liberecký','1508244399','1508244399');
INSERT INTO translations_website (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('label_region9','cs','Královéhradecký','1508244399','1508244399');
INSERT INTO translations_website (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('label_register','cs','Registrovat','1508244399','1508244399');
INSERT INTO translations_website (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('label_registration_address','cs','Registrační adresa','1508244399','1508244399');
INSERT INTO translations_website (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('label_remember_me','cs','Zapamatovat','1508244399','1508244399');
INSERT INTO translations_website (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('label_reset_password','cs','Resetovat heslo','1508244399','1508244399');
INSERT INTO translations_website (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('label_search','cs','Hledat','1508244399','1508244399');
INSERT INTO translations_website (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('label_send_me_newsletter','cs','Chci odebírat newsletter','1508244399','1508244399');
INSERT INTO translations_website (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('label_street','cs','Ulice','1508244399','1508244399');
INSERT INTO translations_website (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('label_submit','cs','Odeslat','1508244399','1508244399');
INSERT INTO translations_website (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('label_submit_question','cs','Odeslat dotaz','1508244399','1508244399');
INSERT INTO translations_website (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('label_title','cs','Název','1508244399','1508244399');
INSERT INTO translations_website (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('label_zip_code','cs','PSČ','1508244399','1508244399');
INSERT INTO translations_website (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('msg_account_activated','cs','Účet %s byl aktivován.','1508244399','1508244399');
INSERT INTO translations_website (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('msg_activation_code_invalid','cs','Chyba - neplatný aktivační kód.','1508244399','1508244399');
INSERT INTO translations_website (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('msg_address_inserted','cs','Adresa byla vložena.','1508244399','1508244399');
INSERT INTO translations_website (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('msg_address_updated','cs','Adresa byla změněna.','1508244399','1508244399');
INSERT INTO translations_website (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('msg_agree_with_terms','cs','Musíte souhlasit s podmínkami','1508244399','1508244399');
INSERT INTO translations_website (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('msg_authentication_error','cs','Neplatné přihlašovací údaje.','1508244399','1508244399');
INSERT INTO translations_website (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('msg_authentication_required','cs','Pro přístup do této sekce se musíte přihlásit.','1516447628','1516447789');
INSERT INTO translations_website (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('msg_authentication_successful','cs','Přihlášení proběhlo úspěšně.','1508244399','1508244399');
INSERT INTO translations_website (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('msg_bad_format','cs','Údaj má nesprávný formát','1508244399','1508244399');
INSERT INTO translations_website (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('msg_bad_format_phone','cs','Zadejte prosím správné číslo telefonu s předvolbou a bez mezer (napr. +420123456789).','1508244399','1508244399');
INSERT INTO translations_website (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('msg_contact_form_success','cs','Kontaktní formulář byl odeslán.','1508244399','1508244399');
INSERT INTO translations_website (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('msg_email_not_registered','cs','Chyba - E-mail %s není registrován.','1508244399','1508244399');
INSERT INTO translations_website (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('msg_email_registered','cs','E-mail obsazen','1508244399','1508244399');
INSERT INTO translations_website (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('msg_email_registered_for_quick_registration','cs','Na zadaný e-mail již je vytvořen účet, přihlašte se prosím','1508244399','1508244399');
INSERT INTO translations_website (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('msg_empty_field','cs','Pole nesmí zůstat prázdné','1508244399','1508244399');
INSERT INTO translations_website (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('msg_file_not_uploaded','cs','Soubor se nepovedlo nahrát na server.','1508244399','1508244399');
INSERT INTO translations_website (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('msg_file_too_big','cs','Soubor je příliš velký.','1508244399','1508244399');
INSERT INTO translations_website (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('msg_form_invalid','cs','Zdá se, že formulář obsahuje chyby. Zkontrolujte a zkuste ho odoslat znovu.','1508244399','1508244399');
INSERT INTO translations_website (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('msg_invalid_email','cs','E-mail má nesprávný formát','1508244399','1508244399');
INSERT INTO translations_website (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('msg_invalid_request','cs','Neplatný požadavek.','1508244399','1508244399');
INSERT INTO translations_website (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('msg_invalid_token','cs','Neplatný token.','1508244399','1508244399');
INSERT INTO translations_website (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('msg_logout_successful','cs','Odhlášení proběhlo úspěšně.','1508244399','1508244399');
INSERT INTO translations_website (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('msg_newsletter_already_registered','cs','Chyba - E-mail %s již je registrován do newsletteru.','1508244399','1508244399');
INSERT INTO translations_website (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('msg_newsletter_code_invalid','cs','Chyba - neplatný kód pro odhlášení z newsletteru.','1508244399','1508244399');
INSERT INTO translations_website (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('msg_newsletter_registered','cs','E-mail %s byl zařazen do newsletteru.','1508244399','1508244399');
INSERT INTO translations_website (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('msg_newsletter_unsubscribed','cs','E-mail %s byl odstraněn z newsletteru.','1508244399','1508244399');
INSERT INTO translations_website (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('msg_no_items_found','cs','Zadaným kritériím nevyhovují žádné položky.','1508244399','1508244399');
INSERT INTO translations_website (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('msg_not_an_image','cs','Soubor není obrázkem.','1508244399','1508244399');
INSERT INTO translations_website (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('msg_password_change_successfull','cs','Heslo bylo změněno.','1508244399','1508244399');
INSERT INTO translations_website (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('msg_password_reset_successfull','cs','Na registrační e-mail %s Vám byl zaslán odkaz pro změnu hesla.','1508244399','1508244399');
INSERT INTO translations_website (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('msg_passwords_do_not_match','cs','Hesla se neshodují','1508244399','1508244399');
INSERT INTO translations_website (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('msg_profile_changed','cs','Profil byl úspěšně změněn','1516521457','1516522314');
INSERT INTO translations_website (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('msg_registration_successfull','cs','Registrace proběhla úspěšně. Na e-mail %s byli odeslány instrukce k aktivaci Vášho účtu.','1508244399','1508244399');
INSERT INTO translations_website (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('msg_select_file','cs','Vyberte soubor.','1508244399','1508244399');
INSERT INTO translations_website (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('msg_unknown_error','cs','Došlo k neznámé chybě.','1508244399','1508244399');
INSERT INTO translations_website (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('msg_wrong_old_password','cs','Staré heslo není správné','1508244399','1508244399');
INSERT INTO translations_website (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('system_an_error_occured','cs','Vyskytla se chyba.','1508244399','1508244399');
INSERT INTO translations_website (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('system_application_error','cs','500 - Chyba aplikace.','1508244399','1508244399');
INSERT INTO translations_website (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('system_empty_page','cs','Tato stránka nemá obsah a slouží pouze jako blok v stromové struktuře stránek.','1516541913','1516542041');
INSERT INTO translations_website (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('system_page_not_found','cs','404 - Stránka nenalezena.','1508244399','1508244399');
INSERT INTO translations_website (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('system_return_to_homepage','cs','Zpět na úvodní stránku.','1508244399','1508244399');
INSERT INTO translations_website (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('title_add_address','cs','Přidání adresy','1508244399','1508244399');
INSERT INTO translations_website (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('title_addresses_management','cs','Správa adres','1508244399','1508244399');
INSERT INTO translations_website (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('title_change_password','cs','Změna hesla','1508244399','1508244399');
INSERT INTO translations_website (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('title_edit_address','cs','Úprava adresy %s','1508244399','1508244399');
INSERT INTO translations_website (`key`,`language`,`text`,`creationDate`,`modificationDate`) VALUES ('title_orders_management','cs','Správa objednávek','1508244399','1508244399');
INSERT INTO users (`id`,`parentId`,`type`,`name`,`password`,`firstname`,`lastname`,`email`,`language`,`contentLanguages`,`admin`,`active`,`permissions`,`roles`,`welcomescreen`,`closeWarning`,`memorizeTabs`,`allowDirtyClose`,`docTypes`,`classes`,`apiKey`,`twoFactorAuthentication`,`activePerspective`,`perspectives`,`websiteTranslationLanguagesEdit`,`websiteTranslationLanguagesView`,`lastLogin`,`keyBindings`) VALUES ('0','0','user','system',NULL,NULL,NULL,NULL,NULL,NULL,'1','1',NULL,NULL,NULL,NULL,NULL,'1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO users (`id`,`parentId`,`type`,`name`,`password`,`firstname`,`lastname`,`email`,`language`,`contentLanguages`,`admin`,`active`,`permissions`,`roles`,`welcomescreen`,`closeWarning`,`memorizeTabs`,`allowDirtyClose`,`docTypes`,`classes`,`apiKey`,`twoFactorAuthentication`,`activePerspective`,`perspectives`,`websiteTranslationLanguagesEdit`,`websiteTranslationLanguagesView`,`lastLogin`,`keyBindings`) VALUES ('2','0','user','admin','$2y$10$YVpsUlZx3BU0de3UQt/SHugfczlNdfXZ9YVSKVJA9McBPKaQglWKq','','','','en','cs','1','1','application_logging,assets,backup,classes,clear_cache,clear_temp_files,dashboards,documents,document_types,emails,gdpr_data_extractor,glossary,http_errors,notes_events,objects,piwik_reports,piwik_settings,plugins,predefined_properties,qr_codes,recyclebin,redirects,reports,robots.txt,routes,seemode,seo_document_editor,share_configurations,system_settings,tags_assignment,tags_configuration,tags_search,tag_snippet_management,targeting,thumbnails,translations,users,website_settings,reports_config','','0','1','1','1','','','','{\"required\":false,\"enabled\":false,\"secret\":\"\",\"type\":\"\",\"\":null}','default','','','','0',NULL);
INSERT INTO users (`id`,`parentId`,`type`,`name`,`password`,`firstname`,`lastname`,`email`,`language`,`contentLanguages`,`admin`,`active`,`permissions`,`roles`,`welcomescreen`,`closeWarning`,`memorizeTabs`,`allowDirtyClose`,`docTypes`,`classes`,`apiKey`,`twoFactorAuthentication`,`activePerspective`,`perspectives`,`websiteTranslationLanguagesEdit`,`websiteTranslationLanguagesView`,`lastLogin`,`keyBindings`) VALUES ('3','0','role','editor',NULL,NULL,NULL,NULL,NULL,NULL,'0','1','assets,clear_cache,dashboards,documents,emails,notes_events,objects,qr_codes,recyclebin,reports,translations,reports_config',NULL,NULL,NULL,'1','1','1','4,5,6,10',NULL,NULL,NULL,'editor','','',NULL,NULL);
INSERT INTO users (`id`,`parentId`,`type`,`name`,`password`,`firstname`,`lastname`,`email`,`language`,`contentLanguages`,`admin`,`active`,`permissions`,`roles`,`welcomescreen`,`closeWarning`,`memorizeTabs`,`allowDirtyClose`,`docTypes`,`classes`,`apiKey`,`twoFactorAuthentication`,`activePerspective`,`perspectives`,`websiteTranslationLanguagesEdit`,`websiteTranslationLanguagesView`,`lastLogin`,`keyBindings`) VALUES ('4','0','user','editor','2850ba172924bfb6a64f902ee4a32691','','','','cs','cs','0','1',',reports_config','3','1','1','0','1','','','','{\"required\":false,\"enabled\":false,\"secret\":\"\",\"type\":\"\",\"\":null}','editor','','','','0',NULL);
INSERT INTO users (`id`,`parentId`,`type`,`name`,`password`,`firstname`,`lastname`,`email`,`language`,`contentLanguages`,`admin`,`active`,`permissions`,`roles`,`welcomescreen`,`closeWarning`,`memorizeTabs`,`allowDirtyClose`,`docTypes`,`classes`,`apiKey`,`twoFactorAuthentication`,`activePerspective`,`perspectives`,`websiteTranslationLanguagesEdit`,`websiteTranslationLanguagesView`,`lastLogin`,`keyBindings`) VALUES ('6','0','user','porta','$2y$10$/wv7/XYPRFw00CcQaGtZM.fnuNkqa4LbjTpazb76ENdja01hNoC/C',NULL,NULL,NULL,'en',NULL,'1','1','','','0','1','1','0','','',NULL,'null',NULL,'','','','1595495101',NULL);
INSERT INTO users_permission_definitions (`key`,`category`) VALUES ('admin_translations','');
INSERT INTO users_permission_definitions (`key`,`category`) VALUES ('application_logging','');
INSERT INTO users_permission_definitions (`key`,`category`) VALUES ('assets','');
INSERT INTO users_permission_definitions (`key`,`category`) VALUES ('asset_metadata','');
INSERT INTO users_permission_definitions (`key`,`category`) VALUES ('backup','');
INSERT INTO users_permission_definitions (`key`,`category`) VALUES ('classes','');
INSERT INTO users_permission_definitions (`key`,`category`) VALUES ('clear_cache','');
INSERT INTO users_permission_definitions (`key`,`category`) VALUES ('clear_fullpage_cache','');
INSERT INTO users_permission_definitions (`key`,`category`) VALUES ('clear_temp_files','');
INSERT INTO users_permission_definitions (`key`,`category`) VALUES ('dashboards','');
INSERT INTO users_permission_definitions (`key`,`category`) VALUES ('documents','');
INSERT INTO users_permission_definitions (`key`,`category`) VALUES ('document_types','');
INSERT INTO users_permission_definitions (`key`,`category`) VALUES ('emails','');
INSERT INTO users_permission_definitions (`key`,`category`) VALUES ('gdpr_data_extractor','');
INSERT INTO users_permission_definitions (`key`,`category`) VALUES ('glossary','');
INSERT INTO users_permission_definitions (`key`,`category`) VALUES ('http_errors','');
INSERT INTO users_permission_definitions (`key`,`category`) VALUES ('notes_events','');
INSERT INTO users_permission_definitions (`key`,`category`) VALUES ('notifications','');
INSERT INTO users_permission_definitions (`key`,`category`) VALUES ('notifications_send','');
INSERT INTO users_permission_definitions (`key`,`category`) VALUES ('objects','');
INSERT INTO users_permission_definitions (`key`,`category`) VALUES ('piwik_reports','');
INSERT INTO users_permission_definitions (`key`,`category`) VALUES ('piwik_settings','');
INSERT INTO users_permission_definitions (`key`,`category`) VALUES ('plugins','');
INSERT INTO users_permission_definitions (`key`,`category`) VALUES ('predefined_properties','');
INSERT INTO users_permission_definitions (`key`,`category`) VALUES ('qr_codes','');
INSERT INTO users_permission_definitions (`key`,`category`) VALUES ('recyclebin','');
INSERT INTO users_permission_definitions (`key`,`category`) VALUES ('redirects','');
INSERT INTO users_permission_definitions (`key`,`category`) VALUES ('reports','');
INSERT INTO users_permission_definitions (`key`,`category`) VALUES ('reports_config','');
INSERT INTO users_permission_definitions (`key`,`category`) VALUES ('robots.txt','');
INSERT INTO users_permission_definitions (`key`,`category`) VALUES ('routes','');
INSERT INTO users_permission_definitions (`key`,`category`) VALUES ('seemode','');
INSERT INTO users_permission_definitions (`key`,`category`) VALUES ('seo_document_editor','');
INSERT INTO users_permission_definitions (`key`,`category`) VALUES ('share_configurations','');
INSERT INTO users_permission_definitions (`key`,`category`) VALUES ('system_settings','');
INSERT INTO users_permission_definitions (`key`,`category`) VALUES ('tags_assignment','');
INSERT INTO users_permission_definitions (`key`,`category`) VALUES ('tags_configuration','');
INSERT INTO users_permission_definitions (`key`,`category`) VALUES ('tags_search','');
INSERT INTO users_permission_definitions (`key`,`category`) VALUES ('tag_snippet_management','');
INSERT INTO users_permission_definitions (`key`,`category`) VALUES ('targeting','');
INSERT INTO users_permission_definitions (`key`,`category`) VALUES ('thumbnails','');
INSERT INTO users_permission_definitions (`key`,`category`) VALUES ('translations','');
INSERT INTO users_permission_definitions (`key`,`category`) VALUES ('users','');
INSERT INTO users_permission_definitions (`key`,`category`) VALUES ('website_settings','');
INSERT INTO users_permission_definitions (`key`,`category`) VALUES ('workflow_details','');
INSERT INTO users_workspaces_asset (`cid`,`cpath`,`userId`,`list`,`view`,`publish`,`delete`,`rename`,`create`,`settings`,`versions`,`properties`) VALUES ('1','/','3','1','1','1','1','1','1','1','1','1');
INSERT INTO users_workspaces_document (`cid`,`cpath`,`userId`,`list`,`view`,`save`,`publish`,`unpublish`,`delete`,`rename`,`create`,`settings`,`versions`,`properties`) VALUES ('1','/','3','1','1','1','1','1','1','1','1','1','1','1');
INSERT INTO users_workspaces_document (`cid`,`cpath`,`userId`,`list`,`view`,`save`,`publish`,`unpublish`,`delete`,`rename`,`create`,`settings`,`versions`,`properties`) VALUES ('3','/system','3','0','0','0','0','0','0','0','0','0','0','0');
INSERT INTO users_workspaces_document (`cid`,`cpath`,`userId`,`list`,`view`,`save`,`publish`,`unpublish`,`delete`,`rename`,`create`,`settings`,`versions`,`properties`) VALUES ('5','/notifikace','3','1','1','1','1','1','1','1','1','1','1','1');
INSERT INTO users_workspaces_object (`cid`,`cpath`,`userId`,`list`,`view`,`save`,`publish`,`unpublish`,`delete`,`rename`,`create`,`settings`,`versions`,`properties`,`lEdit`,`lView`,`layouts`) VALUES ('2','/novinky','3','1','1','1','1','1','1','1','1','1','1','1',NULL,NULL,NULL);
INSERT INTO users_workspaces_object (`cid`,`cpath`,`userId`,`list`,`view`,`save`,`publish`,`unpublish`,`delete`,`rename`,`create`,`settings`,`versions`,`properties`,`lEdit`,`lView`,`layouts`) VALUES ('3','/uzivatele','3','1','1','1','1','1','0','0','0','1','1','1',NULL,NULL,NULL);
INSERT INTO users_workspaces_object (`cid`,`cpath`,`userId`,`list`,`view`,`save`,`publish`,`unpublish`,`delete`,`rename`,`create`,`settings`,`versions`,`properties`,`lEdit`,`lView`,`layouts`) VALUES ('4','/kontakt','3','1','1','1','1','1','1','0','0','1','1','1',NULL,NULL,NULL);


DROP VIEW IF EXISTS `object_10`;
CREATE ALGORITHM=UNDEFINED  VIEW `object_10` AS select `object_query_10`.`oo_id` AS `oo_id`,`object_query_10`.`oo_classId` AS `oo_classId`,`object_query_10`.`oo_className` AS `oo_className`,`object_query_10`.`email` AS `email`,`object_query_10`.`password` AS `password`,`object_query_10`.`activationCode` AS `activationCode`,`object_query_10`.`lang` AS `lang`,`object_query_10`.`firstName` AS `firstName`,`object_query_10`.`lastName` AS `lastName`,`object_query_10`.`phone` AS `phone`,`object_query_10`.`street` AS `street`,`object_query_10`.`city` AS `city`,`object_query_10`.`zipCode` AS `zipCode`,`object_query_10`.`company` AS `company`,`object_query_10`.`dic` AS `dic`,`object_query_10`.`passwordResetToken` AS `passwordResetToken`,`object_query_10`.`ic` AS `ic`,`objects`.`o_id` AS `o_id`,`objects`.`o_parentId` AS `o_parentId`,`objects`.`o_type` AS `o_type`,`objects`.`o_key` AS `o_key`,`objects`.`o_path` AS `o_path`,`objects`.`o_index` AS `o_index`,`objects`.`o_published` AS `o_published`,`objects`.`o_creationDate` AS `o_creationDate`,`objects`.`o_modificationDate` AS `o_modificationDate`,`objects`.`o_userOwner` AS `o_userOwner`,`objects`.`o_userModification` AS `o_userModification`,`objects`.`o_classId` AS `o_classId`,`objects`.`o_className` AS `o_className`,`objects`.`o_childrenSortBy` AS `o_childrenSortBy`,`objects`.`o_versionCount` AS `o_versionCount` from (`object_query_10` join `objects` on((`objects`.`o_id` = `object_query_10`.`oo_id`)));

DROP VIEW IF EXISTS `object_4`;
CREATE ALGORITHM=UNDEFINED  VIEW `object_4` AS select `object_query_4`.`oo_id` AS `oo_id`,`object_query_4`.`oo_classId` AS `oo_classId`,`object_query_4`.`oo_className` AS `oo_className`,`object_query_4`.`createdOn` AS `createdOn`,`object_query_4`.`previewImage__image` AS `previewImage__image`,`object_query_4`.`previewImage__hotspots` AS `previewImage__hotspots`,`objects`.`o_id` AS `o_id`,`objects`.`o_parentId` AS `o_parentId`,`objects`.`o_type` AS `o_type`,`objects`.`o_key` AS `o_key`,`objects`.`o_path` AS `o_path`,`objects`.`o_index` AS `o_index`,`objects`.`o_published` AS `o_published`,`objects`.`o_creationDate` AS `o_creationDate`,`objects`.`o_modificationDate` AS `o_modificationDate`,`objects`.`o_userOwner` AS `o_userOwner`,`objects`.`o_userModification` AS `o_userModification`,`objects`.`o_classId` AS `o_classId`,`objects`.`o_className` AS `o_className`,`objects`.`o_childrenSortBy` AS `o_childrenSortBy`,`objects`.`o_versionCount` AS `o_versionCount` from (`object_query_4` join `objects` on((`objects`.`o_id` = `object_query_4`.`oo_id`)));

DROP VIEW IF EXISTS `object_5`;
CREATE ALGORITHM=UNDEFINED  VIEW `object_5` AS select `object_query_5`.`oo_id` AS `oo_id`,`object_query_5`.`oo_classId` AS `oo_classId`,`object_query_5`.`oo_className` AS `oo_className`,`object_query_5`.`fullName` AS `fullName`,`object_query_5`.`email` AS `email`,`object_query_5`.`phone` AS `phone`,`object_query_5`.`message` AS `message`,`object_query_5`.`lang` AS `lang`,`objects`.`o_id` AS `o_id`,`objects`.`o_parentId` AS `o_parentId`,`objects`.`o_type` AS `o_type`,`objects`.`o_key` AS `o_key`,`objects`.`o_path` AS `o_path`,`objects`.`o_index` AS `o_index`,`objects`.`o_published` AS `o_published`,`objects`.`o_creationDate` AS `o_creationDate`,`objects`.`o_modificationDate` AS `o_modificationDate`,`objects`.`o_userOwner` AS `o_userOwner`,`objects`.`o_userModification` AS `o_userModification`,`objects`.`o_classId` AS `o_classId`,`objects`.`o_className` AS `o_className`,`objects`.`o_childrenSortBy` AS `o_childrenSortBy`,`objects`.`o_versionCount` AS `o_versionCount` from (`object_query_5` join `objects` on((`objects`.`o_id` = `object_query_5`.`oo_id`)));

DROP VIEW IF EXISTS `object_6`;
CREATE ALGORITHM=UNDEFINED  VIEW `object_6` AS select `object_query_6`.`oo_id` AS `oo_id`,`object_query_6`.`oo_classId` AS `oo_classId`,`object_query_6`.`oo_className` AS `oo_className`,`object_query_6`.`email` AS `email`,`object_query_6`.`lang` AS `lang`,`object_query_6`.`unsubscribeCode` AS `unsubscribeCode`,`object_query_6`.`firstname` AS `firstname`,`object_query_6`.`lastname` AS `lastname`,`object_query_6`.`gender` AS `gender`,`object_query_6`.`newsletterActive` AS `newsletterActive`,`object_query_6`.`newsletterConfirmed` AS `newsletterConfirmed`,`objects`.`o_id` AS `o_id`,`objects`.`o_parentId` AS `o_parentId`,`objects`.`o_type` AS `o_type`,`objects`.`o_key` AS `o_key`,`objects`.`o_path` AS `o_path`,`objects`.`o_index` AS `o_index`,`objects`.`o_published` AS `o_published`,`objects`.`o_creationDate` AS `o_creationDate`,`objects`.`o_modificationDate` AS `o_modificationDate`,`objects`.`o_userOwner` AS `o_userOwner`,`objects`.`o_userModification` AS `o_userModification`,`objects`.`o_classId` AS `o_classId`,`objects`.`o_className` AS `o_className`,`objects`.`o_childrenSortBy` AS `o_childrenSortBy`,`objects`.`o_versionCount` AS `o_versionCount` from (`object_query_6` join `objects` on((`objects`.`o_id` = `object_query_6`.`oo_id`)));

DROP VIEW IF EXISTS `object_localized_4_en`;
CREATE ALGORITHM=UNDEFINED  VIEW `object_localized_4_en` AS select `object_query_4`.`oo_id` AS `oo_id`,`object_query_4`.`oo_classId` AS `oo_classId`,`object_query_4`.`oo_className` AS `oo_className`,`object_query_4`.`createdOn` AS `createdOn`,`object_query_4`.`previewImage__image` AS `previewImage__image`,`object_query_4`.`previewImage__hotspots` AS `previewImage__hotspots`,`objects`.`o_id` AS `o_id`,`objects`.`o_parentId` AS `o_parentId`,`objects`.`o_type` AS `o_type`,`objects`.`o_key` AS `o_key`,`objects`.`o_path` AS `o_path`,`objects`.`o_index` AS `o_index`,`objects`.`o_published` AS `o_published`,`objects`.`o_creationDate` AS `o_creationDate`,`objects`.`o_modificationDate` AS `o_modificationDate`,`objects`.`o_userOwner` AS `o_userOwner`,`objects`.`o_userModification` AS `o_userModification`,`objects`.`o_classId` AS `o_classId`,`objects`.`o_className` AS `o_className`,`objects`.`o_childrenSortBy` AS `o_childrenSortBy`,`objects`.`o_versionCount` AS `o_versionCount`,`en`.`ooo_id` AS `ooo_id`,`en`.`language` AS `language`,`en`.`name` AS `name`,`en`.`url` AS `url`,`en`.`seoDescription` AS `seoDescription`,`en`.`perex` AS `perex`,`en`.`content` AS `content` from ((`object_query_4` join `objects` on((`objects`.`o_id` = `object_query_4`.`oo_id`))) left join `object_localized_query_4_en` `en` on((1 and (`object_query_4`.`oo_id` = `en`.`ooo_id`))));
