<?php

namespace AppBundle\Command;

use AppBundle\Service\Generator;
use Pimcore\Console\AbstractCommand;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;

class GeneratorClassMapCreateCommand extends AbstractCommand
{
	protected function configure()
	{
		$this
			->setName('generator:classmap-create')
			->setDescription('Create a pimcore classmap entry')
			->addArgument(
				'name',
				InputArgument::REQUIRED,
				'Class name in CamelCase'
			)
			->addOption(
				'nolist', 'l',
				InputOption::VALUE_NONE,
				'Do not create a list mapping',
				null
			);
	}

	protected function execute(InputInterface $input, OutputInterface $output)
	{
		$generator = new Generator();

		$name = $input->getArgument('name');
		$mapList = !$input->getOption('nolist');

		if ($generator->createClassMapping($name, $mapList)) {
			$output->writeln(sprintf('Class [%s] mapped', $name));
		} else {
			$output->writeln(sprintf(
				'<error>Class [%s] could not be mapped. See var/log/generator.log for details.</error>',
				$name)
			);
		}
	}
}
