<?php

namespace AppBundle\Controller;

use AppBundle\Service\ElasticSearch;
use AppBundle\Tool;
use AppBundle\Tool\Utils;
use AppBundle\Service\FeedManager;
use Pimcore\Model\Asset;
use Pimcore\Tool\Admin;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Component\HttpFoundation\BinaryFileResponse;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Response;

class DefaultController extends BaseController
{
	/*						DOCUMENT ROUTED ACTIONS							*/

	/**
	 * @return Response
	 */
	public function indexAction()
	{
	}

	/**
	 * @return Response
	 */
	public function defaultAction()
	{
	}
	
	/**
	 * @return Response
	 */
	public function errorPageAction()
	{
	}

	/**
	 * @return Response
	 */
	public function emptyPageAction()
	{
		if (!$this->editmode && !\Pimcore\Tool::isFrontendRequestByAdmin() && !($this->getRequest()->get('elastic_document_indexing'))) {
			$childs = $this->document->getChildren();
			if (empty($childs)) {
				return $this->createNotFoundException($this->translate('system_page_not_found'));
			} else {
				return $this->gotoUrl(current($childs)->getFullPath());
			}
		}
	}

	/* 						STATIC-ROUTE ROUTED ACTIONS						 */

	/*							VIEW-LESS ACTIONS							*/

	/**
	 * @Route("/admin/plugin/backend/is-elastic-search-enabled")
	 *
	 * @return JsonResponse
	 */
	public function isElasticSearchEnabledAction()
	{
		$this->disableViewAutoRender();

		$jsonResponse = new JsonResponse([
			'status' => true,
			'ese' => (Utils::elasticSearchEnabled() && Admin::getCurrentUser()->admin),
		]);

		return $jsonResponse;
	}

	/**
	 * @Route("/plugin/backend/reindex-elastic-search")
	 *
	 * @return JsonResponse
	 */
	public function reindexElasticAction()
	{
		$this->disableViewAutoRender();

		$responseData = ['status' => false];

		if (Utils::elasticSearchEnabled() && Admin::getCurrentUser()->admin) {
			Tool\ElasticSearch::updateIndicesAndReindexContent(true, true);
			$responseData = ['status' => true];
		}

		$jsonResponse = new JsonResponse($responseData);

		return $jsonResponse;
	}

	/**
	 * @Route("/api/search/{query}")
	 */
	public function searchAction(ElasticSearch $elastic, string $query): JsonResponse
	{
		$this->disableViewAutoRender();

		$responseData = [];
		if (Utils::elasticSearchEnabled()) {
			$responseData = $elastic->fulltextSearch(['query' => $query]);
			//$responseData = $elastic->getNews(['query' => $query]);
		}

		$jsonResponse = new JsonResponse($responseData);

		return $jsonResponse;
	}

	/**
	 * @param int $id
	 *
	 * @return BinaryFileResponse
	 */
	public function downloadAssetAction($id)
	{
		$this->disableViewAutoRender();

		$asset = Asset::getById($id);
		if (!$asset) {
			$this->addErrorMsg($this->translate('msg_invalid_request'));

			return $this->gotoUrl($this->docUrl('/'));
		}

		$filename = substr(basename($asset->getFilename()), (stripos($asset->getFilename(), '_')) ? stripos($asset->getFilename(), '_') + 1 : 0);

		$fileResponse = BinaryFileResponse::create($asset->getFileSystemPath());
		$fileResponse->setContentDisposition('attachment', $filename);

		return $fileResponse;
	}

	/**
	 * @param FeedManager $feedManager
	 *
	 * @return Response XML file
	 */
	public function sitemapXmlAction(FeedManager $feedManager)
	{
		$this->disableViewAutoRender();

		$xml = $feedManager->generateSitemapXml();

		$xmlResponse = new Response($xml);
		$xmlResponse->headers->set('Content-Type', 'xml');
		$xmlResponse->headers->set('Content-Disposition', 'attachment; filename=sitemap.xml');

		return $xmlResponse;
	}

	/*							FORM HANDLERS								*/
}
