<?php

namespace AppBundle\Model;

use AppBundle\Tool\Utils;
use Pimcore\Model\DataObject;

class News extends DataObject\News implements IElasticObjectFulltext, IElasticObject
{
	use ElasticTrait;

	/*								Helpers										*/

	/*								Mapped										*/

	/**
	 * {@inheritdoc}
	 */
	public function save()
	{
		parent::save();

		if (Utils::elasticSearchEnabled()) {
			$this->elasticSearchUpdate();
			$this->elasticSearchUpdateFulltext();
		}
	}

	/**
	 * {@inheritdoc}
	 */
	public function delete(bool $isNested = false)
	{
		if (Utils::elasticSearchEnabled()) {
			$this->elasticSearchDelete();
			$this->elasticSearchDeleteFulltext();
		}

		parent::delete($isNested);
	}

	/* 								For elastic search							 */

	public function elasticSearchLoadFulltext(string $lang): array
	{
		$data = array_merge($this->getElasticBaseData(), [
			'path' => $this->getUrl($lang),
			'title' => $this->getName($lang),
			'description' => $this->getSeoDescription($lang),
			'content' => $this->renderView('Cms/newsDetail.html.php', $lang, [
				'news' => $this,
			]),
		]);

		return $data;
	}

	public function elasticSearchLoad(string $lang, $extend = []): array
	{
		Utils::forceInheritanceAndFallbackValues();

		$data = array_merge($this->getElasticBaseData(), [
			'name' => $this->getName($lang),
			'url' => $this->getUrl($lang),
		]);

		$data = array_replace_recursive($data, $extend);

		Utils::restoreInheritanceAndFallbackValues();
		return $data;
	}
}
