<?php

namespace AppBundle\Service;

use AppBundle\Tool\Utils;
use Pimcore\Cache;
use Pimcore\Logger;
use Pimcore\Model\DataObject;
use Pimcore\Model\DataObject\Data\CalculatedValue;

class ValueCalculator
{
	/**
	 * @param DataObject\Concrete $object
	 * @param CalculatedValue     $context
	 *
	 * @return string
	 */
	public static function compute($object, $context, $editmode = false)
	{
		if (Cache\Runtime::isRegistered('routesSwitchEditmode')
				&& Cache\Runtime::get('routesSwitchEditmode')) {
			$editmode = true;
		}
		switch ($context->getFieldname()) {
			case 'url':
				return self::getUrl($object, $context->getPosition());
			default:
				Logger::error('CALCULATING VALUE - unsupported field name: '.$context->getFieldname());
				break;
		}
	}

	/**
	 * @param DataObject\Concrete $object
	 * @param CalculatedValue     $context
	 *
	 * @return string
	 */
	public static function getCalculatedValueForEditMode($object, $context)
	{
		return self::compute($object, $context, true);
	}

	/**
	 * @param DataObject\Concrete $object
	 * @param string              $language
	 *
	 * @return string
	 */
	public static function getUrl($object, $language = null, $params = [])
	{
		if (!$language) {
			$language = Utils::getDefaultLanguage();
		}

		$realObject = ($object instanceof DataObject\Concrete);
		$url = '';
		$className = ($realObject) ? $object->getClassName() : $object;
		switch ($className) {
			// for id + slug pages
			case 'News':
				if ($realObject) {
					$slug = Utils::webalize(trim($object->getName($language)));
					if (!$slug) {
						return;
					}
					$params = [
						'id' => $object->getId(),
						'slug' => $slug,
					];
				}
				//static route names must match this normalized class name + language
				$staticRouteKey = ltrim(strtolower(preg_replace('/[A-Z]/', '-$0', $className.'-'.$language)), '-');
				$url = Utils::url($staticRouteKey, $params);
				break;
		}

		return $url;
	}
}
