<?php

namespace Website\Model;

class MailManager
{
	public function sendMail($pathOrTemplate, $language, $to = null, $from = null, $params = null, \Zend_Mime_Part $attachment = null, $replyTo = null)
	{
		if ($pathOrTemplate instanceof \Pimcore\Model\Document\Email) {
			$document = $pathOrTemplate;
		} else {
			$document = \Pimcore\Model\Document\Email::getByPath($pathOrTemplate);
			if (!$document) {
				return false;
			}
			// try to load translated template
			if ($document->getProperty('language') != $language) {
				$service = new \Pimcore\Model\Document\Service();
				$translations = $service->getTranslations($document);
				if (isset($translations[$language])) {
					$translatedDocument = \Pimcore\Model\Document\Email::getById($translations[$language]);
					if ($translatedDocument) {
						$document = $translatedDocument;
					}
				}
			}
		}
		if (!$document instanceof \Pimcore\Model\Document\Email) {
			return false;
		}

		$mailer = new \Pimcore\Mail('utf-8');

		if ($to) {
			$document->setTo($to);
		}
		if ($from) {
			$document->setFrom($from);
		}

		$mailer->setDocument($document);

		if ($replyTo) {
			$mailer->setReplyTo($replyTo);
		}
		if ($params) {
			$mailer->setParams($params);
		}
		// try to load attachment from "attachment" property if not passed directly
		if (!$attachment) {
			$attachment = self::loadAttachmentFromProperty($document, $language);
		}
		if ($attachment) {
			$mailer->addAttachment($attachment);
		}

		try {
			$mailer->send();

			return true;
		} catch (\Exception $e) {
			\Pimcore\Logger::error('MAIL - '.$e->getMessage()."\n".$e->getTraceAsString());

			return false;
		}
	}

	private static function loadAttachmentFromProperty($pathOrTemplate, $language)
	{
		if ($pathOrTemplate instanceof \Pimcore\Model\Document\Email) {
			$document = $pathOrTemplate;
		} else {
			$document = \Pimcore\Model\Document\Email::getByPath($pathOrTemplate);
			if (!$document) {
				return;
			}
			// try to load translated template
			if ($document->getProperty('language') != $language) {
				$service = new \Pimcore\Model\Document\Service();
				$translations = $service->getTranslations($document);
				if (isset($translations[$language])) {
					$translatedDocument = \Pimcore\Model\Document\Email::getById($translations[$language]);
					if ($translatedDocument) {
						$document = $translatedDocument;
					}
				}
			}
		}

		$attachment = null;
		$asset = $document->getProperty('attachment');
		if ($asset instanceof \Pimcore\Model\Asset) {
			$attachment = new \Zend_Mime_Part($asset->getData());
			$attachment->disposition = \Zend_Mime::DISPOSITION_ATTACHMENT;
			$attachment->encoding = \Zend_Mime::ENCODING_BASE64;
			$attachment->filename = $asset->getFilename(); // name of file
		}

		return $attachment;
	}
}
