<?php

namespace Website\Tool\Console\Command;

use Pimcore\Console\AbstractCommand;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;

class GeneratorAreaCreateCommand extends AbstractCommand
{
	protected function configure()
	{
		$this
			->setName('generator:area-create')
			->setDescription('Create a pimcore area skeleton')
			->addArgument(
				'name',
				InputArgument::REQUIRED,
				'Area name in lowercase'
			)
			->addOption(
				'icon', 'i',
				InputOption::VALUE_REQUIRED,
				'Path to an icon file relative to the website root'
			);
	}

	protected function execute(InputInterface $input, OutputInterface $output)
	{
		$generator = new \Website\Tool\Generator();

		$name = strtolower($input->getArgument('name'));
		$icon = $generator->normalizePathParam($input->getOption('icon'));

		if ($generator->createArea($name, $icon)) {
			$output->writeln(sprintf('Area [%s] created', $name));
		} else {
			$output->writeln(sprintf(
				'<error>Area [%s] could not be created. See /website/var/log/generator.log for details.</error>',
				$name
			));
		}
	}
}
