<?php

/**
 * Simple newsletter form, without decorators.
 */
namespace Website\Form;

class NewsletterForm extends Base
{
	public function init()
	{
		parent::init();

		$this->setName('newsletter');
		$locale = \Zend_Registry::get('Zend_Locale');
		$this->setAction(\Website\Tool\Utils::url('newsletter-subscribe', ['language' => $locale->getLanguage()]));

		//elements
		$email = new \Zend_Form_Element_Text('email');
		$email->setRequired(true)
			->setLabel('label_newsletter')
			->addFilter('StripTags')
			->addFilter('StringTrim')
			->addValidator($this->notEmptyValidator)
			->addValidator($this->emailValidator);

		$this->addElements([$email]);

		//remove decorators
		$this->setElementDecorators(['ViewHelper']);

		$this->setUpJsValidation();
	}
}
