<?php

namespace Website\Form;

class RegistrationForm extends Base
{
	public function init()
	{
		parent::init();
		$this->setName('registration');

		//elements
		$email = new \Zend_Form_Element_Text('email');
		$email->setRequired(true)
			->setLabel('label_email')
			->addFilter('StripTags')
			->addFilter('StringTrim')
			->addValidator($this->notEmptyValidator)
			->addValidator($this->emailValidator);

		$password = new \Zend_Form_Element_Password('password');
		$password->setRequired(true)
			->setLabel('label_password')
			->addFilter('StripTags')
			->addFilter('StripTags')
			->addValidator($this->notEmptyValidator)
			->addValidator($this->passwordLengthValidator);

		$password_again = new \Zend_Form_Element_Password('password_again');
		$password_again->setRequired(true)
			->setLabel('label_password_again')
			->addFilter('StripTags')
			->addFilter('StripTags')
			->addValidator($this->notEmptyValidator)
			->addValidator($this->passwordLengthValidator)
			->addValidator($this->passwordIdenticalValidator);

		$firstName = new \Zend_Form_Element_Text('firstName');
		$firstName->setRequired(true)
			->setLabel('label_first_name')
			->addFilter('StripTags')
			->addFilter('StringTrim')
			->addValidator($this->notEmptyValidator);

		$lastName = new \Zend_Form_Element_Text('lastName');
		$lastName->setRequired(true)
			->setLabel('label_last_name')
			->addFilter('StripTags')
			->addFilter('StringTrim')
			->addValidator($this->notEmptyValidator);

		$phone = new \Zend_Form_Element_Text('phone');
		$phone->setRequired(false)
			->setLabel('label_phone')
			->addFilter('StripTags')
			->addFilter('StringTrim')
			->addFilter('PregReplace', ['match' => '/ /', 'replace' => ''])
			->addValidator($this->phoneValidator);

		$street = new \Zend_Form_Element_Text('street');
		$street->setRequired(true)
			->setLabel('label_street')
			->addFilter('StripTags')
			->addFilter('StringTrim')
			->addValidator($this->notEmptyValidator);

		$city = new \Zend_Form_Element_Text('city');
		$city->setRequired(true)
			->setLabel('label_city')
			->addFilter('StripTags')
			->addFilter('StringTrim')
			->addValidator($this->notEmptyValidator);

		$zipCode = new \Zend_Form_Element_Text('zipCode');
		$zipCode->setRequired(true)
			->setLabel('label_zip_code')
			->addFilter('StripTags')
			->addFilter('StringTrim')
			->addFilter('PregReplace', ['match' => '/ /', 'replace' => ''])
			->addValidator($this->notEmptyValidator)
			->addValidator($this->zipCodeValidator);

		$company = new \Zend_Form_Element_Text('company');
		$company->setRequired(false)
			->setLabel('label_company')
			->addFilter('StripTags')
			->addFilter('StringTrim');

		$ico = new \Zend_Form_Element_Text('ico');
		$ico->setRequired(false)
			->setLabel('label_ic')
			->addFilter('StripTags')
			->addFilter('StringTrim');

		$dic = new \Zend_Form_Element_Text('dic');
		$dic->setRequired(false)
			->setLabel('label_dic')
			->addFilter('StripTags')
			->addFilter('StringTrim');

		$newsletter = new \Zend_Form_Element_Checkbox('newsletter');
		$newsletter->setRequired(false)
			->setAttrib('disableHidden', true)
			->setLabel('label_send_me_newsletter')
			->setValue(1)
			->addFilter('StripTags')
			->addFilter('StringTrim');

		$agreed = new \Zend_Form_Element_Checkbox('agreed');
		$agreed->setRequired(true)
			->setAttrib('disableHidden', true)
			->setLabel('label_agree_with_terms')
			->addFilter('StripTags')
			->addFilter('StringTrim')
			->addValidator($this->notEmptyValidator);

		$formName = new \Zend_Form_Element_Hidden('formName');
		$formName->setValue($this->getName());

		$submit = new \Zend_Form_Element_Button('send');
		$submit->setLabel('label_register')
			->setAttrib('type', 'submit');

		$this->addElements([
			$email,
			$password,
			$password_again,
			$firstName,
			$lastName,
			$phone,
			$street,
			$city,
			$zipCode,
			$company,
			$ico,
			$dic,
			$newsletter,
			$agreed,
			$formName,
			$submit,
		]);

		//remove decorators
		$this->setElementDecorators(['ViewHelper']);

		$this->setUpJsValidation();
	}
}
