<?php

namespace Website\Tool\Console\Command;

use Pimcore\Console\AbstractCommand;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;

class DeploymentFieldcollectionUpdateCommand extends AbstractCommand
{
	protected function configure()
	{
		$this
			->setName('deployment:fieldcollection-update')
			->setDescription('Create or update fieldcollection based on its definition file')
			->addArgument(
				'key',
				InputArgument::REQUIRED,
				'Fieldcollection key'
			);
	}

	protected function execute(InputInterface $input, OutputInterface $output)
	{
		$key = trim($input->getArgument('key'));
		try {
			$fc = \Pimcore\Model\Object\Fieldcollection\Definition::getByKey($key);
			$fc->save();
			$output->writeln(sprintf('Fieldcollection %s updated', $key));
		} catch (\Exception $e) {
			$output->writeln(sprintf(
				'<error>Error updating fieldcollection %s: %s</error>',
				$key,
				$e->getMessage()
			));
		}
	}
}
